# Copyright (c) 1995 by the Student Information Processing Board
# 	  of the Massachusetts Institute of Technology
#  
# Permission to use, copy, modify, and distribute this software
# and its documentation for any purpose and without fee is
# hereby granted, provided that the above copyright notice
# appear in all copies and that both that copyright notice and
# this permission notice appear in supporting documentation,
# and that the names of M.I.T. and the M.I.T. S.I.P.B. not be
# used in advertising or publicity pertaining to distribution
# of the software without specific, written prior permission.
# M.I.T. and the M.I.T. S.I.P.B. make no representations about
# the suitability of this software for any purpose.  It is
# provided "as is" without express or implied warranty.
#
#	$Id: mail.sh,v 1.4 1996/06/01 18:38:51 ghudson Exp $
#	$Source: /afs/sipb/project/sipb-athena/src/install/arch/i386_nbsd1/RCS/mail.sh,v $

# environment inputs:
#	SYMBOLS		kernel symbols, for dmesg

# /tmp/vars inputs:
#	revision	install.sh revision number
#	on_mitnet	whether the machine is on MITnet
#	enable_toor	whether to enable the toor account
#	rootmail	where to forward root mail
#	mail		whether to send configuration mail
#	mail_cc		where to cc configuration mail to
#	action		what to do after installing
#	subscribe	whether to subscribe to netbsd-announce
#	username	username, if subscribing to netbsd-announce

. /tmp/vars
. /utils

if [ "$mail" != "yes" ]; then
	exit 0
fi

if [ "$subscribe" = yes ]; then
	subscribemsg="yes ($username)"
else
	subscribemsg=no
fi

echo -n "Mailing configuration info... "
(
cat << EOF
To: netbsd-install@mit.edu (NetBSD installation logger)
Cc: $mail_cc
From: netbsd-install@mit.edu (NetBSD installation pseudouser)
Subject: New NetBSD/i386 install

---------Parameters:-----------------------------------------------------
    Installation took place on MITnet:  $on_mitnet
    toor account enabled:		$enable_toor
    Root mail forwarded to:		$rootmail
    Action selected after install:	$action
    Subscribed to netbsd-announce:	$subscribemsg
    Version of install.sh:              $revision
---------mount output:---------------------------------------------------
`mount`
---------Sysctl-based information:---------------------------------------
`sysctl kern hw`
---------dmesg output:---------------------------------------------------
`dmesg 2> /dev/null`
---------ifconfig output:------------------------------------------------
`ifconfig -a`
-------------------------------------------------------------------------
EOF
) | sendmail -oQ/mnt/var/spool/mqueue -t -f netbsd-install@mit.edu
echo "done"

