/*
 * $Source: /afs/sipb/project/sipb-athena/kerberos/include/RCS/osconf.h,v $
 * $Author: ghudson $
 * $Header: /afs/sipb/project/sipb-athena/kerberos/include/RCS/osconf.h,v 1.3 1995/06/10 18:12:19 ghudson Exp $
 *
 * Copyright 1988 by the Massachusetts Institute of Technology.
 *
 * For copying and distribution information, please see the file
 * <mit-copyright.h>.
 *
 * Athena configuration.
 */

#include <mit-copyright.h>


#ifdef sgi
#include "conf-sgi.h"
#define KRBTYPE sgi
#endif

#ifdef tahoe
#include "conf-bsdtahoe.h"
#define KRBTYPE bsdtahoe
#endif

#ifdef vax
#include "conf-bsdvax.h"
#define KRBTYPE bsdvax
#endif

#if defined(mips) && defined(ultrix)
#include "conf-ultmips2.h"
#define KRBTYPE ultmips2
#endif /* !Ultrix MIPS-2 */

#ifdef ibm032
#include "conf-bsdibm032.h"
#define KRBTYPE bsdibm032
#endif /* !ibm032 */

#ifdef apollo
#include "conf-bsdapollo.h"
#define KRBTYPE bsdapollo
#endif /* !apollo */

#ifdef sun
#ifdef sparc
#ifdef __svr4__
#include "conf-sol20sparc.h"
#define KRBTYPE sol20sparc
#else /* sun, sparc, not solaris */
#include "conf-bsdsparc.h"
#define KRBTYPE bsdsparc
#endif /* sun, sparc */
#else /* sun but not sparc */
#ifdef i386
#include "conf-bsd386i.h"
#define KRBTYPE bsd386i
#else /* sun but not (sparc or 386i) */
#include "conf-bsdm68k.h"
#define KRBTYPE bsdm68k
#endif /* i386 */
#endif /* sparc */
#endif /* !sun */

#ifdef pyr
#include "conf-pyr.h"
#define KRBTYPE pyr
#endif

#ifdef _AUX_SOURCE
#include "conf-aux.h"
#define KRBTYPE aux
#endif

#ifdef _AIX
#ifdef _IBMR2
#include "conf-aixrios.h"
#define KRBTYPE aixrios
#endif /* risc/6000 */
#ifdef i386
#include "conf-aixps2.h"
#define KRBTYPE aixps2
#endif
#endif

#ifdef hpux
#ifdef hppa
#include "conf-hpsnake.h"
#define KRBTYPE hpsnake
#endif
#ifdef hp9000s300
#include "conf-hp68k.h"
#define KRBTYPE hp68k
#endif
#endif

#ifdef NeXT
#include "conf-next.h"
#define KRBTYPE next
#endif

#ifdef __SCO__
#include "conf-sco386.h"
#define KRBTYPE sco386
#endif

#ifdef linux
#include "conf-linux386.h"
#define KRBTYPE linux386
#endif

#ifdef __386BSD__
#include "conf-386bsd.h"
#define KRBTYPE 386bsd
#endif

#ifdef __NetBSD__
#ifdef __i386__
#include "conf-netbsd-i386.h"
#define KRBTYPE NetBSDi386
#endif /* i386 */
#ifdef __sparc__
#include "conf-netbsd-sparc.h"
#define KRBTYPE NetBSDsparc
#endif /* sparc */
#ifdef __m68k__
#include "conf-netbsd-m68k.h"
#define KRBTYPE NetBSDm68k
#endif /* m68k */
#endif

#ifdef __i960__
#include "conf-i960vx.h"
#define KRBTYPE i960vx
#endif

#ifdef __alpha
#include "conf-alpha.h"
#define KRBTYPE alpha
#endif

#ifndef KRBTYPE
/*#*/ error "configuration failed to recognize system type"
#endif
