/*
 * $Source: /local/cvsfiles/kerberos/src/lib/krb/get_phost.c,v $
 * $Author: eichin $
 *
 * Copyright 1988 by the Massachusetts Institute of Technology.
 *
 * For copying and distribution information, please see the file
 * <mit-copyright.h>.
 */

#ifndef lint
static char *rcsid_phost_c =
"$Header: /local/cvsfiles/kerberos/src/lib/krb/get_phost.c,v 1.3 1993/03/17 00:50:50 eichin Exp $";
#endif /* lint */

#include <mit-copyright.h>
#include <stdio.h>
#include <ctype.h>
#include <netdb.h>
/* possible flags */
#include <osconf.h>
#include <string.h>

/*
 * This routine takes an alias for a host name and returns the first
 * field, lower case, of its domain name.  For example, if "menel" is
 * an alias for host officially named "menelaus" (in /etc/hosts), for
 * the host whose official name is "MENELAUS.MIT.EDU", the name "menelaus"
 * is returned.
 *
 * This is done for historical Athena reasons: the Kerberos name of
 * rcmd servers (rlogin, rsh, rcp) is of the form "rcmd.host@realm"
 * where "host"is the lowercase for of the host name ("menelaus").
 * This should go away: the instance should be the domain name
 * (MENELAUS.MIT.EDU).  But for now we need this routine...
 *
 * A pointer to the name is returned, if found, otherwise a pointer
 * to the original "alias" argument is returned.
 */

char * krb_get_phost(alias)
    char *alias;
{
    struct hostent *h;
    char *p, *phost = alias;
#ifdef DO_REVERSE_RESOLVE
	char *rev_addr; int rev_type, rev_len;
#endif

    if ((h=gethostbyname(alias)) != (struct hostent *)NULL ) {
#ifdef DO_REVERSE_RESOLVE
	if (! h->h_addr_list ||! h->h_addr_list[0]) {
		return(0);
	}
	rev_type = h->h_addrtype;
	rev_len = h->h_length;
	rev_addr = malloc(rev_len);
	memcpy(rev_addr, h->h_addr_list[0], rev_len);
	h = gethostbyaddr(rev_addr, rev_len, rev_type);
	free(rev_addr);
	if (h == 0) {
		return (0);
	}
#endif
	p = strchr( h->h_name, '.' );
        if (p)
            *p = 0;
        p = phost = h->h_name;
        do {
            if (isupper(*p)) *p=tolower(*p);
        } while (*p++);
    }
    return(phost);
}
