#!/bin/sh
echo "If you've unpacked the tape in /usr/kerberos, just press RETURN;"
echo "If you've installed it below some other directory, enter it now."
read DESTDIR
$DESTDIR/usr/kerberos/install/fixprot $DESTDIR
echo "Updating /etc/services:"
grep -c klogin /etc/services >/dev/null || (echo "klogin..."; \
cat >> /etc/services << ---EOF---
klogin		543/tcp				# Kerberos authenticated rlogin
eklogin		2105/tcp			# Kerberos encrypted rlogin
---EOF---
)
grep -c passwd_server /etc/services >/dev/null || (echo "kerberos..."; \
cat >> /etc/services << ---EOF---
kerberos	750/udp 	kdc		# Kerberos authentication--udp
kerberos	750/tcp 	kdc		# Kerberos authentication--tcp
kerberos_master	751/udp 			# Kerberos authentication
kerberos_master	751/tcp 			# Kerberos authentication
passwd_server	752/udp				# Kerberos passwd server
---EOF---
)
grep -c krb_prop /etc/services >/dev/null || (echo "HP extra kerberos..."; \
cat >> /etc/services << ---EOF---
krb_prop	754/tcp				# Kerberos slave propagation
knetd		2053/tcp			# Kerberos de-multiplexor
---EOF---
)
grep -c kpop /etc/services >/dev/null || (echo "kpop and others..."; \
cat >> /etc/services << ---EOF---
kpop		1109/tcp			# Pop with Kerberos
kshell		544/tcp		cmd		# and remote shell
---EOF---
)
$DESTDIR/usr/kerberos/install/check-install "$DESTDIR" || exit 1
KRBCONF=$DESTDIR/usr/kerberos/lib/krb.conf
if [ -r $KRBCONF ]; then
     echo "Existing configuration for Realm "`sed 1q $KRBCONF`" preserved."
     echo "To reconfigure it, delete $KRBCONF and re-run configure."
else
echo "Enter name of local realm (for example, CYGNUS.COM):"
read REALM
echo "Enter hostname of primary kerberos server:"
read SERVER
cat > $KRBCONF << ---EOF---
$REALM
$REALM $SERVER admin server
ATHENA.MIT.EDU kerberos.mit.edu admin server
ATHENA.MIT.EDU kerberos-1.mit.edu
ATHENA.MIT.EDU kerberos-2.mit.edu
ATHENA.MIT.EDU kerberos-3.mit.edu
LCS.MIT.EDU kerberos.lcs.mit.edu. admin server
SMS_TEST.MIT.EDU dodo.mit.edu admin server
LS.MIT.EDU ls.mit.edu admin server
IFS.UMICH.EDU kerberos.ifs.umich.edu
CS.WASHINGTON.EDU hawk.cs.washington.edu
CS.WASHINGTON.EDU aspen.cs.washington.edu
CS.BERKELEY.EDU okeeffe.berkeley.edu
SOUP.MIT.EDU soup.mit.edu admin server
TELECOM.MIT.EDU bitsy.mit.edu
MEDIA.MIT.EDU kerberos.media.mit.edu
NEAR.NET kerberos.near.net
CATS.UCSC.EDU kerberos.ucsc.edu admin server
CATS.UCSC.EDU kerberos-1.ucsc.edu
WATCH.MIT.EDU kerberos.watch.mit.edu admin server
CYGNUS.COM kerberos-1.cygnus.com.
CYGNUS.COM kerberos.cygnus.com admin server
---EOF---
# do krb.realms -- only put "known" specials here.
cat > $DESTDIR/usr/kerberos/lib/krb.realms << ---EOF---
.MIT.EDU ATHENA.MIT.EDU
.MIT.EDU. ATHENA.MIT.EDU
MIT.EDU ATHENA.MIT.EDU
DODO.MIT.EDU SMS_TEST.MIT.EDU
.UCSC.EDU CATS.UCSC.EDU
.UCSC.EDU. CATS.UCSC.EDU
CYGNUS.COM CYGNUS.COM
.CYGNUS.COM CYGNUS.COM
---EOF---
fi

chmod 644 $DESTDIR/usr/kerberos/lib/krb.conf
chmod 644 $DESTDIR/usr/kerberos/lib/krb.realms

cat << ---EOF---
To enable Kerberos access to this host, add any of

klogin	stream	tcp	nowait	root	/usr/kerberos/etc/klogind   klogind
eklogin	stream	tcp	nowait	root	/usr/kerberos/etc/klogind   eklogind
kpop	stream	tcp	nowait	root	/usr/kerberos/etc/popper    popper
kshell	stream	tcp	nowait	root	/usr/kerberos/etc/kshd      kshd

   to /etc/inetd.conf, restart inetd, and get a srvtab installed.
---EOF---

