#if !defined(lint) && !defined(SABER)
static char rcsid[] = "$Id: cmds.c,v 1.2 92/05/09 22:57:51 epeisach Exp $";
#endif

#include "mkserv.h"

/*
 * Parse the command line arguments
 * Returns 0 on success
 *	-1 for usage wrong
 *	-2 for out of memory
 * 
*/
parse_cmd(int argc, char **argv, struct cmd_line *cmd)
{
	char *p;
	int del;
	struct cmd_service *s, *s1, *ps;

	bzero(cmd, sizeof(struct cmd_line));
	cmd->progname = strdup(argv[0]);
	if(argc == 1) {
		return -1;
	}
	argv++;
	while(--argc != 0) {
		/* argv */
		if(!strcmp(*argv, "-v")) {
			cmd->vflag = 1;
			argv++;
			continue;
		}
		if(!strcmp(*argv, "public")) {
			cmd->public = 1;
			argv++;
			continue;
		}
		if(!strcmp(*argv, "clean")) {
			cmd->clean = 1;
			argv++;
			continue;
		}
  		if(!strcmp(*argv, "update")) {
			cmd->update = 1;
			argv++;
			continue;
		}
		if(!strcmp(*argv, "updatetest")) {
			cmd->updatetest = 1;
			argv++;
			continue;
		}

		/* Handle service and -service */
		p = *argv;
		del = 0;
		if (*p == '-') {
			del = 1;
			p++;
		}

		/* p pointing at service name maybe... */
		if(!*p) {
			/* Parse error - they specified '-' */
			return -1;
		}
		
		s = cmd->services;
		if(s == NULL) {
			if((cmd->services = (struct cmd_service *) 
				malloc(sizeof(struct cmd_service))) == NULL)
				return -2;
			bzero(cmd->services, sizeof(struct cmd_service));
			if((cmd->services->sname = strdup(p)) == NULL)
				return -2;
			cmd->services->del = del;
		} else {
			/* Walk tree and see if service exists, if so, 
			   remove entry if needed or ignore */
			int found = 0;
			while (s && found == 0) {
				if(!strcmp(s->sname, p)) {
					/* entry exists */
					if(s->del == del) {
						/* Ok leave alone */
						found = 1;
					} else {
						/* Remove if negate actions */
						/* User is loco */
						found = 1;
						s->del = 99;
					}
				}
				else {
					if(s->next) {
						s = s->next;
					} else {
						/* Create entry.... */
						if((s->next = 
						   (struct cmd_service *) 
						   malloc(sizeof(struct cmd_service))) == NULL)
							return -2;
						bzero(s->next, sizeof(struct cmd_service));
						s = s->next;
						if((s->sname = strdup(p)) == NULL)
							return -2;	
						s->del = del;
						found = 1;
					} /* else - entry added */ 
				} /* else strcmp */
			} /* while (searching for entry)*/
				
		} /* if */
		
		argv++;
	} /* while */

	/* Need to remove any entries that were added and deleted.
	 *  (user stupid). 
	 * These are tagged with a del entry of 99
	 */
	ps = s = cmd->services;
	if(s) {
		while(s) {
			if(s->del == 99) {
				free(s->sname);
				if(cmd->services == s) {
					cmd->services = s->next;
				} else {
					ps->next = s->next;
				}
				s1 = s;
				s=s->next;
				free(s1);
			} else 	{
				ps = s;
				s = s->next;
			}
		} /* while */
	}
	
	return 0;
}


