/**********************************************************************
 * File Exchange client library
 *
 * $Author: brlewis $
 * $Source: /afs/athena.mit.edu/astaff/project/eosdev/src/lib/RCS/fx_list_destroy.c,v $
 * $Header: /afs/athena.mit.edu/astaff/project/eosdev/src/lib/RCS/fx_list_destroy.c,v 1.2 90/09/25 13:56:03 brlewis Exp $
 *
 * Copyright 1989, 1990 by the Massachusetts Institute of Technology.
 *
 * For copying and distribution information, please see the file
 * <mit-copyright.h>.
 **********************************************************************/

#include <mit-copyright.h>

#ifndef lint
static char rcsid_fx_list_destroy_c[] = "$Header: /afs/athena.mit.edu/astaff/project/eosdev/src/lib/RCS/fx_list_destroy.c,v 1.2 90/09/25 13:56:03 brlewis Exp $";
#endif /* lint */

#include "fxcl.h"

/*
 * fx_list_destroy -- free memory allocated for paper list
 */

void
fx_list_destroy(plist)
     Paperlist_res **plist;
{
  Paperlist node;

  if (plist && *plist) {

    for (node = (*plist)->Paperlist_res_u.list; node; node = node->next) {
#ifdef KERBEROS
    /* be cautious; restore names to original length */
      _fx_unshorten(node->p.owner);
      _fx_unshorten(node->p.author);
#endif
      xdr_free(xdr_Paperlist_res, (char *) *plist);
      *plist = NULL;
    }
  }
}
