/*
 * This file is part of the OLH On-Line Help system
 *
 *	Chris VanHaren
 *	Lucien Van Elsen
 *      MIT Project Athena
 *
 * Copyright (C) 1990 by the Massachusetts Institute of Technology.
 * For copying and distribution information, see the file "mit-copyright.h".
 *
 *      $Source: /afs/athena.mit.edu/astaff/project/olhdev/src/ascii/RCS/context.c,v $
 *      $Id: context.c,v 1.1 91/02/05 13:31:00 lwvanels Exp $
 *      $Author: lwvanels $
 */

#include <menu.h>
#include <menupath.h>
#include <olh.h>

void
show_context_path()
{
  int i;

  wclear(scr_view);

  wmove(scr_view,2,2);
  waddstr(scr_view,"Path to current menu:");

  for(i=0;i<=current_menu;i++) {
    wmove(scr_view,i+5,i+3);
    waddstr(scr_view, field_value(nth_entry(menu[i],0), NODE_LABEL));
  }
  set_current_screen(SCR_VIEW);
  wait_for_key(win_view_wait);
  set_current_screen(SCR_PRIM);
}

void
construct_context(p)
     char *p;
{
  MenuEntry *e;
  Menu *m;
  char *ptr, *end;
  char *path;
  int n;
  long code;
  int curr_menu = 0;
  int done = 0;

  n = strlen(p);
  path = malloc(n);
  strcpy(path,p);
  if (path[n-1] == '\n')
    {
      n--;
      path[n] = '\0';
    }

/* Break the path into chunks, and process one at a time */
  ptr = path+1;

  while (!done) {
    if ((end = index(ptr, PATH_SEP_CHAR)) != NULL)
      *end = '\0';
    else
      done = 1;
    
    code = pointerEntry(ptr, &e);
    if (code || (!e))
      {
	fprintf(stderr, "ERROR!\n");
	com_err(program, code, "reconstructing path");
	continue;
      }
    if (is_menu(e))
      {
	code = menu_load(e, &m);
	if (code)
	  {
	    com_err(program, code, "loading menu");
	    continue;
	  }
	menu[curr_menu] = m;
	current[curr_menu] = 0;
	viewed[curr_menu] = FALSE;
	if (curr_menu)	/* figure out current in menu above */
	  {
	    Menu *prev_menu;
	    MenuEntry *prev_menu_entry;
	    int i;
	    
	    prev_menu = menu[curr_menu-1];
	    for (i = 0; i < size_menu(prev_menu); i++)
	      {
		prev_menu_entry = nth_entry(prev_menu, i+1);
		if (!strcmp(field_value(prev_menu_entry, FILE_LOCATION),
			    field_value(e, FILE_LOCATION)))
		  {
		    current[curr_menu-1] = i+1;
		    viewed[curr_menu-1] = TRUE;
		    break;
		  }
	      }
	  }
	curr_menu++;
      }
    ptr = end+1;
  }

  if (curr_menu)
      current_menu = curr_menu-1;
}
