/*
 * This file is part of the OLH system.
 *
 *      Lucien Van Elsen
 *	MIT Project Athena
 *
 * Copyright (C) 1990 by the Massachusetts Institute of Technology.
 * For copying and distribution information, see the file "mit-copyright.h".
 *
 *	$Source: /afs/athena.mit.edu/astaff/project/olhdev/src/curses/RCS/get_number.c,v $
 *	$Id: get_number.c,v 1.2 91/01/25 04:35:02 lwvanels Exp $
 *	$Author: lwvanels $
 */

#ifndef lint
#ifndef SABER
static char *RCSid = "$Header: /afs/athena.mit.edu/astaff/project/olhdev/src/curses/RCS/get_number.c,v 1.2 91/01/25 04:35:02 lwvanels Exp $";
#endif
#endif

#include "olh.h"

int
  get_number( ch )
int ch;
{
  int done = FALSE;
  char* ptr = current_input;
  int token;
  
  *ptr++ = ch;
  waddch(win_prompt, ch);
  
  while (! done)
    {
      wrefresh(win_prompt);
      ch = wgetch(win_prompt);
      erase_message();
      
      switch (ch)
	{
	case CTRL_L:
	  wrefresh(curscr);
	  break;
	  
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	  if (ptr-current_input < MAX_DIGITS)
	    {
	      *ptr++ = ch;
	      waddch(win_prompt, ch);
	    }
	  else
	    sound_bell();
	  break;
	  
	case DELETE:
	  delete_char_from_buffer(&ptr);
	  if (ptr == current_input)
	    {
	      strcpy(current_input, "");
	      return TOKEN_NONE;
	    }
	  break;
	  
	case CTRL_U:
	  ptr = current_input;
	  *ptr = END_OF_STRING;
	  paint_prompt( );
	  return TOKEN_NONE;
	  
	case NEWLINE:
	case RETURN:
	  *ptr = END_OF_STRING;
	  done = TRUE;
	  break;
	  
	default:
	  sound_bell();
	}
      
    }
  
  token = TOKEN_NUMBER + atoi(current_input);
  strcpy(current_input, "");
  return token;
}
