/**********************************************************************
 * Macros to deal with allocation properly
 *
 * $Author: lwvanels $
 * $Source: /afs/athena.mit.edu/astaff/project/olhdev/include/RCS/memory.h,v $
 * $Header: /afs/athena.mit.edu/astaff/project/olhdev/include/RCS/memory.h,v 1.3 91/05/01 09:46:53 lwvanels Exp $
 *
 * Copyright (c) 1990, Massachusetts Institute of Technology
 **********************************************************************/

#ifndef lint
#ifndef SABER
static char rcsid_memory_h[] = "$Header: /afs/athena.mit.edu/astaff/project/olhdev/include/RCS/memory.h,v 1.3 91/05/01 09:46:53 lwvanels Exp $";
#endif
#endif

#ifndef __MEMORY_MACROS__
#define __MEMORY_MACROS__


extern char *malloc();
extern char *realloc();

#define New(type) ((type *)malloc((unsigned int)sizeof (type)))
#define NewArray(type, n) ((type *)malloc((unsigned int)sizeof(type) * (n)))
#define ResizeArray(type,old,n) ((type *)realloc((void *)(old), \
						 (unsigned int)(sizeof(type)*(n))))
#define NewString(s) malloc((unsigned int)strlen(s)+1)
#define ResizeString(old, s) realloc(old, (unsigned int)strlen(s)+1);

#endif /* __MEMORY_MACROS__ */


