/**********************************************************************
 * pointer-following module
 *
 * $Author: lwvanels $
 * $Source: /afs/athena.mit.edu/astaff/project/olhdev/src/libmenu/RCS/pointer.c,v $
 * $Header: /afs/athena.mit.edu/astaff/project/olhdev/src/libmenu/RCS/pointer.c,v 1.4 91/04/29 15:03:55 lwvanels Exp $
 *
 * Copyright (c) 1990, Massachusetts Institute of Technology
 **********************************************************************/

#ifndef lint
#ifndef SABER
static char rcsid_pointer_c[] = "$Header: /afs/athena.mit.edu/astaff/project/olhdev/src/libmenu/RCS/pointer.c,v 1.4 91/04/29 15:03:55 lwvanels Exp $";
#endif
#endif

#include <errno.h>
#include <strings.h>
#include <memory.h>
#include <menu.h>

long
pointerEntry(s, e)
     char *s;
     MenuEntry **e;
{
  char *to_break, *colon;
  Menu *m;
  MenuEntry *me;
  long code;

  to_break = (char *)malloc(strlen(s)+1);
  if (!to_break) return((long) errno|| ENOMEM);
  strcpy(to_break, s);
  colon = index(to_break, ':');
  if (!colon) {
    free(to_break);
    return((long) ERR_MENU_INVALPTR);
  }
  *(colon++) = '\0';
  if ((me = find_group(to_break)) == NULL) {
    free(to_break);
    return((long) ERR_MENU_INVALPTR);
  }
  code = menu_load(me, &m);
  if (code) {
    free(to_break);
    return(code);
  }
  for(*e = m->entry; *e < m->entry + m->size; (*e)++) {
    if (strcasecmp(colon, field_value(*e, NODE_ID)) == 0) {
      free(to_break);
      return(0L);
    }
  }
  *e = NULL;			/* not found */
  free(to_break);
  return(0L);
}
