/*
 * This file is part of the OLH On-Line Help system
 *
 *	Lucien Van Elsen
 *      MIT Project Athena
 *
 * Copyright (C) 1991 by the Massachusetts Institute of Technology.
 * For copying and distribution information, see the file "mit-copyright.h".
 *
 *      $Source: /afs/sipb/project/sipb-athena/olh/motif/RCS/help.c,v $
 *      $Id: help.c,v 1.3 1995/08/29 06:39:09 ghudson Exp $
 *      $Author: ghudson $
 */

#include <ctype.h>
#include <sys/param.h>
#include <unistd.h>

#include <Xm/Mu.h>

#include "global.h"
#include "widget_num.h"

struct brec {
  char label[80];
  char filename[80];
  int  button_num;
};

int n_hbuttons;
static int max_hbuttons;
static struct brec *hbuttons;

void
add_help_menus()
{
  char help_list[MAXPATHLEN];
  char *help_dir;
  char *help_locker;
  char *ptr;
  FILE *help_file;
  char buf[BUFSIZ];
  char line[4096];

  XrmDatabase db;

  if ((help_dir = GetDefault(XtDisplay(w[TOPLEVEL]), "Olh", "helpDir"))
      ==  NULL) {
    MuError("Help directory resource not set; no help available");
    return;
  }

  strcpy(help_list,help_dir);
  strcat(help_list,"/motif_list");

  if (access(help_list, F_OK)) {
    if ((help_locker = GetDefault(XtDisplay(w[TOPLEVEL]), "Olh",
				  "helpLocker")) == NULL) {
      MuError("Help locker resource not set; no help available");
      return;
    }
    if (olh_attach(help_locker,0) != 0)
      return;
  }

  if ((help_file = fopen(help_list,"r")) == NULL) {
    sprintf(buf,"Unable to find file help file `%s'", help_list);
    MuError(buf);
    return;
  }
  
  max_hbuttons = 10;
  if ((hbuttons =
       (struct brec *) calloc(max_hbuttons, sizeof(struct brec)*max_hbuttons))
      == NULL) {
    MuError("Unable to allocate memory for help menus.");
    return;
  }

  strcpy(line,"*menubar*help.items: ");

  n_hbuttons = 0;
  while (fgets(buf,BUFSIZ,help_file) != NULL) {
    if (n_hbuttons == max_hbuttons) {
      max_hbuttons = max_hbuttons * 2;
      if ((hbuttons = 
	   (struct brec *) realloc(hbuttons,max_hbuttons*sizeof(struct brec)))
	  == NULL) {
	MuError("Unable to allocate memory for help menus.");
	return;
      }
    }
    ptr = index(buf,'\n');
    if (ptr != NULL) *ptr = '\0';

    ptr = index(buf+1,'"');
    if (ptr == NULL) {
      MuError("Error in parsing list of help buttons");
      return;
    }
    *ptr = '\0';
    strcpy(hbuttons[n_hbuttons].label,(char *) buf+1);
    ptr = ptr+1;

    while(isspace(*ptr))
      ptr++;

    sprintf(hbuttons[n_hbuttons].filename,"%s/%s",help_dir,ptr);

    if(hbuttons[n_hbuttons].label[0] == '-')
      strcpy(buf,"\"-\" ; ");
    else
      sprintf(buf,"\"%s\" button(%d); ",hbuttons[n_hbuttons].label,
	      n_hbuttons+HELP_BTN);

    strcat(line,buf);
    n_hbuttons++;
  }

  db = XtDatabase(XtDisplay(w[TOPLEVEL]));
  XrmPutLineResource(&db,line);
}

void
help(widget, tag, callback_data)
     Widget widget;
     int tag;
     XmAnyCallbackStruct *callback_data;
{
  MuHelpFile(hbuttons[tag-HELP_BTN].filename);
  return;
}

