/* $Header: /afs/sipb/project/sipb-athena/src/xdm/xlogin/RCS/verify.c,v 1.13 96/05/22 16:47:19 yonah Exp $
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/file.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <unistd.h>
#include <dirent.h>
#include <limits.h>
#include <fcntl.h>
#include <pwd.h>
#include <grp.h>
#include <signal.h>
#include <utmp.h>
#include <netdb.h>
#include <errno.h>
#if !(defined(SOLARIS) || defined(linux) || defined(_AIX) || defined(__hp9000s800))
#define USE_TTYSLOT
#include <ttyent.h>
#endif
#ifndef ultrix
#include <syslog.h>
#else
#include <nsyslog.h>
#endif
#ifndef BSD4_3
#include <utime.h>
#endif

#include <krb.h>
#include <hesiod.h>
#include <AL/AL.h>

#ifdef KRB5
#include <krb5/krb5.h>
#include <krb5/ext-proto.h>
#include <krb5/los-proto.h>
#endif

#ifdef XDM
#include "dm.h"
#endif

#ifdef _IBMR2
#include <userpw.h>
#include <usersec.h>
#include <sys/id.h>
#endif

#ifdef ultrix
#include <sys/mount.h>
#include <sys/fs_types.h>
#endif

#ifdef SOLARIS
#include <shadow.h>
#include <utmpx.h>
#include <sys/sysmacros.h>
#endif

#ifdef linux
#include <sys/sysmacros.h>
#endif

#ifdef __NetBSD__
#include <sys/mount.h>
#define OLD_BROKEN_NETBSD_AFS_BACKWARD_COMPATIBILITY_HACK
#endif

#ifdef BSD4_4
#include <paths.h>
#endif

#include "environment.h"

#undef NGROUPS
#define NGROUPS 16

/* Allow for PAG identifier */
#define MAX_GROUPS (NGROUPS-2)

#ifndef TRUE
#define FALSE 0
#define TRUE  1
#endif

#define ROOT 0
#define LOGIN_TKT_DEFAULT_LIFETIME DEFAULT_TKT_LIFE /* from krb.h */
#define PASSWORD_LEN 14
#define TEMP_DIR_PERM 0710
#define MAXENVIRON 32

/* homedir status */
#define HD_LOCAL 0
#define HD_ATTACHED 1
#define HD_TEMP 2

#ifndef NOLOGIN
#define	NOLOGIN "/etc/nologin"
#endif
#ifndef NOCREATE
#define NOCREATE "/etc/nocreate"
#endif
#ifndef NOATTACH
#define NOATTACH "/etc/noattach"
#endif
#ifndef NOCRACK
#define NOCRACK "/etc/nocrack"
#endif
#define MOTD "/etc/motd"
#ifndef _PATH_UTMP
#define _PATH_UTMP "/etc/utmp"
#endif
#ifdef SOLARIS
#define UTMPX "/etc/utmpx"
#define WTMPX "/usr/adm/wtmpx"
#endif
#ifndef _PATH_WTMP
#define _PATH_WTMP "/usr/adm/wtmp"
#endif
#ifndef _PATH_CSHELL
#define _PATH_CSHELL "/bin/csh"
#endif
#ifndef _PATH_SHELLCVT
#define _PATH_SHELLCVT "/etc/athena/shellcvt"
#endif

#define TMPDOTFILES "/usr/athena/lib/prototype_tmpuser/."
#ifdef SOLARIS
char *defaultpath = "/srvd/patch:/usr/athena/bin:/bin/athena:/usr/openwin/bin:/bin:/usr/ucb:/usr/sbin:/usr/andrew/bin:.";
#elif defined(__NetBSD__) || defined(linux)
char *defaultpath = "/usr/local/bin:/usr/athena/bin:/bin/athena:/usr/X11/bin:/usr/bin:/bin";
#else
char *defaultpath = "/srvd/patch:/usr/athena/bin:/bin/athena:/usr/bin/X11:/usr/new:/usr/ucb:/bin:/usr/bin:/usr/ibm:/usr/andrew/bin:.";
#endif
#define file_exists(f) (access((f), F_OK) == 0)


extern char *krb_get_phost(); /* should be in <krb.h> */
extern char *lose();
char *get_tickets(), *attachhomedir(), *strsave(), *add_to_group();
int abort_verify(), map_shell(), starcompare();
int set_real_uid(), set_effective_uid();
void add_utmp();
extern int attach_state, attach_pid, attachhelp_state, attachhelp_pid;
extern int errno, quota_pid;
#ifdef POSIX
extern sigset_t sig_zero;
#endif

int homedir_status = HD_LOCAL;
int added_to_passwd = FALSE;
int added_to_group = FALSE;
gid_t groups_added[MAX_GROUPS];
int ngroups_added;

#ifdef SOLARIS
struct passwd *
 get_pwnam(usr)
 char *usr;
 {
   struct passwd *pwd;
   struct spwd *sp;
   pwd = getpwnam (usr);
   sp = getspnam(usr);
   if ((sp != NULL) && (pwd != NULL))
     pwd->pw_passwd = sp->sp_pwdp;
   return(pwd);
 }
#else
#define get_pwnam(x) getpwnam(x)
#endif

#ifdef XDM
char *dologin(user, passwd, option, script, tty, session, display, verify)
struct verify_info *verify;
#else /* XDM */
char *dologin(user, passwd, option, script, tty, session, display)
#endif /* XDM */
char *user;
char *passwd;
int option;
char *script;
char *tty;
char *session;
char *display;
{
    static char errbuf[5120];
    char tkt_file[128], *msg, wgfile[16];
#ifdef KRB5
    char tkt5_file[128];
#endif
    struct passwd *pwd;
    struct group *gr;
#ifdef BSD4_3
    struct timeval times[2];
#else
    struct utimbuf times;
#endif
    long salt;
    char saltc[2], c;
    char encrypt[PASSWORD_LEN+1];
    char **environment, **glist;
    char fixed_tty[16], *p;
#if defined(_AIX) && defined(_IBMR2)
    char *newargv[4];
#endif
    int i, error_setting_uid;
    /* state variables: */
    int local_passwd = FALSE;	/* user is in local passwd file */
    int local_ok = FALSE;	/* verified from local password file */
    int nocreate = FALSE;	/* not allowed to modify passwd file */
    int nologin = FALSE;	/* logins disabled */


    /* 4.2 vs 4.3 style syslog */
#ifndef  LOG_ODELAY
    openlog("login", LOG_NOTICE);
#else
    openlog("login", LOG_ODELAY, LOG_AUTH);
#endif

    nocreate = file_exists(NOCREATE);
    nologin = file_exists(NOLOGIN);

    /* check to make sure a username was entered */
    if (!strcmp(user, ""))
      {
	return("No username entered.  Please enter a username and password to try again.");
      }

    /* check local password file */
    if ((pwd = get_pwnam(user)) != NULL) {
	local_passwd = TRUE;
	if (strcmp(crypt(passwd, pwd->pw_passwd), pwd->pw_passwd)) {
	    if (pwd->pw_uid == ROOT)
	      return("Incorrect root password");
	} else
	  local_ok = TRUE;
    } else {
	if (nocreate) {
	    sprintf(errbuf, "You are not allowed to log into this workstation.  Contact the workstation's administrator or a consultant for further information.  (User \"%s\" is not in the password file and No_Create is set.)", user);
	    return(errbuf);
	}

 	pwd = hes_getpwnam(user);
 	if ((pwd == NULL) || pwd->pw_dir[0] == 0) {
	    memset(passwd, 0, strlen(passwd));
	    cleanup(NULL);
	    if (hes_error() == HES_ER_NOTFOUND) {
		sprintf(errbuf, "Unknown user name entered (no hesiod information for \"%s\")", user);
		return(errbuf);
	    } else
		return("Unable to find account information due to network failure.  Try another workstation or try again later.");
 	}
	if (strcmp(pwd->pw_name, user))
	    return("Unable to find account information (incorrect hesiod name found).");
	if (getpwuid(pwd->pw_uid))
	    return("This account conflicts with a locally defined account... aborting.");

    }

    /* The terminal name on the Rios is likely to be something like pts/0; we */
    /* don't want any  /'s in the path name; replace them with _'s */
    strcpy(fixed_tty,tty);
    while (p = (char *) index(fixed_tty,'/'))
      *p = '_';
    sprintf(tkt_file, "/tmp/tkt_%s", fixed_tty);
    setenv("KRBTKFILE", tkt_file, 1);
    /* we set the ticket file here because a previous dest_tkt() might
       have cached the wrong ticket file. */
    krb_set_tkt_string(tkt_file);

#ifdef KRB5
    sprintf(tkt5_file, "/tmp/krb5cc_%s", fixed_tty);
    setenv("KRB5CCNAME", tkt5_file, 1);
#endif

    /* set real uid/gid for kerberos library */
    error_setting_uid = set_real_uid (pwd->pw_uid, pwd->pw_gid);
    if (msg = get_tickets(user, passwd)) {
	if (!local_ok) {
	    cleanup(NULL);
	    return(msg);
	} else {
	    if (pwd->pw_uid != ROOT)
		prompt_user("Unable to get full authentication, you will have local access only during this login session (failed to get kerberos tickets).  Continue anyway?", abort_verify);
	}
    }

    /* save encrypted password to put in local password file */
    salt = 9 * getpid();
    saltc[0] = salt & 077;
    saltc[1] = (salt>>6) & 077;
    for (i=0;i<2;i++) {
	c = saltc[i] + '.';
	if (c > '9')
	  c += 7;
	if (c > 'Z')
	  c += 6;
	saltc[i] = c;
    }
    strcpy(encrypt,crypt(passwd, saltc));	

    /* don't need the password anymore */
    memset(passwd, 0, strlen(passwd));

    if (!local_passwd)
      pwd->pw_passwd = encrypt;

    /* if NOLOGINs and we're not root, display the contents of the
     * nologin file */
    if (nologin && pwd->pw_uid != ROOT) {
	int f, count;
	char *p;

	strcpy(errbuf, "Logins are currently disabled on this workstation.  ");
	p = &errbuf[strlen(errbuf)];
	f = open(NOLOGIN, O_RDONLY, 0);
	if (f > 0) {
	    count = read(f, p, sizeof(errbuf) - strlen(errbuf) - 1);
	    close(f);
	    p[count] = 0;
	}
	cleanup(NULL);
	return(errbuf);
    }

    if (error_setting_uid != 0) {
	/* assumes no TKT_SHMEM! */
	if (chown(tkt_file, pwd->pw_uid, pwd->pw_gid) == -1) {
	    /* We got tickets, but couldn't give them away... eek! */
	    if (errno != ENOENT)
		prompt_user("Unable to change the ownership of Kerberos tickets to you.  You will have local access only during this login session.  Continue anyway?", abort_verify);
	}
    }
#ifdef KRB5
    chown(tkt5_file, pwd->pw_uid, pwd->pw_gid);
#endif

    /* if mail-check login selected, do that now. */
    if (option == 4) {
	attach_state = -1;
	switch(attach_pid = fork()) {
	case -1:
	    fprintf(stderr, "Unable to fork to check your mail.\n");
	    break;
	case 0:
	    if (setuid(pwd->pw_uid) != 0) {
		fprintf(stderr, "Unable to set user ID to check your mail.\n");
		_exit(-1);
	    }
	    printf("Electronic mail status:\n");
	    execlp("from", "from", "-r", user, NULL);
	    fprintf(stderr, "Unable to run mailcheck program.\n");
	    _exit(-1);
	default:
	    while (attach_state == -1)
#ifdef POSIX
	      sigsuspend(&sig_zero);
#else
	      sigpause(0);
#endif
	    printf("\n");
	    prompt_user("A summary of your waiting email is displayed in the console window.  Continue with full login session or logout now?", abort_verify);
	}
    }

#ifdef SETPAG
    setpag();
#ifdef OLD_BROKEN_NETBSD_AFS_BACKWARD_COMPATIBILITY_HACK
    /* initgroups() should retain the PAG groups, but won't on old versions
     * of NetBSD-AFS.  On fixed NetBSD-AFS systems, this will be a no-op. */
    initgroups(pwd->pw_name, pwd->pw_gid);
#endif
#endif

    if (msg = attachhomedir(pwd)) {
	cleanup(pwd);
	return(msg);
    }

    /* put in password file if necessary */
    if (!local_passwd) {
	if (PWaddPasswdEntry(pwd) < 0) {
	    cleanup(pwd);
	    return("An unexpected error occured while entering you in the local password file.");
	}
	added_to_passwd = TRUE;
    }
    switch(quota_pid = fork()) {
    case -1:
	fprintf(stderr, "Unable to fork to check your filesystem quota.\n");
	break;
    case 0:
	if (setuid(pwd->pw_uid) != 0) {
	    fprintf(stderr, "Unable to set user ID to check your filesystem quota.\n");
	    _exit(-1);
	}
	execlp("quota", "quota", NULL);
	fprintf(stderr, "Unable to run quota command %s\n", "quota");
	_exit(-1);
    default:
	  ;
    }

    /* show message of the day */
    sprintf(errbuf, "%s/.hushlogin", pwd->pw_dir);
    if (!file_exists(errbuf)) {
	int f, count;
	f = open(MOTD, O_RDONLY, 0);
	if (f > 0) {
	    count = read(f, errbuf, sizeof(errbuf) - 1);
	    write(1, errbuf, count);
	    close(f);
	}
    }

    if (!nocreate) {
	ngroups_added = PWaddGroups(pwd, groups_added, MAX_GROUPS);
	if (ngroups_added < 0) {
	    cleanup(pwd);
	    return("Can't add your groups to /etc/groups");
	}
	added_to_group = TRUE;
    }

    /*
     * Set up the user's environment.
     *
     *   By default, none of xlogin's environment is passed to
     *   users who log in.
     *
     *   The PASSENV macro is defined to make it trivial to pass
     *   an element of xlogin's environment on to the user.
     *
     *   Note that the environment for pre-login options is set
     *   up in xlogin.c: it is NOT RELATED to this environment
     *   setup. If you add a new environment variable here,
     *   consider whether or not it also needs to be added there.
     *   Note that variables that need to be PASSENVed here do not
     *   need similar treatment in the pre-login area, since there
     *   all variables as passed by default.
     */
#define PASSENV(envvar)					\
    msg = getenv(envvar);				\
    if (msg) {						\
	sprintf(errbuf, "%s=%s", envvar, msg);		\
	environment[i++] = strsave(errbuf);		\
    }

    environment = (char **) malloc(MAXENVIRON * sizeof(char *));
    if (environment == NULL)
      return("Out of memory while trying to initialize user environment variables.");

    i = 0;
#if defined(_AIX) && defined(_IBMR2) && !defined(XDM)
    environment[i++] = "USRENVIRON:";
#endif
    sprintf(errbuf, "HOME=%s", pwd->pw_dir);
    environment[i++] = strsave(errbuf);
    sprintf(errbuf, "PATH=%s", defaultpath);
    environment[i++] = strsave(errbuf);
    sprintf(errbuf, "USER=%s", pwd->pw_name);
    environment[i++] = strsave(errbuf);
    sprintf(errbuf, "SHELL=%s", pwd->pw_shell);
    environment[i++] = strsave(errbuf);
    sprintf(errbuf, "DISPLAY=%s", display);
    environment[i++] = strsave(errbuf);
    sprintf(errbuf, "KRBTKFILE=%s", tkt_file);
    environment[i++] = strsave(errbuf);
#ifdef KRB5
    sprintf(errbuf, "KRB5CCNAME=%s", tkt5_file);
    environment[i++] = strsave(errbuf);
#endif
#ifdef HOSTTYPE
     sprintf(errbuf, "hosttype=%s", HOSTTYPE); /* environment.h */
     environment[i++] = strsave(errbuf);
#endif

#ifdef SOLARIS
    PASSENV("LD_LIBRARY_PATH");
    PASSENV("OPENWINHOME");
#endif

    if (homedir_status == HD_TEMP) {
	environment[i++] = "TMPHOME=1";
    }
    strcpy(wgfile, "/tmp/wg.XXXXXX");
    mktemp(wgfile);
    sprintf(errbuf, "WGFILE=%s", wgfile);
    environment[i++] = strsave(errbuf);
    PASSENV("TZ");

#if defined(_AIX) && defined(_IBMR2)
#ifndef XDM
    environment[i++] = "SYSENVIRON:";
#endif
    sprintf(errbuf,"LOGIN=%s",pwd->pw_name);
    environment[i++] = strsave(errbuf);
    sprintf(errbuf,"LOGNAME=%s",pwd->pw_name);
    environment[i++] = strsave(errbuf);
    sprintf(errbuf,"NAME=%s",pwd->pw_name);
    environment[i++] = strsave(errbuf);
    sprintf(errbuf,"TTY=%s",tty);
    environment[i++] = strsave(errbuf);
#endif
    environment[i++] = NULL;

    add_utmp(user, tty, display);
    if (pwd->pw_uid == ROOT)
      syslog(LOG_CRIT, "ROOT LOGIN on tty %s", tty);

    /* Set the owner and modtime on the tty */
    sprintf(errbuf, "/dev/%s", tty);
    gr = getgrnam("tty");
    chown(errbuf, pwd->pw_uid, gr ? gr->gr_gid : pwd->pw_gid);
    chmod(errbuf, 0620);
#ifdef BSD4_3
    gettimeofday(&times[0], NULL);
    times[1] = times[0];
    utimes(errbuf, times);
#else
    times.actime = time(NULL);
    times.modtime = times.actime;
    utime(errbuf, &times);
#endif

#ifdef XDM
    {
	static char *newargv[4];

	verify->uid = pwd->pw_uid;
	getGroups(pwd->pw_name, verify, pwd->pw_gid);
	verify->userEnviron = environment;
	newargv[0] = script;
	sprintf(errbuf, "%d", option);
	newargv[1] = errbuf;
	newargv[2] = session;
	newargv[3] = NULL;
	verify->argv = newargv;
	return(0);
    }
#endif /* XDM */

#if defined(_AIX) && defined(_IBMR2)
    /* KLUDGE (working around AIX libs.a bugs):
     * Flush any stray references to userdb/pwdb.
     * Flush cached group list (it is inconsistent in memory). */
    i = chksessions();
    while (i--) enduserdb();
    i = chkpsessions();
    while (i--) endpwdb();
    endgroups();
    
    if (setpcred(pwd->pw_name, 0)) 
	return(lose("Unable to set user's credentials.\n"));
#else
    i = setgid(pwd->pw_gid);
    if (i) 
	return(lose("Unable to set your primary GID.\n"));

        
    if (initgroups(user, pwd->pw_gid) < 0)
	prompt_user("Unable to set your group access list.  You may have insufficient permission to access some files.  Continue with this login session anyway?", abort_verify);

#ifdef BSD4_4
    i = setlogin(pwd->pw_name);
    if (i)
	return(lose("Unable to set your login credentials.\n"));
#endif
    i = setuid(pwd->pw_uid);
    if (i)
      return(lose("Unable to set your user ID.\n"));
#endif

    if (chdir(pwd->pw_dir))
      fprintf(stderr, "Unable to connect to your home directory.\n");

    sprintf(errbuf, "%d", option);

#if defined(_AIX) && defined(_IBMR2)
    newargv[0] = session;
    newargv[1] = errbuf;
    newargv[2] = script;
    newargv[3] = NULL;

    setpenv(pwd->pw_name,PENV_KLEEN|PENV_INIT|PENV_ARGV,
	    environment,(char *)newargv);
#else
    execle(session, "sh", errbuf, script, NULL, environment);
#endif

    return(lose("Failed to start session."));
}


char *get_tickets(username, password)
char *username;
char *password;
{
    char inst[INST_SZ], realm[REALM_SZ];
    char hostname[MAXHOSTNAMELEN], phost[INST_SZ];
    char key[8], *rcmd;
    static char errbuf[1024];
    int error;
    struct hostent *hp;
    KTEXT_ST ticket;
    AUTH_DAT authdata;
    unsigned long addr;

    rcmd = "rcmd";

    /* inst has to be a buffer instead of the constant "" because
     * krb_get_pw_in_tkt() will write a zero at inst[INST_SZ] to
     * truncate it.
     */
    inst[0] = 0;
    dest_tkt();
#ifdef KRB5
    do_v5_kdestroy(0);
#endif

    if (krb_get_lrealm(realm, 1) != KSUCCESS)
      strcpy(realm, KRB_REALM);

    error = krb_get_pw_in_tkt(username, inst, realm, "krbtgt", realm,
			      LOGIN_TKT_DEFAULT_LIFETIME, password);
    switch (error) {
    case KSUCCESS:
	break;
    case INTK_BADPW:
	return("Incorrect password entered.");
    case KDC_PR_UNKNOWN:
	return("Unknown username entered.");
    default:
	sprintf(errbuf, "Unable to authenticate you, kerberos failure %d: %s.  Try again here or on another workstation.",
		error, krb_err_txt[error]);
	return(errbuf);
    }

#ifdef KRB5
    {
	krb5_error_code krb5_ret;
	char *etext;

	krb5_ret = do_v5_kinit(username, inst, realm,
			       LOGIN_TKT_DEFAULT_LIFETIME, password,
			       0, &etext);
	if (krb5_ret && krb5_ret != KRB5KRB_AP_ERR_BAD_INTEGRITY) {
	    com_err("xlogin", krb5_ret, etext);
	}
    }
#endif

    if (gethostname(hostname, sizeof(hostname)) == -1) {
	fprintf(stderr, "Warning: cannot retrieve local hostname");
	return(NULL);
    }
    strncpy (phost, krb_get_phost (hostname), sizeof (phost));
    phost[sizeof(phost)-1] = '\0';

    /* without srvtab, cannot verify tickets */
    if (read_service_key(rcmd, phost, realm, 0, KEYFILE, key) == KFAILURE)
      return (NULL);

    hp = gethostbyname (hostname);
    if (!hp) {
	fprintf(stderr, "Warning: cannot get address for host %s\n", hostname);
	return(NULL);
    }
#ifdef POSIX
    memmove ((char *) &addr, (char *)hp->h_addr, sizeof (addr));
#else
    bcopy ((char *)hp->h_addr, (char *) &addr, sizeof (addr));
#endif

    error = krb_mk_req(&ticket, rcmd, phost, realm, 0);
    if (error == KDC_PR_UNKNOWN) return(NULL);
    if (error != KSUCCESS) {
	sprintf(errbuf, "Unable to authenticate you, kerberos failure %d: %s",
		error, krb_err_txt[error]);
	return(errbuf);
    }
    error = krb_rd_req(&ticket, rcmd, phost, addr, &authdata, "");
    if (error != KSUCCESS) {
	memset(&ticket, 0, sizeof(ticket));
	sprintf(errbuf, "Unable to authenticate you, kerberos failure %d: %s",
		error, krb_err_txt[error]);
	return(errbuf);
    }
    memset(&ticket, 0, sizeof(ticket));
    memset(&authdata, 0, sizeof(authdata));
    return(NULL);
}


cleanup(pwd)
struct passwd *pwd;
{
    /* must also detach homedir, clean passwd file */
    dest_tkt();
#ifdef KRB5
    do_v5_kdestroy(0);
#endif
    if (pwd && homedir_status == HD_ATTACHED) {
	attach_state = -1;
	switch (attach_pid = fork()) {
	case -1:
	    fprintf(stderr, "Unable to detach your home directory (could not fork to create attach process).");
	    break;
	case 0:
	    if (setuid(pwd->pw_uid) != 0) {
		fprintf(stderr,
			"Could not execute detach command as user %s,\n",
			pwd->pw_name);
	    }
	    execlp("fsid", "fsid", "-unmap", "-filsys", pwd->pw_name, NULL);
	    _exit(-1);
	default:
	    while (attach_state == -1)
#ifdef POSIX
	      sigsuspend(&sig_zero);
#else
	      sigpause(0);
#endif
	}
    }
    if (pwd && added_to_passwd)
	PWremovePasswdEntry(pwd);
    if (pwd && added_to_group)
	PWremoveGroups(pwd, groups_added, ngroups_added);
    /* Set real uid to zero.  If this is impossible, exit.  The
       current implementation of lose() will not print a message
       so xlogin will just exit silently.  This call "can't fail",
       so this is not a serious problem. */
    if (setuid(0) == -1)
      lose ("Unable to reset real uid to root");

}


abort_verify()
{
    cleanup(NULL);
    _exit(1);
}


char *attachhomedir(pwd)
struct passwd *pwd;
{
    struct stat stb;
    int i, error_setting_uid;

    /* Delete empty directory if it exists.  We just try to rmdir the 
     * directory, and if it's not empty that will fail.
     */
    rmdir(pwd->pw_dir);

    /* If a good local homedir exists, use it */
    if (file_exists(pwd->pw_dir) && !ALisRemoteDir(pwd->pw_dir) &&
	ALhomedirOK(pwd->pw_dir))
      return(NULL);

    /* Using homedir already there that may or may not be good. */
    if (file_exists(NOATTACH) && file_exists(pwd->pw_dir) &&
	ALhomedirOK(pwd->pw_dir)) {
	prompt_user("This workstation is configured not to attach remote filesystems.  Continue with your local home directory?", abort_verify);
	return(NULL);
    }

    if (file_exists(NOATTACH))
      return("This workstation is configured not to create local home directories.  Please contact the system administrator for this machine or a consultant for further information.");

    /* attempt attach now */
    attach_state = -1;
    switch (attach_pid = fork()) {
    case -1:
	return("Unable to attach your home directory (could not fork to create attach process).  Try another workstation.");
    case 0:
 	if (setuid(pwd->pw_uid) != 0) {
 	    fprintf(stderr, "Could not execute attach command as user %s,\n",
 		    pwd->pw_name);
 	    fprintf(stderr, "Filesystem mappings may be incorrect.\n");
 	}
	/* don't do zephyr here since user doesn't have zwgc started anyway */
	execlp("attach", "attach", "-quiet", "-nozephyr", pwd->pw_name, NULL);
	_exit(-1);
    default:
	break;
    }
    while (attach_state == -1) {
#ifdef POSIX
        sigsuspend(&sig_zero);
#else
	sigpause(0);
#endif
    }

    if (attach_state != 0 || !file_exists(pwd->pw_dir)) {
	prompt_user("Your home directory could not be attached.  Try again?",
		    abort_verify);
	/* attempt attach again */
	attach_state = -1;
	switch (attach_pid = fork()) {
	case -1:
	    return("Unable to attach your home directory (could not fork to create attach process).  Try another workstation.");
	case 0:
	    if (setuid(pwd->pw_uid) != 0) {
		fprintf(stderr,
			"Could not execute attach command as user %s,\n",
			pwd->pw_name);
		fprintf(stderr, "Filesystem mappings may be incorrect.\n");
	    }
	    /* don't do zephyr here since user doesn't have zwgc started */
	    execlp("attach", "attach", "-quiet", "-nozephyr",
		   pwd->pw_name, NULL);
	    _exit(-1);
	default:
	    break;
	}
	while (attach_state == -1) {
#ifdef POSIX
	    sigsuspend(&sig_zero);
#else
	    sigpause(0);
#endif
	}
    }

    if (attach_state != 0 || !file_exists(pwd->pw_dir)) {
	/* do tempdir here */
	char buf[BUFSIZ];
	homedir_status = HD_TEMP;

	prompt_user("Your home directory is still unavailable.  A temporary directory will be created for you.  However, it will be DELETED when you logout.  Any mail that you incorporate during this session WILL BE LOST when you logout.  Continue with this session anyway?", abort_verify);
	sprintf(buf, "/tmp/%s", pwd->pw_name);
	pwd->pw_dir = (char *)malloc(strlen(buf)+1);
	strcpy(pwd->pw_dir, buf);

	i = lstat(buf, &stb);
	if (i == 0) {
	    if ((stb.st_mode & S_IFMT) == S_IFDIR) {
		fprintf(stderr, "Warning - The temporary directory already exists.\n");
		return(NULL);
	    } else unlink(buf);
	} else if (errno != ENOENT)
	  return("Error while retrieving status of temporary homedir.");

	error_setting_uid = set_effective_uid(pwd->pw_uid);
	if (mkdir(buf, TEMP_DIR_PERM))
	  return("Error while creating temporary directory.");

	if (error_setting_uid != 0) {
	    if(chown(buf, pwd->pw_uid, -1))
		return("Could not change owner of temporary directory.");
	}

	attachhelp_state = -1;
	switch (attachhelp_pid = fork()) {
	case -1:
	    fprintf(stderr, "Warning - could not fork to copy user prototype files into temporary directory.\n");
	    return (NULL);
	case 0:
	    if (setuid(pwd->pw_uid) != 0) {
		fprintf(stderr, "Could not copy prototype files as user %s,\n",
 		    pwd->pw_name);
	    }
	    /* redirect to /dev/null to make cp quiet */
	    close(1);
	    close(2);
	    open("/dev/null", O_RDWR, 0);
	    dup(1);
	    execl("/bin/cp", "cp", "-r", TMPDOTFILES, buf, NULL);
	    fprintf(stderr, "Warning - could not copy user prototype files into temporary directory.\n");
	    _exit(-1);
	default:
	    break;
	}
	while (attachhelp_state == -1)
#ifdef POSIX
	  sigsuspend(&sig_zero);
#else
	  sigpause(0);
#endif

	if (chmod(buf, TEMP_DIR_PERM))
	  return("Could not change protections on temporary directory.");

	set_effective_uid(ROOT);
    } else
      homedir_status = HD_ATTACHED;
    return(NULL);
}


char *strsave(s)
char *s;
{
    char *ret = (char *) malloc(strlen(s) + 1);
    strcpy(ret, s);
    return(ret);
}


#ifdef USE_TTYSLOT
/*
 * replacement for library ttyslot routine which takes tty as argument
 * rather than finding controlling tty (which is often undefined in xlogin).
 */
int myttyslot(tty)
char *tty;
{
    int s = 0;
    struct ttyent *ty;

    setttyent();
    while ((ty = getttyent()) != NULL) {
	s++;
	if (strcmp(ty->ty_name, tty) == 0) {
	    endttyent();
	    return(s);
	}
    }
    endttyent();
    return(0);
}
#endif


void
add_utmp(user, tty, display)
char *user;
char *tty;
char *display;
{
#ifdef SOLARIS
    struct utmp ut_entry;
    struct utmpx utx_entry;
    int f;

    memset(&ut_entry, 0, sizeof(ut_entry));
    memset(&utx_entry, 0, sizeof(utx_entry));
    strncpy(ut_entry.ut_line, tty, 8);
    strncpy(ut_entry.ut_name, user, 8);
    strncpy(utx_entry.ut_line, tty, 8);
    strncpy(utx_entry.ut_name, user, 8);
    /* leave space for \0 */
    strncpy(utx_entry.ut_host, display, 15);
    utx_entry.ut_host[15] = 0;
    time(&(ut_entry.ut_time));
    gettimeofday(&utx_entry.ut_tv);
    ut_entry.ut_pid = getppid();
    ut_entry.ut_type = USER_PROCESS;
    utx_entry.ut_pid = getppid();
    utx_entry.ut_type = USER_PROCESS;
    strncpy(utx_entry.ut_id,"XLOG",4);
    strncpy(ut_entry.ut_id,"XLOG",4);
    setutent();
    pututline(ut_entry);
    setutxent();
    pututxline(utx_entry);
    if ((f = open(_PATH_WTMP, O_WRONLY|O_APPEND)) >= 0) {
        write(f, (char *) &ut_entry, sizeof(ut_entry));
        close(f);
    }
    if ((f = open(WTMPX, O_WRONLY|O_APPEND)) >= 0) {
        write(f, (char *) &utx_entry, sizeof(utx_entry));
        close(f);
    }

#elif defined(linux) || defined(__hp9000s800)
    struct utmp ut_entry;
    char *ttyabbrev;
    int f;

    memset(&ut_entry, 0, sizeof(ut_entry));
    strncpy(ut_entry.ut_line, tty, sizeof(ut_entry.ut_line));
    strncpy(ut_entry.ut_name, user, sizeof(ut_entry.ut_user));
    /* leave space for \0 */
    strncpy(ut_entry.ut_host, display, sizeof(ut_entry.ut_host));
    ut_entry.ut_host[sizeof(ut_entry.ut_host)-1] = 0;
    time(&ut_entry.ut_time);
    ut_entry.ut_pid = getpid();
    ut_entry.ut_type = USER_PROCESS;
    ttyabbrev = tty + sizeof("tty") - 1;
    strncpy(ut_entry.ut_id, ttyabbrev, sizeof(ut_entry.ut_id));
    utmpname(_PATH_UTMP);
    setutent();
    pututline(&ut_entry);
    endutent();
    if ((f = open(_PATH_WTMP, O_APPEND|O_WRONLY)) >= 0) {
#ifdef LOCK_EX
	flock(f, LOCK_EX);
#endif
	write(f, (char *) &ut_entry, sizeof(ut_entry));
#ifdef LOCK_UN
	flock(f, LOCK_UN);
#endif
	close(f);
    }

#elif defined(_AIX)
    struct utmp ut_entry;
    struct utmp ut_tmp;
    int f;

    memset(&ut_entry, 0, sizeof(ut_entry));
    strncpy(ut_entry.ut_line, tty, 8);
    strncpy(ut_entry.ut_name, user, 8);
    /* leave space for \0 */
    strncpy(ut_entry.ut_host, display, 15);
    ut_entry.ut_host[15] = 0;
    time(&(ut_entry.ut_time));
    ut_entry.ut_pid = getppid();
    ut_entry.ut_type = USER_PROCESS;
    if ((f = open(_PATH_UTMP, O_RDWR )) >= 0) {
	while (read(f, (char *) &ut_tmp, sizeof(ut_tmp)) == sizeof(ut_tmp))
	    if (ut_tmp.ut_pid == ut_entry.ut_pid) {
		strncpy(ut_entry.ut_id, ut_tmp.ut_id, sizeof(ut_tmp.ut_id));
		lseek(f, -(off_t) sizeof(ut_tmp), 1);
		break;
	    }
	write(f, (char *) &ut_entry, sizeof(ut_entry));
	close(f);
    }
    if ((f = open(_PATH_WTMP, O_WRONLY|O_APPEND)) >= 0) {
	write(f, (char *) &ut_entry, sizeof(ut_entry));
	close(f);
    }

#else /* bsd and ultrix */
    struct utmp ut_entry;
    int f, slot;

    memset(&ut_entry, 0, sizeof(ut_entry));
    strncpy(ut_entry.ut_line, tty, 8);
    strncpy(ut_entry.ut_name, user, 8);
    /* leave space for \0 */
    strncpy(ut_entry.ut_host, display, 15);
    ut_entry.ut_host[15] = 0;
    time(&(ut_entry.ut_time));
#ifdef USER_PROCESS
    ut_entry.ut_pid = getppid();
    ut_entry.ut_type = USER_PROCESS;
#endif
    if ((f = open(_PATH_UTMP, O_RDWR )) >= 0) {
	slot = myttyslot(tty);
	lseek(f, (off_t) ( slot * sizeof(ut_entry) ), L_SET);
	write(f, (char *) &ut_entry, sizeof(ut_entry));
	close(f);
    }
    if ((f = open(_PATH_WTMP, O_WRONLY|O_APPEND)) >= 0) {
	write(f, (char *) &ut_entry, sizeof(ut_entry));
	close(f);
    }

#endif
}

#ifdef KRB5
/*
 * This routine takes v4 kinit parameters and performs a V5 kinit.
 * 
 * name, instance, realm is the v4 principal information
 *
 * lifetime is the v4 lifetime (i.e., in units of 5 minutes)
 * 
 * password is the password
 *
 * ret_cache_name is an optional output argument in case the caller
 * wants to know the name of the actual V5 credentials cache (to put
 * into the KRB5CCNAME environment variable)
 *
 * etext is a mandatory output variable which is filled in with
 * additional explanatory text in case of an error.
 */
krb5_error_code do_v5_kinit(name, instance, realm, lifetime, password,
                           ret_cache_name, etext)
    char    *name;
    char    *instance;
    char    *realm;
    int     lifetime;
    char    *password;
    char    **ret_cache_name;
    char    **etext;
{
    krb5_error_code retval;
    krb5_principal  me = 0, server = 0;
    krb5_ccache     ccache = NULL;
    krb5_creds      my_creds;
    krb5_timestamp  now;
    krb5_address    **my_addresses = 0;
    char            *cache_name = krb5_cc_default_name();

    *etext = 0;
    if (ret_cache_name)
	*ret_cache_name = 0;
    memset((char *)&my_creds, 0, sizeof(my_creds));
    
    krb5_init_ets();
    
    retval = krb5_425_conv_principal(name, instance, realm, &me);
    if (retval) {
	*etext = "while converting V4 principal";
	goto cleanup;
    }
    
    retval = krb5_cc_resolve (cache_name, &ccache);
    if (retval) {
	*etext = "while resolving ccache";
	goto cleanup;
    }

    retval = krb5_cc_initialize (ccache, me);
    if (retval) {
	*etext = "while initializing cache";
	goto cleanup;
    }

    retval = krb5_build_principal_ext(&server,
				      krb5_princ_realm(me)->length,
				      krb5_princ_realm(me)->data,
				      KRB5_TGS_NAME_SIZE, KRB5_TGS_NAME,
				      krb5_princ_realm(me)->length,
				      krb5_princ_realm(me)->data,
				      0);
    if (retval)  {
	*etext = "while building server name";
	goto cleanup;
    }

    retval = krb5_os_localaddr(&my_addresses);
    if (retval) {
	*etext = "when getting my address";
	goto cleanup;
    }

    retval = krb5_timeofday(&now);
    if (retval) {
	*etext = "while getting time of day";
	goto cleanup;
    }
       
    my_creds.client = me;
    my_creds.server = server;
    my_creds.times.starttime = 0;
    my_creds.times.endtime = now + lifetime*5*60;
    my_creds.times.renew_till = 0;
       
    retval = krb5_get_in_tkt_with_password(0, my_addresses, 0,
					   ETYPE_DES_CBC_CRC,
					   KEYTYPE_DES,
					   password,
					   ccache,
					   &my_creds, 0);
    if (retval) {
	*etext = "while calling krb5_get_in_tkt_with_password";
	goto cleanup;
    }

    if (ret_cache_name) {
	*ret_cache_name = malloc(strlen(cache_name)+1);
	if (!*ret_cache_name) {
	    retval = ENOMEM;
	    goto cleanup;
	}
	strcpy(*ret_cache_name, cache_name);
    }

 cleanup:
    if (me)
	krb5_free_principal(me);
    if (server)
	krb5_free_principal(server);
    if (my_addresses)
	krb5_free_addresses(my_addresses);
    if (ccache)
	krb5_cc_close(ccache);
    my_creds.client = 0;
    my_creds.server = 0;
    krb5_free_cred_contents(&my_creds);
    return retval;
}

krb5_error_code do_v5_kdestroy(cachename)
    char    *cachename;
{
    krb5_error_code retval;
    krb5_ccache cache;
    
    if (!cachename)
	cachename = krb5_cc_default_name();
    
    krb5_init_ets();
    
    retval = krb5_cc_resolve (cachename, &cache);
    if (!retval)
	retval = krb5_cc_destroy(cache);

    return retval;
}
#endif /* KRB5 */

#ifdef linux
#define setresuid(r,e,s) setreuid(r,e)
#endif

/*
 *  set_real_uid () -- set the real uid, because it's checked by kerberos.
 *  Do not change the effective uid from root.
 *
 */
int set_real_uid (uid, gid)
    int uid, gid;
{
#ifdef _IBMR2
    setuidx(ID_REAL|ID_EFFECTIVE, uid);
    setgidx(ID_REAL|ID_EFFECTIVE, gid);
    return(0);
#elif defined (ultrix) || ((defined(BSD4_3) && !defined(BSD4_4)))
    int s1, s2;
    if ((s1 = setruid(uid)) < 0)
	syslog(LOG_DEBUG, "setruid: %m");
    if ((s2 = setrgid(gid)) < 0)
	syslog(LOG_DEBUG, "setrgid: %m");
    return (s1 != 0 ? s1 : s2);
#elif defined _POSIX_SAVED_IDS
    int s1, s2;
    s1 = setresuid(uid, ROOT, ROOT);
    s2 = setgid(gid);
    return (s1 != 0 ? s1 : s2);
#else
    return(-1);
#endif
}

/*
 *  set_effective_uid () -- set the effective uid for creating files and
 *  stuff.  If changing from root, make sure we can change back.
 *
 */
int set_effective_uid(uid)
    int uid;
{
#if defined (ultrix) || ((defined(BSD4_3) && !defined(BSD4_4)))
    return (setreuid(ROOT, uid));
#elif defined _POSIX_SAVED_IDS
    return (setuid(uid));
#else
    return(-1);
#endif
}
