/* ctype.h standard header file 
 * $Version: 1.2 $
 * Copyright (c) 1988-91, 93 Intel Corporation, ALL RIGHTS RESERVED.
 */

#ifndef _CTYPE
#define _CTYPE

#include <yvals.h>

#ifdef __cplusplus
extern "C" {
#endif

/*
 * macro definitions
 */

#define _Ctype _ctype

/*
 * _Ctype code bits
 */

#define _XA     0x00    /* extra alphabetic - not supported */
#define _XS     0x40    /* extra space */
#define _BB     0x00    /* BEL, BS, etc. - not supported */
#define _CN     0x20    /* CR, FF, HT, NL, VT */
#define _DI     0x04    /* '0'-'9' */
#define _LO     0x02    /* 'a'-'z' */
#define _PU     0x10    /* punctuation */
#define _SP     0x08    /* space */
#define _UP     0x01    /* 'A'-'Z' */
#define _XD     0x80    /* '0'-'9', 'A'-'F', 'a'-'f' */

/*
 * standard function prototypes
 */

int      _Pascal isalnum(int);
int      _Pascal isalpha(int);
int      _Pascal iscntrl(int);
int      _Pascal isdigit(int);
int      _Pascal isgraph(int);
int      _Pascal islower(int);
int      _Pascal isprint(int);
int      _Pascal ispunct(int);
int      _Pascal isspace(int);
int      _Pascal isupper(int);
int      _Pascal isxdigit(int);
int      _Pascal tolower(int);
int      _Pascal toupper(int);

/*
 * additional function prototypes
 */

int      _Pascal isascii(int);
int      _Pascal iscsym(int);
int      _Pascal iscsymf(int);
int      _Pascal isodigit(int);
int      _Pascal toascii(int);
int      _Pascal _tolower(int);
int      _Pascal _toupper(int);

#if _FAR_CODE_ || _ROM_

extern const unsigned char _ROM _Ctype[257];

/*
 * macros overrides
 */

#define isalnum(c)  (_Ctype[(unsigned char)(c)] & (_DI|_LO|_UP))
#define isalpha(c)  (_Ctype[(unsigned char)(c)] & (_LO|_UP))
#define iscntrl(c)  (_Ctype[(unsigned char)(c)] & (_CN))
#define isdigit(c)  (_Ctype[(unsigned char)(c)] & (_DI))
#define isgraph(c)  (_Ctype[(unsigned char)(c)] & (_DI|_LO|_PU|_UP))
#define islower(c)  (_Ctype[(unsigned char)(c)] & (_LO))
#define isprint(c)  (_Ctype[(unsigned char)(c)] & (_DI|_LO|_PU|_XS|_UP))
#define ispunct(c)  (_Ctype[(unsigned char)(c)] & (_PU))
#define isspace(c)  (_Ctype[(unsigned char)(c)] & (_SP))
#define isupper(c)  (_Ctype[(unsigned char)(c)] & (_UP))
#define isxdigit(c) (_Ctype[(unsigned char)(c)] & (_XD))

#endif /* _FAR_CODE_ || _ROM_ */

/*
 * macro overrides only
 */

#define isascii(c)  (int)((unsigned int)(c)<=0x7f)
#define iscsym(c)   ((isalnum(c)) || (c == '_'))
#define iscsymf(c)  ((isalpha(c)) || (c == '_'))
#define toascii(c)  (int)((unsigned int)(c)&0x7f)
#define _tolower(c) ((c)+'a'-'A')
#define _toupper(c) ((c)+'A'-'a')

#ifdef __cplusplus
}
#endif
#endif /* _CTYPE */
