#include <6170.h>
#include <game.h>
#include <chess_display_board.h>
#include <ctype.h>

static char sq_to_char(chess_display_board::square csq) {
  char ret;

  switch (csq.piece_type) {
  case chess_display_board::none:
    ret='_';
    break;

  case chess_display_board::pawn:
    ret='p';
    break;

  case chess_display_board::rook:
    ret='r';
    break;

  case chess_display_board::knight:
    ret='n';
    break;

  case chess_display_board::bishop:
    ret='b';
    break;

  case chess_display_board::queen:
    ret='q';
    break;

  case chess_display_board::king:
    ret='k';
    break;

  case chess_display_board::invalid:
  default:
    ret='*';
  }

  if (csq.piece_color == chess_display_board::white) 
    ret = toupper(ret);

  return ret;
}

static string sq_to_img(chess_display_board::square csq) {
  string ret;

  if (csq.piece_color == chess_display_board::white)
    ret = "w";
  else ret = "b";

  if (csq.square_color == chess_display_board::white)
   ret= ret.append('w');
  else ret=ret.append('b');

  switch (csq.piece_type) {
  case chess_display_board::none:
    ret = ret+"blank";
    break;

  case chess_display_board::pawn:
    ret = ret+"pawn";
    break;

  case chess_display_board::rook:
    ret = ret+"rook";
    break;

  case chess_display_board::knight:
    ret = ret+"knight";
    break;

  case chess_display_board::bishop:
    ret = ret+"bishop";
    break;

  case chess_display_board::queen:
    ret = ret+"queen";
    break;

  case chess_display_board::king:
    ret = ret+"king";
    break;

  case chess_display_board::invalid:
  default:
    ret = ret+"ACK! YOU WANT WHAT?";
  }

  ret = ret+".gif";
  return ret;
}

void chess_display_board::display(extensions *ext, ostream& body,
				  int player_num) const {
// Piece images are called:
// [s]<w|b><w|b><pawn|rook|knight|bishop|king|queen>.gif
//  1   2    3                   4
//  1: s if selected
//  2: piece color
//  3: square color
//  4: piece type

  square csq;
  
  check(is_associated(),"Board is not associated");
  
  switch (get_game()->winner()) {
  case -1:
      body << "<H2> It is now ";
      if (current_player())
	  body << " black's turn. </H2><P>";
      else body << "white's turn. </H2><P>";
      break;
  case -2:
      body <<"<h2> The game is a draw.</h2>";
      break;
  case 0:
      body <<"<h2> White has won.</h2>";
      break;
  case 1:
      body <<"<h2> Black has won.</h2>";
      break;
  default:
      check(false,"Impossible game winner");
  }
  
  for (int i=7; i>=0; i--) {       // Loop the rows
    body << i+1;
    for (int j=0; j<=7; j++) {     // Loop the columns
      csq=fetch(i,j);
      if (square_selected) {
	body << "<A HREF=\"" << get_game()->uri_with_move() 
	  << "board/dest?player=" << player_num  << "&square=" 
	  << (char)('a'+j) << i+1 << "\">";
	if ((sel_row == i) && (sel_col == j)) 
	  body << "<IMG BORDER=0 SRC=\"" << get_game()->image_base() << "s" <<
	    sq_to_img(csq) << "\" ALT=\"*" << sq_to_char(csq) << "*\">";
	else
	  body << "<IMG BORDER=0 SRC=\"" << get_game()->image_base() <<
	    sq_to_img(csq) << "\" ALT=\"_" << sq_to_char(csq) << "_\">";
	body << "</A>";
      } else {
	body << "<A HREF=\"" << get_game()->uri_with_move() 
	  << "board/select?player=" << player_num << "&square=" 
	  << (char)('a'+j) << i+1 << "\">";
	body << "<IMG BORDER=0 SRC=\"" << get_game()->image_base() <<
	  sq_to_img(csq) << "\" ALT=\"_" << sq_to_char(csq) << "_\">";
	body << "</A>";
      }
    }
    body << "<BR>" << endl;
  }
  body << "<P>";

// Do form here.
  body << "<FORM METHOD=\"GET\" ACTION=\"" << get_game()->uri_with_move() 
    << "board/move\">" << endl;
  body << "<INPUT TYPE=HIDDEN NAME=\"player\" VALUE=\"" << player_num
    << "\">" << endl;
  body << "Move From: ";
  if (square_selected)
    body << "<INPUT NAME=\"from\" VALUE=\"" << (char)('a'+sel_col) << sel_row+1
      << "\">" << endl;
  else body << "<INPUT NAME=\"from\">" <<endl;

  body << "<BR> Move To: <INPUT NAME=\"to\"><BR>" << endl;
  body << "<INPUT TYPE=SUBMIT VALUE=\"Move\">" << endl;
  body << "</FORM> \n";

  body << "<hr>";
  body << "<h2>Save Current Game</h2>";
  body << "<form method=\"get\" action=\"" << get_game()->uri_with_move()
       << "board/save\"> \n";
  body << "<br>\n";
  body << "File name: <input name=\"file\">\n";
  body << "<br>\n";
  body << "<input type=submit value=\"Save Game\">\n";
  body << "</form>\n";

  body << "<HR> <ADDRESS>6.170-team1@mit.edu</ADDRESS>";

}
