#ifndef _FILE_NODE_H
#define _FILE_NODE_H

#include "ps5/web_node.h"

class file_node : public web_node {
    // abstract: A "file_node" represents a URL in the web that maps to a
    //      file or directory in the local file system.
public:
    file_node(string pathname_prefix, string self_name);
	// Create a new "file_node" that redirects requests by prepending
	// "pathname_prefix" to the URL component, and whose name in the
	// containing "web_node" is "self_name".

    virtual http_response *get(string request, extensions *);
	// effects: See "web_node". If the "request" contains any
	//          pathname components that start with a dot ("."), a
	//          "Bad Request" response will be generated.
	//
	// inherit: The response to the request is computed by calling
	//          "get_file" with the pathname part of the request appended
	//          to the pathname prefix for this node. Any query portion
	//          of the request is passed as a binding of "?" in the
	//          extensions argument.
protected:
    virtual http_response *get_file(string pathname, extensions *);
	// effects: Generates a response for the full pathname contained
	//          in "pathname", which presumably is the name of a file.
	//
	// inherit: returns files with a ".html" extension
	//          as HTML documents, and other normal files as plain
	//          text documents. Symbolic links are followed to the
	//          corresponding file. Non-existent files result in a
	//          "NOT_FOUND" response. Other kinds of files, such as
	//          directories, result in a "BAD_REQUEST" response.
	//          The "query_args" are ignored.

    string prefix;    // the pathname prefix
    string self_name; // name of this node
private:
    void operator= (file_node &);
    file_node(file_node &);
    file_node();
};

bool verify_pathname(string pathname);
    // Return "true" if the pathname contains no components that begin
    // with a dot (".")

#endif /* _FILE_NODE_H */
