#ifndef _PATH_SERVER_H
#define _PATH_SERVER_H

#include <6170.h>
#include "web_server.h"
#include "table.h"
#include <stdlib.h>

class path_server : public web_server {
  public:

// abstract: A path_server is a command interpreter that invokes named methods.
//           Path_server is a heap abstraction.

//Constructor:

    path_server();
    // effects: Initizlizes this to be a path_server with no information
    //          in it.

// methods:
    
    virtual string get (string request);
    // modifies: "this"
    // effects:  If "request" does not have the form "command?arg",
    //     returns``bad request syntax''.
    //     If "command" does not name a method of "this", 
    //     returns ``command not implemented''.
    //     Otherwise, invokes the method named by "command", passing "arg"
    //     as the argument, and returns the result. 
    
    string path_db(string filename);
    // modifies: "this"
    // effects:  If "filename" is not a readable file, 
    //     returns ``unreadable file''.
    //     If the file does not have the format specified for
    //     a path database, returns "bad format".
    //     Otherwise, initializes the path database from the file and
    //     returns "ok".  (The existing database, if any, is overridden.)
    
   string path_query (string query);
    // effects: If query does not have the format "<from>",<to>",
    //          returns "bad query".  If from = to, returns 
    //          "you are already there". Otherwise, returns the answer to the
    //          query as defined in Section 1.2.

private:
    void operator= (path_server &);
    
    struct path_info {
 	float dist;
	string dir;
    };
    
    typedef array<float> *floatarray;
    typedef array<string> *rinfo;
    typedef table<string, path_info> *dest_info;
    
    array<rinfo> *routes;
    array<floatarray> *d;
    table<string, dest_info > *paths;
};


#endif /* _PATH_SERVER_H */




