template <class KEY, class VALUE>
table<KEY,VALUE>::table(bool (*eq)(KEY, KEY)) {
    els = new array<map>;
    eqp = eq;
}    

template <class KEY, class VALUE>
void table<KEY,VALUE>::insert(KEY k, VALUE v) {
    map insertion;
    VALUE temp;
    
    if (lookup(k, temp)) {
	cerr << "Value already contained in table\n";
	exit(1);
    }
    insertion.k = k;
    insertion.v = v;
    els->append(insertion);
}


template <class KEY, class VALUE>
bool table<KEY,VALUE>::lookup(KEY k, VALUE &v) const{
    int i;
    map lookup;
    
    for(i=0; i < els->length(); i++) {
	lookup = els->fetch(i);
	if (eqp(lookup.k, k)) {
	    v = lookup.v;
	    return true; 
	}
    }
    return false;
}


template <class KEY, class VALUE>
bool table<KEY,VALUE>::remove(KEY k){
    int i;
    map lookup;
    array<map> *copy_els = els->copy();
    bool removed = false;
    
    els->clear();
    for(i=0; i < copy_els->length(); i++) {
	lookup = copy_els->fetch(i);
	if (!eqp(lookup.k, k))
	    els->append(lookup);
	else
	    removed = true;
    }
    return removed;
}


template <class KEY, class VALUE>
generator<KEY>* table<KEY,VALUE>::keys() const {
    return new tablegen<KEY, VALUE>(this);
}

template <class KEY, class VALUE>
int table<KEY,VALUE>::length() {
    return els->length();
}

template <class KEY, class VALUE>
KEY table<KEY,VALUE>::get_key(int i) {
    if(i > els->length()) {
	cerr <<"i out of bounds in table::get_key\n";
	exit(1);
    }
    return els->fetch(i).k;
}


template <class KEY, class VALUE>
bool table<KEY,VALUE>::rep_ok(){
    int i;
    KEY base;
    map lookup;

    for(i=1; i < els->length(); i++) {
	base = els->fetch(0).k;  // Inefficient, but safe
	lookup = els->fetch(i);
	if (eqp(lookup.k, i))
	    return false; 
    }
    return true;
}



template <class KEY, class VALUE>
class tablegen: public generator<KEY> {

  private:
    int index;
    table<KEY, VALUE> const *me;
    
  public:
    
    tablegen(table<KEY, VALUE> const *b){
	index = 0;
	me = b;
    }    
    
    bool get(KEY &x) {
	if (index >= me->els->length())
	    return false;
	x = me->els->fetch(index).k;
	index++;
	return true;
    }
    
};


