/* mapping table of XHTML elements */
#include "HTML.h"
static ElemMapping    XHTMLElemMappingTable[] =
{
   /* This table MUST be in alphabetical order */
   {TEXT("XMLPI"), SPACE, HTML_EL_XMLPI, L_Other, FALSE},
   {TEXT("XMLPI_line"), SPACE, HTML_EL_PI_line, L_Other, FALSE},
   {TEXT("XMLcomment"), SPACE, HTML_EL_Comment_, L_Other, FALSE},
   {TEXT("XMLcomment_line"), SPACE, HTML_EL_Comment_line, L_Other, FALSE},
   {TEXT("a"), SPACE, HTML_EL_Anchor, L_Basic, TRUE},
   {TEXT("abbr"), SPACE, HTML_EL_ABBR, L_Basic, TRUE},
   {TEXT("acronym"), SPACE, HTML_EL_ACRONYM, L_Basic, TRUE},
   {TEXT("address"), SPACE, HTML_EL_Address, L_Basic, FALSE},
   {TEXT("applet"), SPACE, HTML_EL_Applet, L_Transitional, FALSE},
   {TEXT("area"), 'E', HTML_EL_AREA, L_Strict, FALSE},
   {TEXT("b"), SPACE, HTML_EL_Bold_text, L_Transitional, TRUE},
   {TEXT("base"), 'E', HTML_EL_BASE, L_Basic, FALSE},
   {TEXT("basefont"), 'E', HTML_EL_BaseFont, L_Transitional, FALSE},
   {TEXT("bdo"), SPACE, HTML_EL_BDO, L_Strict, TRUE},
   {TEXT("big"), SPACE, HTML_EL_Big_text, L_Transitional, TRUE},
   {TEXT("blockquote"), SPACE, HTML_EL_Block_Quote, L_Basic, FALSE},
   {TEXT("body"), SPACE, HTML_EL_BODY, L_Basic, FALSE},
   {TEXT("br"), 'E', HTML_EL_BR, L_Basic, TRUE},
   {TEXT("button"), SPACE, HTML_EL_BUTTON, L_Strict, TRUE},
   {TEXT("c"), SPACE, HTML_EL_TEXT_UNIT, L_Other, TRUE}, /* used by the trans.c */
   {TEXT("caption"), SPACE, HTML_EL_CAPTION, L_Basic, FALSE},
   {TEXT("center"), SPACE, HTML_EL_Center, L_Transitional, FALSE},
   {TEXT("cite"), SPACE, HTML_EL_Cite, L_Basic, TRUE},
   {TEXT("code"), SPACE, HTML_EL_Code, L_Basic, TRUE},
   {TEXT("colgroup"), SPACE, HTML_EL_COLGROUP, L_Strict, FALSE},
   {TEXT("col"), SPACE, HTML_EL_COL, L_Strict, FALSE},
   {TEXT("dd"), SPACE, HTML_EL_Definition, L_Basic, FALSE},
   {TEXT("del"), SPACE, HTML_EL_DEL, L_Strict, TRUE},
   {TEXT("dfn"), SPACE, HTML_EL_Def, L_Basic, TRUE},
   {TEXT("dir"), SPACE, HTML_EL_Directory, L_Strict, FALSE},
   {TEXT("div"), SPACE, HTML_EL_Division, L_Basic, FALSE},
   {TEXT("dl"), SPACE, HTML_EL_Definition_List, L_Basic, FALSE},
   {TEXT("dt"), SPACE, HTML_EL_Term, L_Basic, FALSE},
   {TEXT("em"), SPACE, HTML_EL_Emphasis, L_Basic, TRUE},
   {TEXT("fieldset"), SPACE, HTML_EL_FIELDSET, L_Strict, FALSE},
   {TEXT("font"), SPACE, HTML_EL_Font_, L_Transitional, TRUE},
   {TEXT("form"), SPACE, HTML_EL_Form, L_Basic, FALSE},
   {TEXT("frame"), 'E', HTML_EL_FRAME, L_Transitional, FALSE},
   {TEXT("frameset"), SPACE, HTML_EL_FRAMESET, L_Transitional, FALSE},
   {TEXT("h1"), SPACE, HTML_EL_H1, L_Basic, FALSE},
   {TEXT("h2"), SPACE, HTML_EL_H2, L_Basic, FALSE},
   {TEXT("h3"), SPACE, HTML_EL_H3, L_Basic, FALSE},
   {TEXT("h4"), SPACE, HTML_EL_H4, L_Basic, FALSE},
   {TEXT("h5"), SPACE, HTML_EL_H5, L_Basic, FALSE},
   {TEXT("h6"), SPACE, HTML_EL_H6, L_Basic, FALSE},
   {TEXT("head"), SPACE, HTML_EL_HEAD, L_Basic, FALSE},
   {TEXT("hr"), 'E', HTML_EL_Horizontal_Rule, L_Strict, FALSE},
   {TEXT("html"), SPACE, HTML_EL_HTML, L_Basic, FALSE},
   {TEXT("i"), SPACE, HTML_EL_Italic_text, L_Strict, TRUE},
   {TEXT("iframe"), SPACE, HTML_EL_IFRAME, L_Transitional, FALSE},
   {TEXT("image"), 'E', HTML_EL_PICTURE_UNIT, L_Strict, TRUE},
   {TEXT("img"), 'E', HTML_EL_PICTURE_UNIT, L_Basic, TRUE},
   {TEXT("input"), 'E', HTML_EL_Input, L_Basic, TRUE},
   {TEXT("input"), 'E', HTML_EL_Text_Input, L_Basic, TRUE},
   {TEXT("input"), 'E', HTML_EL_Password_Input, L_Basic, TRUE},
   {TEXT("input"), 'E', HTML_EL_File_Input, L_Basic, TRUE},
   {TEXT("input"), 'E', HTML_EL_Checkbox_Input, L_Basic, FALSE},
   {TEXT("input"), 'E', HTML_EL_Radio_Input, L_Basic, FALSE},
   {TEXT("input"), 'E', HTML_EL_Submit_Input, L_Basic, FALSE},
   {TEXT("input"), 'E', HTML_EL_Reset_Input, L_Basic, FALSE},
   {TEXT("input"), 'E', HTML_EL_Button_Input, L_Basic, TRUE},
   {TEXT("input"), 'E', HTML_EL_Hidden_Input, L_Basic, FALSE},
   {TEXT("ins"), SPACE, HTML_EL_INS, L_Strict, TRUE},
   {TEXT("isindex"), 'E', HTML_EL_ISINDEX, L_Transitional, FALSE},
   {TEXT("kbd"), SPACE, HTML_EL_Keyboard, L_Basic, TRUE},
   {TEXT("label"), SPACE, HTML_EL_LABEL, L_Basic, TRUE},
   {TEXT("legend"), SPACE, HTML_EL_LEGEND, L_Strict, FALSE},
   {TEXT("li"), SPACE, HTML_EL_List_Item, L_Basic, FALSE},
   {TEXT("link"), 'E', HTML_EL_LINK, L_Basic, FALSE},
   {TEXT("listing"), SPACE, HTML_EL_Preformatted, L_Transitional, FALSE}, /*converted to PRE */
   {TEXT("map"), SPACE, HTML_EL_MAP, L_Strict, FALSE},
   {TEXT("menu"), SPACE, HTML_EL_Menu, L_Transitional, FALSE},
   {TEXT("meta"), 'E', HTML_EL_META, L_Basic, FALSE},
   {TEXT("noframes"), SPACE, HTML_EL_NOFRAMES, L_Transitional, FALSE},
   {TEXT("noscript"), SPACE, HTML_EL_NOSCRIPT, L_Strict, FALSE},
   {TEXT("object"), SPACE, HTML_EL_Object, L_Basic, FALSE},
   {TEXT("ol"), SPACE, HTML_EL_Numbered_List, L_Basic, FALSE},
   {TEXT("optgroup"), SPACE, HTML_EL_OptGroup, L_Strict, TRUE},
   {TEXT("option"), SPACE, HTML_EL_Option, L_Basic, TRUE},
   {TEXT("p"), SPACE, HTML_EL_Paragraph, L_Basic, FALSE},
   {TEXT("p*"), SPACE, HTML_EL_Pseudo_paragraph, L_Basic, FALSE}, /* pseudo-paragraph */
   {TEXT("param"), 'E', HTML_EL_Parameter, L_Basic, FALSE},
   {TEXT("plaintext"), SPACE, HTML_EL_Preformatted, L_Transitional, FALSE},/* converted to PRE */
   {TEXT("pre"), SPACE, HTML_EL_Preformatted, L_Basic, FALSE},
   {TEXT("q"), SPACE, HTML_EL_Quotation, L_Basic, TRUE},
   {TEXT("s"), SPACE, HTML_EL_Struck_text, L_Strict, TRUE},
   {TEXT("samp"), SPACE, HTML_EL_Sample, L_Basic, TRUE},
   {TEXT("script"), SPACE, HTML_EL_SCRIPT, L_Strict, FALSE},
   {TEXT("select"), SPACE, HTML_EL_Option_Menu, L_Basic, TRUE},
   {TEXT("small"), SPACE, HTML_EL_Small_text, L_Strict, TRUE},
   {TEXT("span"), SPACE, HTML_EL_Span, L_Basic, TRUE},
   {TEXT("strike"), SPACE, HTML_EL_Struck_text, L_Transitional, TRUE},
   {TEXT("strong"), SPACE, HTML_EL_Strong, L_Basic, TRUE},
   {TEXT("style"), SPACE, HTML_EL_STYLE_, L_Strict, FALSE},
   {TEXT("sub"), SPACE, HTML_EL_Subscript, L_Strict, TRUE},
   {TEXT("sup"), SPACE, HTML_EL_Superscript, L_Strict, TRUE},
   {TEXT("table"), SPACE, HTML_EL_Table, L_Basic, FALSE},
   {TEXT("tbody"), SPACE, HTML_EL_tbody, L_Basic, FALSE},
   {TEXT("td"), SPACE, HTML_EL_Data_cell, L_Basic, FALSE},
   {TEXT("textarea"), SPACE, HTML_EL_Text_Area, L_Basic, TRUE},
   {TEXT("tfoot"), SPACE, HTML_EL_tfoot, L_Strict, FALSE},
   {TEXT("th"), SPACE, HTML_EL_Heading_cell, L_Basic, FALSE},
   {TEXT("thead"), SPACE, HTML_EL_thead, L_Strict, FALSE},
   {TEXT("title"), SPACE, HTML_EL_TITLE, L_Basic, FALSE},
   {TEXT("tr"), SPACE, HTML_EL_Table_row, L_Basic, FALSE},
   {TEXT("tt"), SPACE, HTML_EL_Teletype_text, L_Strict, TRUE},
   {TEXT("u"), SPACE, HTML_EL_Underlined_text, L_Strict, TRUE},
   {TEXT("ul"), SPACE, HTML_EL_Unnumbered_List, L_Basic, FALSE},
   {TEXT("var"), SPACE, HTML_EL_Variable, L_Basic, TRUE},
   {TEXT("xmp"), SPACE, HTML_EL_Preformatted, L_Transitional, FALSE},  /* converted to PRE */
   {TEXT(""), SPACE, 0, L_Basic, FALSE}	  /* Last entry. Mandatory */
};

/* mapping table of Xhtml attributes */
AttributeMapping XHTMLAttributeMappingTable[] =
{
   /* The first entry MUST be unknown_attr */
   /* The rest of this table MUST be in alphabetical order */
   {TEXT("unknown_attr"), TEXT(""), 'A', HTML_ATTR_Invalid_attribute, L_Transitional},

   {TEXT("abbr"), TEXT(""), 'A', HTML_ATTR_abbr, L_Basic},
   {TEXT("accept"), TEXT(""), 'A', HTML_ATTR_accept, L_Basic},
   {TEXT("accept-charset"), TEXT("form"), 'A', HTML_ATTR_accept_charset, L_Basic},
   {TEXT("accesskey"), TEXT(""), 'A', HTML_ATTR_accesskey, L_Basic},
   {TEXT("action"), TEXT(""), 'A', HTML_ATTR_Script_URL, L_Basic},
   {TEXT("align"), TEXT("applet"), 'A', HTML_ATTR_Alignment, L_Transitional},
   {TEXT("align"), TEXT("caption"), 'A', HTML_ATTR_Position, L_Strict},
   {TEXT("align"), TEXT("col"), 'A', HTML_ATTR_Cell_align, L_Strict},
   {TEXT("align"), TEXT("colgroup"), 'A', HTML_ATTR_Cell_align, L_Strict},
   {TEXT("align"), TEXT("div"), 'A', HTML_ATTR_TextAlign, L_Transitional},
   {TEXT("align"), TEXT("h1"), 'A', HTML_ATTR_TextAlign, L_Transitional},
   {TEXT("align"), TEXT("h2"), 'A', HTML_ATTR_TextAlign, L_Transitional},
   {TEXT("align"), TEXT("h3"), 'A', HTML_ATTR_TextAlign, L_Transitional},
   {TEXT("align"), TEXT("h4"), 'A', HTML_ATTR_TextAlign, L_Transitional},
   {TEXT("align"), TEXT("h5"), 'A', HTML_ATTR_TextAlign, L_Transitional},
   {TEXT("align"), TEXT("h6"), 'A', HTML_ATTR_TextAlign, L_Transitional},
   {TEXT("align"), TEXT("hr"), 'A', HTML_ATTR_Align, L_Transitional},
   {TEXT("align"), TEXT("iframe"), 'A', HTML_ATTR_Alignment, L_Transitional},
   {TEXT("align"), TEXT("image"), 'A', HTML_ATTR_Alignment, L_Transitional},
   {TEXT("align"), TEXT("img"), 'A', HTML_ATTR_Alignment, L_Transitional},
   {TEXT("align"), TEXT("input"), 'A', HTML_ATTR_Alignment, L_Transitional},
   {TEXT("align"), TEXT("legend"), 'A', HTML_ATTR_LAlign, L_Transitional},
   {TEXT("align"), TEXT("object"), 'A', HTML_ATTR_Alignment, L_Transitional},
   {TEXT("align"), TEXT("p"), 'A', HTML_ATTR_TextAlign, L_Transitional},
   {TEXT("align"), TEXT("table"), 'A', HTML_ATTR_Align, L_Transitional},
   {TEXT("align"), TEXT("tbody"), 'A', HTML_ATTR_Cell_align, L_Strict},
   {TEXT("align"), TEXT("td"), 'A', HTML_ATTR_Cell_align, L_Strict},
   {TEXT("align"), TEXT("tfoot"), 'A', HTML_ATTR_Cell_align, L_Strict},
   {TEXT("align"), TEXT("th"), 'A', HTML_ATTR_Cell_align, L_Strict},
   {TEXT("align"), TEXT("thead"), 'A', HTML_ATTR_Cell_align, L_Strict},
   {TEXT("align"), TEXT("tr"), 'A', HTML_ATTR_Cell_align, L_Strict},
   {TEXT("alink"), TEXT("body"), 'A', HTML_ATTR_ActiveLinkColor, L_Transitional},
   {TEXT("alt"), TEXT(""), 'A', HTML_ATTR_ALT, L_Basic},
   {TEXT("archive"), TEXT(""), 'A', HTML_ATTR_archive, L_Basic},
   {TEXT("axis"), TEXT(""), 'A', HTML_ATTR_axis, L_Basic},

   {TEXT("background"), TEXT(""), 'A', HTML_ATTR_background_, L_Transitional},
   {TEXT("bgcolor"), TEXT(""), 'A', HTML_ATTR_BackgroundColor, L_Transitional},
   {TEXT("border"), TEXT("image"), 'A', HTML_ATTR_Img_border, L_Transitional},
   {TEXT("border"), TEXT("img"), 'A', HTML_ATTR_Img_border, L_Transitional},
   {TEXT("border"), TEXT("object"), 'A', HTML_ATTR_Img_border, L_Transitional},
   {TEXT("border"), TEXT("table"), 'A', HTML_ATTR_Border, L_Strict},

   {TEXT("cellspacing"), TEXT(""), 'A', HTML_ATTR_cellspacing, L_Strict},
   {TEXT("cellpadding"), TEXT(""), 'A', HTML_ATTR_cellpadding, L_Strict},
   {TEXT("char"), TEXT(""), 'A', HTML_ATTR_char, L_Transitional},
   {TEXT("charoff"), TEXT(""), 'A', HTML_ATTR_charoff, L_Transitional},
   {TEXT("charset"), TEXT(""), 'A', HTML_ATTR_charset, L_Basic},
   {TEXT("checked"), TEXT(""), 'A', HTML_ATTR_Checked, L_Basic},
   {TEXT("cite"), TEXT(""), 'A', HTML_ATTR_cite, L_Basic},
   {TEXT("class"), TEXT(""), 'A', HTML_ATTR_Class, L_Basic},
   {TEXT("classid"), TEXT(""), 'A', HTML_ATTR_classid, L_Basic},
   {TEXT("clear"), TEXT("br"), 'A', HTML_ATTR_Clear, L_Transitional},
   {TEXT("code"), TEXT(""), 'A', HTML_ATTR_code, L_Basic},
   {TEXT("codebase"), TEXT(""), 'A', HTML_ATTR_codebase, L_Basic},
   {TEXT("codetype"), TEXT(""), 'A', HTML_ATTR_codetype, L_Basic},
   {TEXT("color"), TEXT("basefont"), 'A', HTML_ATTR_BaseFontColor, L_Transitional},
   {TEXT("color"), TEXT(""), 'A', HTML_ATTR_color, L_Transitional},
   {TEXT("cols"), TEXT("frameset"), 'A', HTML_ATTR_ColWidth, L_Transitional},
   {TEXT("cols"), TEXT("textarea"), 'A', HTML_ATTR_Columns, L_Basic},
   {TEXT("colspan"), TEXT(""), 'A', HTML_ATTR_colspan_, L_Basic},
   {TEXT("compact"), TEXT(""), 'A', HTML_ATTR_COMPACT, L_Transitional},
   {TEXT("content"), TEXT(""), 'A', HTML_ATTR_meta_content, L_Basic},
   {TEXT("coords"), TEXT(""), 'A', HTML_ATTR_coords, L_Basic},

   {TEXT("data"), TEXT(""), 'A', HTML_ATTR_data, L_Basic},
   {TEXT("datapagesize"), TEXT("table"), 'A', HTML_ATTR_datapagesize, L_Basic},
   {TEXT("datetime"), TEXT(""), 'A', HTML_ATTR_datetime, L_Basic},
   {TEXT("declare"), TEXT("object"), 'A', HTML_ATTR_declare, L_Basic},
   {TEXT("defer"), TEXT("script"), 'A', HTML_ATTR_defer, L_Basic},
   {TEXT("dir"), TEXT(""), 'A', HTML_ATTR_dir, L_Basic},
   {TEXT("disabled"), TEXT(""), 'A', HTML_ATTR_disabled, L_Basic},

   {TEXT("enctype"), TEXT(""), 'A', HTML_ATTR_ENCTYPE, L_Strict},
   {TEXT("event"), TEXT("script"), 'A', HTML_ATTR_event, L_Strict},

   {TEXT("face"), TEXT("basefont"), 'A', HTML_ATTR_BaseFontFace, L_Transitional},
   {TEXT("face"), TEXT("font"), 'A', HTML_ATTR_face, L_Transitional},
   {TEXT("for"), TEXT("label"), 'A', HTML_ATTR_Associated_control, L_Strict},
   {TEXT("for"), TEXT("script"), 'A', HTML_ATTR_for_, L_Strict},
   {TEXT("frame"), TEXT("table"), 'A', HTML_ATTR_frame, L_Strict},
   {TEXT("frameborder"), TEXT(""), 'A', HTML_ATTR_frameborder, L_Transitional},

   {TEXT("headers"), TEXT(""), 'A', HTML_ATTR_headers, L_Transitional},
   {TEXT("height"), TEXT("img"), 'A', HTML_ATTR_Height_, L_Basic},
   {TEXT("height"), TEXT("object"), 'A', HTML_ATTR_Height_, L_Basic},
   {TEXT("height"), TEXT(""), 'A', HTML_ATTR_Height_, L_Transitional},
   {TEXT("href"), TEXT(""), 'A', HTML_ATTR_HREF_, L_Basic},
   {TEXT("hreflang"), TEXT(""), 'A', HTML_ATTR_hreflang, L_Basic},
   {TEXT("hspace"), TEXT(""), 'A', HTML_ATTR_hspace, L_Transitional},
   {TEXT("http-equiv"), TEXT(""), 'A', HTML_ATTR_http_equiv, L_Basic},

   {TEXT("id"), TEXT(""), 'A', HTML_ATTR_ID, L_Basic},
   {TEXT("ismap"), TEXT(""), 'A', HTML_ATTR_ISMAP, L_Strict},

   {TEXT("label"), TEXT(""), 'A', HTML_ATTR_label, L_Basic},
   {TEXT("lang"), TEXT(""), 'A', HTML_ATTR_Langue, L_Basic},
   {TEXT("language"), TEXT("script"), 'A', HTML_ATTR_script_language, L_Basic},
   {TEXT("link"), TEXT("body"), 'A', HTML_ATTR_LinkColor, L_Basic},
   {TEXT("longdesc"), TEXT(""), 'A', HTML_ATTR_longdesc, L_Basic},

   {TEXT("marginheight"), TEXT(""), 'A', HTML_ATTR_marginheight, L_Transitional},
   {TEXT("marginwidth"), TEXT(""), 'A', HTML_ATTR_marginwidth, L_Transitional},
   {TEXT("maxlength"), TEXT(""), 'A', HTML_ATTR_MaxLength, L_Basic},
   {TEXT("media"), TEXT(""), 'A', HTML_ATTR_media, L_Basic},
   {TEXT("method"), TEXT(""), 'A', HTML_ATTR_METHOD, L_Basic},
   {TEXT("multiple"), TEXT(""), 'A', HTML_ATTR_Multiple, L_Basic},

   {TEXT("name"), TEXT("applet"), 'A', HTML_ATTR_applet_name, L_Transitional},
   {TEXT("name"), TEXT("frame"), 'A', HTML_ATTR_FrameName, L_Transitional},
   {TEXT("name"), TEXT("iframe"), 'A', HTML_ATTR_FrameName, L_Transitional},
   {TEXT("name"), TEXT("meta"), 'A', HTML_ATTR_meta_name, L_Basic},
   {TEXT("name"), TEXT("param"), 'A', HTML_ATTR_Param_name, L_Basic},
   {TEXT("name"), TEXT(""), 'A', HTML_ATTR_NAME, L_Basic},
   {TEXT("nohref"), TEXT(""), 'A', HTML_ATTR_nohref, L_Basic},
   {TEXT("noresize"), TEXT(""), 'A', HTML_ATTR_no_resize, L_Basic},
   {TEXT("noshade"), TEXT(""), 'A', HTML_ATTR_NoShade, L_Basic},
   {TEXT("nowrap"), TEXT(""), 'A', HTML_ATTR_No_wrap, L_Transitional},

   {TEXT("object"), TEXT("applet"), 'A', HTML_ATTR_object, L_Transitional},
   {TEXT("onblur"), TEXT(""), 'A', HTML_ATTR_onblur, L_Strict},
   {TEXT("onchange"), TEXT(""), 'A', HTML_ATTR_onchange, L_Strict},
   {TEXT("onclick"), TEXT(""), 'A', HTML_ATTR_onclick, L_Strict},
   {TEXT("ondblclick"), TEXT(""), 'A', HTML_ATTR_ondblclick, L_Strict},
   {TEXT("onfocus"), TEXT(""), 'A', HTML_ATTR_onfocus, L_Strict},
   {TEXT("onkeydown"), TEXT(""), 'A', HTML_ATTR_onkeydown, L_Strict},
   {TEXT("onkeypress"), TEXT(""), 'A', HTML_ATTR_onkeypress, L_Strict},
   {TEXT("onkeyup"), TEXT(""), 'A', HTML_ATTR_onkeyup, L_Strict},
   {TEXT("onload"), TEXT(""), 'A', HTML_ATTR_onload, L_Strict},
   {TEXT("onmousedown"), TEXT(""), 'A', HTML_ATTR_onmousedown, L_Strict},
   {TEXT("onmousemove"), TEXT(""), 'A', HTML_ATTR_onmousemove, L_Strict},
   {TEXT("onmouseout"), TEXT(""), 'A', HTML_ATTR_onmouseout, L_Strict},
   {TEXT("onmouseover"), TEXT(""), 'A', HTML_ATTR_onmouseover, L_Strict},
   {TEXT("onmouseup"), TEXT(""), 'A', HTML_ATTR_onmouseup, L_Strict},
   {TEXT("onreset"), TEXT("form"), 'A', HTML_ATTR_onreset, L_Strict},
   {TEXT("onselect"), TEXT(""), 'A', HTML_ATTR_onselect, L_Strict},
   {TEXT("onsubmit"), TEXT("form"), 'A', HTML_ATTR_onsubmit, L_Strict},
   {TEXT("onunload"), TEXT(""), 'A', HTML_ATTR_onunload, L_Strict},

   {TEXT("profile"), TEXT("head"), 'A', HTML_ATTR_profile, L_Basic},
   {TEXT("prompt"), TEXT(""), 'A', HTML_ATTR_Prompt, L_Strict},

   {TEXT("readonly"), TEXT(""), 'A', HTML_ATTR_readonly, L_Basic},
   {TEXT("rel"), TEXT(""), 'A', HTML_ATTR_REL, L_Basic},
   {TEXT("rev"), TEXT(""), 'A', HTML_ATTR_REV, L_Basic},
   {TEXT("rows"), TEXT("frameset"), 'A', HTML_ATTR_RowHeight, L_Transitional},
   {TEXT("rows"), TEXT("textarea"), 'A', HTML_ATTR_Rows, L_Basic},
   {TEXT("rowspan"), TEXT(""), 'A', HTML_ATTR_rowspan_, L_Basic},
   {TEXT("rules"), TEXT("table"), 'A', HTML_ATTR_rules_, L_Strict},

   {TEXT("scheme"), TEXT("meta"), 'A', HTML_ATTR_scheme, L_Basic},
   {TEXT("scope"), TEXT(""), 'A', HTML_ATTR_scope, L_Basic},
   {TEXT("scrolling"), TEXT(""), 'A', HTML_ATTR_scrolling, L_Transitional},
   {TEXT("selected"), TEXT(""), 'A', HTML_ATTR_Selected, L_Basic},
   {TEXT("shape"), TEXT(""), 'A', HTML_ATTR_shape, L_Strict},
   {TEXT("size"), TEXT("basefont"), 'A', HTML_ATTR_BaseFontSize, L_Transitional},
   {TEXT("size"), TEXT("font"), 'A', HTML_ATTR_Font_size, L_Transitional},
   {TEXT("size"), TEXT("hr"), 'A', HTML_ATTR_Size_, L_Transitional},
   {TEXT("size"), TEXT("input"), 'A', HTML_ATTR_Area_Size, L_Strict},
   {TEXT("size"), TEXT("select"), 'A', HTML_ATTR_MenuSize, L_Strict},
   {TEXT("span"), TEXT("col"), 'A', HTML_ATTR_span_, L_Strict},
   {TEXT("span"), TEXT("colgroup"), 'A', HTML_ATTR_span_, L_Strict},
   {TEXT("src"), TEXT("frame"), 'A', HTML_ATTR_FrameSrc, L_Transitional},
   {TEXT("src"), TEXT("iframe"), 'A', HTML_ATTR_FrameSrc, L_Transitional},
   {TEXT("src"), TEXT("script"), 'A', HTML_ATTR_script_src, L_Strict},
   {TEXT("src"), TEXT(""), 'A', HTML_ATTR_SRC, L_Basic},
   {TEXT("standby"), TEXT(""), 'A', HTML_ATTR_standby, L_Basic},
   {TEXT("start"), TEXT(""), 'A', HTML_ATTR_Start, L_Basic},
   {TEXT("style"), TEXT(""), 'A', HTML_ATTR_Style_, L_Basic},
   {TEXT("summary"), TEXT("table"), 'A', HTML_ATTR_summary, L_Basic},

   {TEXT("tabindex"), TEXT(""), 'A', HTML_ATTR_tabindex, L_Basic},
   {TEXT("target"), TEXT(""), 'A', HTML_ATTR_target_, L_Basic},
   {TEXT("text"), TEXT(""), 'A', HTML_ATTR_TextColor, L_Basic},
   {TEXT("title"), TEXT(""), 'A', HTML_ATTR_Title, L_Basic},
   {TEXT("type"), TEXT("button"), 'A', HTML_ATTR_Button_type, L_Strict},
   {TEXT("type"), TEXT("li"), 'A', HTML_ATTR_ItemStyle, L_Basic},
   {TEXT("type"), TEXT("link"), 'A', HTML_ATTR_Link_type, L_Basic},
   {TEXT("type"), TEXT("a"), 'A', HTML_ATTR_Link_type, L_Basic},
   {TEXT("type"), TEXT("object"), 'A', HTML_ATTR_Object_type, L_Basic},
   {TEXT("type"), TEXT("ol"), 'A', HTML_ATTR_NumberStyle, L_Basic},
   {TEXT("type"), TEXT("param"), 'A', HTML_ATTR_Param_type, L_Basic},
   {TEXT("type"), TEXT("script"), 'A', HTML_ATTR_content_type, L_Strict},
   {TEXT("type"), TEXT("style"), 'A', HTML_ATTR_Notation, L_Strict},
   {TEXT("type"), TEXT("ul"), 'A', HTML_ATTR_BulletStyle, L_Basic},
   {TEXT("type"), TEXT(""), SPACE, DummyAttribute, L_Basic},

   {TEXT("usemap"), TEXT(""), 'A', HTML_ATTR_USEMAP, L_Basic},

   {TEXT("valign"), TEXT("tbody"), 'A', HTML_ATTR_Row_valign, L_Strict},
   {TEXT("valign"), TEXT("td"), 'A', HTML_ATTR_Cell_valign, L_Strict},
   {TEXT("valign"), TEXT("tfoot"), 'A', HTML_ATTR_Row_valign, L_Strict},
   {TEXT("valign"), TEXT("th"), 'A', HTML_ATTR_Cell_valign, L_Strict},
   {TEXT("valign"), TEXT("thead"), 'A', HTML_ATTR_Row_valign, L_Strict},
   {TEXT("valign"), TEXT("tr"), 'A', HTML_ATTR_Row_valign, L_Strict},
   {TEXT("value"), TEXT("li"), 'A', HTML_ATTR_ItemValue, L_Basic},
   {TEXT("value"), TEXT("param"), 'A', HTML_ATTR_Param_value, L_Basic},
   {TEXT("value"), TEXT(""), 'A', HTML_ATTR_Value_, L_Basic},
   {TEXT("valuetype"), TEXT("param"), 'A', HTML_ATTR_valuetype, L_Basic},
   {TEXT("version"), TEXT(""), 'A', 0, L_Basic},
   {TEXT("vlink"), TEXT("body"), 'A', HTML_ATTR_VisitedLinkColor, L_Transitional},
   {TEXT("vspace"), TEXT(""), 'A', HTML_ATTR_vspace, L_Transitional},

   {TEXT("width"), TEXT("applet"), 'A', HTML_ATTR_Width__, L_Transitional},
   {TEXT("width"), TEXT("col"), 'A', HTML_ATTR_Width__, L_Strict},
   {TEXT("width"), TEXT("colgroup"), 'A', HTML_ATTR_Width__, L_Strict},
   {TEXT("width"), TEXT("hr"), 'A', HTML_ATTR_Width__, L_Transitional},
   {TEXT("width"), TEXT("iframe"), 'A', HTML_ATTR_Width__, L_Transitional},
   {TEXT("width"), TEXT("image"), 'A', HTML_ATTR_Width__, L_Transitional},
   {TEXT("width"), TEXT("img"), 'A', HTML_ATTR_Width__, L_Basic},
   {TEXT("width"), TEXT("object"), 'A', HTML_ATTR_Width__, L_Basic},
   {TEXT("width"), TEXT("pre"), 'A', HTML_ATTR_Width__, L_Transitional},
   {TEXT("width"), TEXT("table"), 'A', HTML_ATTR_Width__, L_Strict},
   {TEXT("width"), TEXT("td"), 'A', HTML_ATTR_Width__, L_Transitional},
   {TEXT("width"), TEXT("th"), 'A', HTML_ATTR_Width__, L_Transitional},

   {TEXT("xml:space"), TEXT(""), 'A', HTML_ATTR_xml_space, L_Basic},

   {TEXT("zzghost"), TEXT(""), 'A', HTML_ATTR_Ghost_restruct, L_Basic},
   {TEXT(""), TEXT(""), EOS, 0, L_Other}		/* Last entry. Mandatory */
};

