/*
 * KCLL -  Ken and Chee's Limey Lisp  
 * All Rights to the code and any products created with this code is 
 * hereby granted. 
 *
 * I.E. You can do whatever the hell you want with this code. 
 * The only restriction is that this copyright notice not be modified.
 */

#include <ctype.h>
#include "fix.h"
#include "stream.h"
#include "cont.h"

LLTag llfix_t;

static void print_fix (fix, stream)
     LLFix *fix;
     LLStream *stream;
{
  llstrprintf(stream, "%lf", fix->value);
}

LLFix *llread_fix(stream)
     LLStream *stream;
{
  char c;
  int n, d;
  int decimal = 0;
  
  d = 1;
  n = 0;
  while (isdigit(c = llread_stream(stream)))
    n = (n * 10) + (c-48);
  llunread_stream(stream, c);
  return (llint_to_fix(n));
}

LLFix *llint_to_fix(n) 
     int n;
{
  LLFix *fix;

  fix = (LLFix *) llmake_obj(llfix_t);
  fix->value = n;
  return fix;
}



/*  Math stuff */

/*  adds all top arguments from the stack. 
    The fixber of args should be in llargc 
    returns value onto the stack.
*/ 


static void do_math(type, retval) 
     LLMathType type; 
     int *retval;
{
  switch (type) {
  case FIX_ADD:
    *retval += llfix_to_int((LLFix *)llnextcheckedarg(llfix_t));
    break;
  case FIX_SUB:
    *retval -= llfix_to_int((LLFix *)llnextcheckedarg(llfix_t));
    break;
  case FIX_MUL:
    *retval *= llfix_to_int((LLFix *)llnextcheckedarg(llfix_t));
    break;
  case FIX_DIV:
    *retval /= llfix_to_int((LLFix *)llnextcheckedarg(llfix_t));
    break;
  }
}

static void llarithmetic(type, retval)
     LLMathType type;
     int retval;
{
  while(llmoreargs()) {
    do_math(type, &retval);
  }
  llpusharg(llint_to_fix(retval));
}

/* comparators */

static LLObj *compare(type, a,b)
     LLCompareType type;
     int a , b;
{
  switch (type) {
  case FIX_LT: 
    return( (a < b) ? T: NIL);
  case FIX_GT: 
    return( (a > b) ? T: NIL);
  case FIX_EQ:
    return( (a == b) ? T: NIL);
  case FIX_LE:
    return( (a <= b) ? T: NIL);
  case FIX_GE:
    return( (a >= b) ? T: NIL);
  case FIX_NE:
    return( (a != b) ? T: NIL);
  }
}

static void fix_compare(type)
     LLCompareType type; 
{
  LLFix *fix;
  int val1, val2;

  fix = (LLFix *)(llnextcheckedarg(llfix_t));
  val1 = llfix_to_int(fix);

  fix = (LLFix *)(llnextcheckedarg(llfix_t));
  val2 = llfix_to_int(fix);

  lllastarg();
  llpusharg(compare(type, val1, val2)); 
}

lladdone() {
  int fix; 
  fix = llfix_to_int((llnextcheckedarg(llfix_t)));
  llpusharg(llint_to_fix(fix + 1.0));
}
llsubone() {
  int fix; 
  fix = llfix_to_int((llnextcheckedarg(llfix_t)));
  llpusharg(llint_to_fix(fix - 1.0));
}

llfix_add() {  llarithmetic(FIX_ADD, 0.0); }
llfix_mul() {  llarithmetic(FIX_MUL, 1.0); }

llfix_sub() {
  LLFix *fix; 

  if(llargc <= 1) llarithmetic(FIX_SUB, 0.0);
  else {
    fix = (LLFix *) llnextcheckedarg(llfix_t);
    llarithmetic(FIX_SUB, llfix_to_int(fix)); 
  }
}

llfix_div() 
{
  LLFix *fix; 

  if(llargc <= 1) 
    llarithmetic(FIX_DIV, 1.0);
  else {
    fix = (LLFix *) llnextcheckedarg(llfix_t);
    llarithmetic(FIX_DIV, llfix_to_int(fix)); 
  }
}

llngt() { fix_compare(FIX_GT); }
llnlt() { fix_compare(FIX_LT); }
llnge() { fix_compare(FIX_GE); }
llnle() { fix_compare(FIX_LE); }
llneq() { fix_compare(FIX_EQ); }
llnne() { fix_compare(FIX_NE); }

int llfix_compare(cmptype, n1, n2) 
     LLCompare cmptype; 
     LLFix *n1, *n2; 
{
  return(compare(cmptype, 
		 llfix_to_int(n1), 
		 llfix_to_int(n2)) == T);
}
void llinit_fix()
{
  llfix_t = lladd_obj_td (sizeof(LLFix), "Fixber",
		      0, 0, print_fix, 0);
  				/* Note: the read method for fixbers
				   is called from read_obj (read.c) */
  
  llregister_cfunc(llngt,">");
  llregister_cfunc(llnlt,"<");
  llregister_cfunc(llnge,">=");
  llregister_cfunc(llnle,"<=");
  llregister_cfunc(llneq,"=");
  llregister_cfunc(llnne,"/=");
  llregister_cfunc(llnne,"!=");
  llregister_cfunc(llfix_add, "+");
  llregister_cfunc(llfix_sub, "-");
  llregister_cfunc(llfix_mul, "*");
  llregister_cfunc(llfix_div, "/");
  llregister_cfunc(lladdone, "1+");
  llregister_cfunc(llsubone, "-1+");
}

