/*
 *  Asus MyPal A716 PM glue driver
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  Copyright (C) 2005-2007 Pawel Kolodziejski
 *
 */

#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/major.h>
#include <linux/fs.h>
#include <linux/interrupt.h>
#include <linux/delay.h>
#include <linux/lcd.h>
#include <linux/backlight.h>
#include <linux/fb.h>
#include <linux/slab.h>
#include <linux/proc_fs.h>
#include <linux/platform_device.h>

#include <asm/setup.h>
#include <asm/memory.h>
#include <asm/hardware.h>
#include <asm/irq.h>
#include <asm/apm.h>

#include <asm/mach-types.h>
#include <asm/mach/arch.h>
#include <asm/mach/map.h>
#include <asm/mach/irda.h>

#include <asm/arch/serial.h>
#include <asm/arch/udc.h>
#include <asm/arch/pxa-regs.h>
#include <../drivers/pcmcia/soc_common.h>
#include <asm/arch/pxafb.h>
#include <asm/arch/mmc.h>
#include <asm/arch/asus716-gpio.h>
#include <asm/arch/irda.h>

static int a716_battery_power;
unsigned long a716_ssp_putget(ulong data);

#define CTRL_START  0x80
#define CTRL_VBAT   0x24
#define CTRL_PD0    0x01

#define A716_MAIN_BATTERY_MAX 1676 // ~ sometimes it's more or less (> 1700 - AC)
#define A716_MAIN_BATTERY_MIN 1347
#define A716_MAIN_BATTERY_RANGE (A716_MAIN_BATTERY_MAX - A716_MAIN_BATTERY_MIN)

static void a716_battery(void)
{
	int sample;

	sample = a716_ssp_putget(CTRL_PD0 | CTRL_START | CTRL_VBAT); // main battery: min - 1347, max - 1676 (1700 AC)
	a716_ssp_putget(CTRL_START | CTRL_VBAT);

	sample = ((sample - A716_MAIN_BATTERY_MIN) * 100) / A716_MAIN_BATTERY_RANGE;
	if (sample > 100)
		a716_battery_power = 100;
	else
		a716_battery_power = sample;

	if (a716_battery_power < 10 && !(GPLR(GPIO_NR_A716_AC_DETECT) & GPIO_bit(GPIO_NR_A716_AC_DETECT)))
		a716_gpo_set(GPO_A716_POWER_LED_RED);
	else
		a716_gpo_clear(GPO_A716_POWER_LED_RED);

	//printk("battery: %d\n", a716_battery_power);
}

typedef void (*apm_get_power_status_t)(struct apm_power_info*);

static void a716_apm_get_power_status(struct apm_power_info *info)
{
	a716_battery();

	info->battery_life = a716_battery_power;

	if (!(GPLR(GPIO_NR_A716_AC_DETECT) & GPIO_bit(GPIO_NR_A716_AC_DETECT)))
		info->ac_line_status = APM_AC_OFFLINE;
	else
		info->ac_line_status = APM_AC_ONLINE;

	if (a716_battery_power > 50)
		info->battery_status = APM_BATTERY_STATUS_HIGH;
	else if (a716_battery_power < 10)
		info->battery_status = APM_BATTERY_STATUS_CRITICAL;
	else
		info->battery_status = APM_BATTERY_STATUS_LOW;

	info->time = 0;
	info->units = 0;
}

int a716_set_apm_get_power_status(void)
{
	apm_get_power_status = a716_apm_get_power_status;

	return 0;
}
