/** @file wlan_types.h
  * @brief This header file contains definition for global types
  *
  * (c) Copyright  2003-2006, Marvell International Ltd. 
  * All Rights Reserved
  *
  * This software file (the "File") is distributed by Marvell International 
  * Ltd. under the terms of the GNU General Public License Version 2, June 1991 
  * (the "License").  You may use, redistribute and/or modify this File in 
  * accordance with the terms and conditions of the License, a copy of which 
  * is available along with the File in the license.txt file or by writing to 
  * the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 
  * 02111-1307 or on the worldwide web at http://www.gnu.org/licenses/gpl.txt.
  *
  * THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE 
  * IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE 
  * ARE EXPRESSLY DISCLAIMED.  The License provides additional details about 
  * this warranty disclaimer.
  *
  */
/*************************************************************
Change log:
	10/11/05: add Doxygen format comments 
	01/11/06: Add IEEE Association response type.  Add TSF TLV information.
	01/31/06: Add support to selectively enabe the FW Scan channel filter
	04/10/06: Add power_adapt_cfg_ext command
	04/18/06: Remove old Subscrive Event and add new Subscribe Event
		  implementation through generic hostcmd API
************************************************************/

#ifndef _WLAN_TYPES_
#define _WLAN_TYPES_

/** IEEE Type definitions  */
typedef enum _IEEEtypes_ElementId_e {
    SSID = 0,
    SUPPORTED_RATES,
    FH_PARAM_SET,
    DS_PARAM_SET,
    CF_PARAM_SET,
    TIM,
    IBSS_PARAM_SET,
    COUNTRY_INFO = 7,

    CHALLENGE_TEXT = 16,


    EXTENDED_SUPPORTED_RATES = 50,
    
    VENDOR_SPECIFIC_221 = 221,
    
    WPA_IE = 221,
    WPA2_IE = 48,
    
    EXTRA_IE = 133,
} __attribute__ ((packed)) IEEEtypes_ElementId_e;


#define CAPINFO_MASK    (~( W_BIT_15 | W_BIT_14 |               \
                            W_BIT_12 | W_BIT_11 | W_BIT_9) )

typedef struct _IEEEtypes_CapInfo_t {
	u8	Ess:1;
	u8	Ibss:1;
	u8	CfPollable:1;
	u8	CfPollRqst:1;
	u8	Privacy:1;
	u8	ShortPreamble:1;
	u8	Pbcc:1;
	u8	ChanAgility:1;
	u8	SpectrumMgmt:1;
	u8	Rsrvd3:1;
	u8	ShortSlotTime:1;
	u8	Apsd:1;
	u8	Rsvrd2:1;
	u8	DSSSOFDM:1;
	u8	Rsrvd1:2;
} __attribute__ ((packed)) IEEEtypes_CapInfo_t;


/** IEEEtypes_CfParamSet_t */
typedef struct _IEEEtypes_CfParamSet_t {
	u8	ElementId;
	u8	Len;
	u8	CfpCnt;
	u8	CfpPeriod;
	u16	CfpMaxDuration;
	u16	CfpDurationRemaining;
} __attribute__ ((packed)) IEEEtypes_CfParamSet_t;

typedef struct IEEEtypes_IbssParamSet_t {
	u8	ElementId;
	u8	Len;
	u16	AtimWindow;
} __attribute__ ((packed)) IEEEtypes_IbssParamSet_t;

/** IEEEtypes_SsParamSet_t */
typedef union _IEEEtypes_SsParamSet_t {
	IEEEtypes_CfParamSet_t		CfParamSet;
	IEEEtypes_IbssParamSet_t	IbssParamSet;
} __attribute__ ((packed)) IEEEtypes_SsParamSet_t;

/** IEEEtypes_FhParamSet_t */
typedef struct _IEEEtypes_FhParamSet_t {
	u8	ElementId;
	u8	Len;
	u16	DwellTime;
	u8	HopSet;
	u8	HopPattern;
	u8	HopIndex;
} __attribute__ ((packed)) IEEEtypes_FhParamSet_t;

typedef struct _IEEEtypes_DsParamSet_t {
	u8	ElementId;
	u8	Len;
	u8	CurrentChan;
} __attribute__ ((packed)) IEEEtypes_DsParamSet_t;

/** IEEEtypes_DsParamSet_t */
typedef union IEEEtypes_PhyParamSet_t {
	IEEEtypes_FhParamSet_t	FhParamSet;
	IEEEtypes_DsParamSet_t	DsParamSet;
} __attribute__ ((packed)) IEEEtypes_PhyParamSet_t;

typedef u16 IEEEtypes_AId_t;
typedef u16 IEEEtypes_StatusCode_t;

typedef struct {
    IEEEtypes_CapInfo_t Capability;
    IEEEtypes_StatusCode_t StatusCode;
    IEEEtypes_AId_t AId;
    u8 IEBuffer[1];
} __attribute__ ((packed)) IEEEtypes_AssocRsp_t;

/** TLV  type ID definition */
#define PROPRIETARY_TLV_BASE_ID		0x0100

/* Terminating TLV Type */
#define MRVL_TERMINATE_TLV_ID		0xffff

#define TLV_TYPE_SSID				0x0000
#define TLV_TYPE_RATES				0x0001
#define TLV_TYPE_PHY_FH				0x0002
#define TLV_TYPE_PHY_DS				0x0003
#define TLV_TYPE_CF				    0x0004
#define TLV_TYPE_IBSS				0x0006

#define TLV_TYPE_DOMAIN				0x0007

#define TLV_TYPE_POWER_CAPABILITY	0x0021

#define TLV_TYPE_KEY_MATERIAL       (PROPRIETARY_TLV_BASE_ID + 0)
#define TLV_TYPE_CHANLIST           (PROPRIETARY_TLV_BASE_ID + 1)
#define TLV_TYPE_NUMPROBES          (PROPRIETARY_TLV_BASE_ID + 2)
#define TLV_TYPE_RSSI_LOW           (PROPRIETARY_TLV_BASE_ID + 4)
#define TLV_TYPE_SNR_LOW            (PROPRIETARY_TLV_BASE_ID + 5)
#define TLV_TYPE_FAILCOUNT          (PROPRIETARY_TLV_BASE_ID + 6)
#define TLV_TYPE_BCNMISS            (PROPRIETARY_TLV_BASE_ID + 7)
#define TLV_TYPE_LED_GPIO           (PROPRIETARY_TLV_BASE_ID + 8)
#define TLV_TYPE_LEDBEHAVIOR        (PROPRIETARY_TLV_BASE_ID + 9)
#define TLV_TYPE_PASSTHROUGH        (PROPRIETARY_TLV_BASE_ID + 10)
#define TLV_TYPE_REASSOCAP          (PROPRIETARY_TLV_BASE_ID + 11)
#define TLV_TYPE_POWER_TBL_2_4GHZ   (PROPRIETARY_TLV_BASE_ID + 12)
#define TLV_TYPE_POWER_TBL_5GHZ     (PROPRIETARY_TLV_BASE_ID + 13)
#define TLV_TYPE_BCASTPROBE	    (PROPRIETARY_TLV_BASE_ID + 14)
#define TLV_TYPE_NUMSSID_PROBE	    (PROPRIETARY_TLV_BASE_ID + 15)
#define TLV_TYPE_WMMQSTATUS   	    (PROPRIETARY_TLV_BASE_ID + 16)
#define TLV_TYPE_CRYPTO_DATA	    (PROPRIETARY_TLV_BASE_ID + 17)
#define TLV_TYPE_WILDCARDSSID	    (PROPRIETARY_TLV_BASE_ID + 18)
#define TLV_TYPE_TSFTIMESTAMP	    (PROPRIETARY_TLV_BASE_ID + 19)
#define TLV_TYPE_RSSI_HIGH          (PROPRIETARY_TLV_BASE_ID + 22)
#define TLV_TYPE_SNR_HIGH           (PROPRIETARY_TLV_BASE_ID + 23)

/** TLV related data structures*/
/** MrvlIEtypesHeader_t */
typedef struct _MrvlIEtypesHeader {
	u16	Type;
	u16	Len;
} __attribute__ ((packed)) MrvlIEtypesHeader_t;

/** MrvlIEtypes_Data_t */
typedef struct 	_MrvlIEtypes_Data_t {
	MrvlIEtypesHeader_t	Header;
	u8	Data[1];
} __attribute__ ((packed)) MrvlIEtypes_Data_t;

/** MrvlIEtypes_RatesParamSet_t */
typedef struct 	_MrvlIEtypes_RatesParamSet_t {
	MrvlIEtypesHeader_t	Header;
	u8	Rates[1];
} __attribute__ ((packed)) MrvlIEtypes_RatesParamSet_t;

/** MrvlIEtypes_SsIdParamSet_t */
typedef struct 	_MrvlIEtypes_SsIdParamSet_t {
	MrvlIEtypesHeader_t	Header;
	u8	SsId[1];
} __attribute__ ((packed)) MrvlIEtypes_SsIdParamSet_t;

/** MrvlIEtypes_WildCardSsIdParamSet_t */
typedef struct 	_MrvlIEtypes_WildCardSsIdParamSet_t {
	MrvlIEtypesHeader_t	Header;
	u8  MaxSsidLength;
	u8	SsId[1];
} __attribute__ ((packed)) MrvlIEtypes_WildCardSsIdParamSet_t;

/** ChanScanMode_t */
typedef struct {
	u8 PassiveScan     : 1;
	u8 DisableChanFilt : 1;
	u8 Reserved_2_7    : 6;
} __attribute__ ((packed)) ChanScanMode_t;

/** ChanScanParamSet_t */
typedef struct _ChanScanParamSet_t{
	u8	           RadioType;
	u8	           ChanNumber;
	ChanScanMode_t ChanScanMode;
	u16            MinScanTime;
	u16            MaxScanTime;
} __attribute__ ((packed)) ChanScanParamSet_t;

/** MrvlIEtypes_ChanListParamSet_t */
typedef struct 	_MrvlIEtypes_ChanListParamSet_t {
	MrvlIEtypesHeader_t	Header;
	ChanScanParamSet_t 	ChanScanParam[1];
} __attribute__ ((packed)) MrvlIEtypes_ChanListParamSet_t;

/** CfParamSet_t */
typedef struct _CfParamSet_t {
	u8	CfpCnt;
	u8	CfpPeriod;
	u16	CfpMaxDuration;
	u16	CfpDurationRemaining;
} __attribute__ ((packed)) CfParamSet_t;

/** IbssParamSet_t */
typedef struct _IbssParamSet_t {
	u16	AtimWindow;
} __attribute__ ((packed)) IbssParamSet_t;

/** MrvlIEtypes_SsParamSet_t */
typedef struct _MrvlIEtypes_SsParamSet_t {
	MrvlIEtypesHeader_t	Header;
	union {
		CfParamSet_t	CfParamSet[1];
		IbssParamSet_t	IbssParamSet[1];
	} cf_ibss;
} __attribute__ ((packed)) MrvlIEtypes_SsParamSet_t;

/** FhParamSet_t */
typedef struct _FhParamSet_t {
	u16	DwellTime;
	u8	HopSet;
	u8	HopPattern;
	u8	HopIndex;
} __attribute__ ((packed)) FhParamSet_t;

/** DsParamSet_t */
typedef struct _DsParamSet_t {
	u8	CurrentChan;
} __attribute__ ((packed)) DsParamSet_t;

/** MrvlIEtypes_PhyParamSet_t */
typedef struct _MrvlIEtypes_PhyParamSet_t {
	MrvlIEtypesHeader_t	Header;
	union {
		FhParamSet_t	FhParamSet[1];
		DsParamSet_t	DsParamSet[1];
	} fh_ds;
} __attribute__ ((packed)) MrvlIEtypes_PhyParamSet_t;


/** MrvlIEtypes_RsnParamSet_t */
typedef struct 	_MrvlIEtypes_RsnParamSet_t {
	MrvlIEtypesHeader_t	Header;
	u8	RsnIE[1];
} __attribute__ ((packed)) MrvlIEtypes_RsnParamSet_t;


typedef struct {
	MrvlIEtypesHeader_t	Header;
    u64 tsfTable[1];
} __attribute__ ((packed)) MrvlIEtypes_TsfTimestamp_t;

/**  Local Power Capability */
typedef struct _MrvlIEtypes_PowerCapability_t {
	MrvlIEtypesHeader_t	Header;
	s8 	MinPower;
	s8	MaxPower;
} __attribute__ ((packed)) MrvlIEtypes_PowerCapability_t;

/** MrvlIEtypes_RssiParamSet_t */
typedef struct _MrvlIEtypes_RssiThreshold_t {
	MrvlIEtypesHeader_t	Header;
	u8			RSSIValue;
	u8			RSSIFreq;
} __attribute__ ((packed)) MrvlIEtypes_RssiParamSet_t;

/** MrvlIEtypes_SnrThreshold_t */
typedef struct _MrvlIEtypes_SnrThreshold_t {
	MrvlIEtypesHeader_t	Header;
	u8			SNRValue;
	u8			SNRFreq;
} __attribute__ ((packed)) MrvlIEtypes_SnrThreshold_t;

/** MrvlIEtypes_FailureCount_t */
typedef struct _MrvlIEtypes_FailureCount_t {
	MrvlIEtypesHeader_t	Header;
	u8			FailValue;
	u8			FailFreq;
} __attribute__ ((packed)) MrvlIEtypes_FailureCount_t;

/** MrvlIEtypes_BeaconsMissed_t */
typedef struct _MrvlIEtypes_BeaconsMissed_t {
	MrvlIEtypesHeader_t	Header;
	u8			BeaconMissed;
	u8			Reserved;
} __attribute__ ((packed)) MrvlIEtypes_BeaconsMissed_t;

/** MrvlIEtypes_NumProbes_t */
typedef struct 	_MrvlIEtypes_NumProbes_t {
	MrvlIEtypesHeader_t	Header;
	u16 			NumProbes;
} __attribute__ ((packed)) MrvlIEtypes_NumProbes_t;

/** MrvlIEtypes_BcastProbe_t */
typedef struct 	_MrvlIEtypes_BcastProbe_t {
	MrvlIEtypesHeader_t	Header;
	u16 			BcastProbe;
} __attribute__ ((packed)) MrvlIEtypes_BcastProbe_t;

/** MrvlIEtypes_NumSSIDProbe_t */
typedef struct 	_MrvlIEtypes_NumSSIDProbe_t {
	MrvlIEtypesHeader_t	Header;
	u16 			NumSSIDProbe;
} __attribute__ ((packed)) MrvlIEtypes_NumSSIDProbe_t;

typedef struct {
  u8 Led;
  u8 Pin;
} __attribute__ ((packed)) Led_Pin;

/** MrvlIEtypes_LedGpio_t */
typedef struct 	_MrvlIEtypes_LedGpio_t {
	MrvlIEtypesHeader_t	Header;
	Led_Pin			LedPin[1];
} __attribute__ ((packed)) MrvlIEtypes_LedGpio_t;


#endif /* _WLAN_TYPES_ */

