.\" Man page generated from reStructuredText.
.
.TH "KDESTROY" "1" " " "1.13.4" "MIT Kerberos"
.SH NAME
kdestroy \- destroy Kerberos tickets
.
.nr rst2man-indent-level 0
.
.de1 rstReportMargin
\\$1 \\n[an-margin]
level \\n[rst2man-indent-level]
level margin: \\n[rst2man-indent\\n[rst2man-indent-level]]
-
\\n[rst2man-indent0]
\\n[rst2man-indent1]
\\n[rst2man-indent2]
..
.de1 INDENT
.\" .rstReportMargin pre:
. RS \\$1
. nr rst2man-indent\\n[rst2man-indent-level] \\n[an-margin]
. nr rst2man-indent-level +1
.\" .rstReportMargin post:
..
.de UNINDENT
. RE
.\" indent \\n[an-margin]
.\" old: \\n[rst2man-indent\\n[rst2man-indent-level]]
.nr rst2man-indent-level -1
.\" new: \\n[rst2man-indent\\n[rst2man-indent-level]]
.in \\n[rst2man-indent\\n[rst2man-indent-level]]u
..
.SH SYNOPSIS
.sp
\fBkdestroy\fP
[\fB\-A\fP]
[\fB\-q\fP]
[\fB\-c\fP \fIcache_name\fP]
.SH DESCRIPTION
.sp
The kdestroy utility destroys the user\(aqs active Kerberos authorization
tickets by overwriting and deleting the credentials cache that
contains them.  If the credentials cache is not specified, the default
credentials cache is destroyed.
.SH OPTIONS
.INDENT 0.0
.TP
.B \fB\-A\fP
Destroys all caches in the collection, if a cache collection is
available.
.TP
.B \fB\-q\fP
Run quietly.  Normally kdestroy beeps if it fails to destroy the
user\(aqs tickets.  The \fB\-q\fP flag suppresses this behavior.
.TP
.B \fB\-c\fP \fIcache_name\fP
Use \fIcache_name\fP as the credentials (ticket) cache name and
location; if this option is not used, the default cache name and
location are used.
.sp
The default credentials cache may vary between systems.  If the
\fBKRB5CCNAME\fP environment variable is set, its value is used to
name the default ticket cache.
.UNINDENT
.SH NOTE
.sp
Most installations recommend that you place the kdestroy command in
your .logout file, so that your tickets are destroyed automatically
when you log out.
.SH ENVIRONMENT
.sp
kdestroy uses the following environment variable:
.INDENT 0.0
.TP
.B \fBKRB5CCNAME\fP
Location of the default Kerberos 5 credentials (ticket) cache, in
the form \fItype\fP:\fIresidual\fP\&.  If no \fItype\fP prefix is present, the
\fBFILE\fP type is assumed.  The type of the default cache may
determine the availability of a cache collection; for instance, a
default cache of type \fBDIR\fP causes caches within the directory
to be present in the collection.
.UNINDENT
.SH FILES
.INDENT 0.0
.TP
.B \fB@CCNAME@\fP
Default location of Kerberos 5 credentials cache
.UNINDENT
.SH SEE ALSO
.sp
\fIkinit(1)\fP, \fIklist(1)\fP
.SH AUTHOR
MIT
.SH COPYRIGHT
1985-2016, MIT
.\" Generated by docutils manpage writer.
.
