#!/bin/awk -f
BEGIN {
    FS = " ";
    BeginProcessing = 0;
    InTable = 0;

    CoreRequest = "Core Requests";
    Error = "Errors";
    Type = "Types";
    Value = "Values";
    Request = "Requests";
    Visual = "Visuals";
    Term = "Terms";
    Event = "Events";
    EventMask = "Event Masks";

    Words[ "VideoConnectivityState" ]= Event;
    Words[ "VideoChange" ]	= Event;
    Words[ "VideoControl" ]	= Event;
    Words[ "VideoViolation" ]	= Event;
    Words[ "VideoSync" ]	= Event;
    Words[ "VideoOverride" ]	= Event;
    Words[ "VideoRequest" ]	= Event;

    Words[ "ConnectivityNotify" ]= EventMask;
    Words[ "VideoRedirect" ]	= EventMask;
    Words[ "ViolationNotify" ]	= EventMask;
    Words[ "SyncNotify" ]	= EventMask;
    Words[ "ControlNotify" ]	= EventMask;
    Words[ "ControlNotify" ]	= EventMask;
    Words[ "OverrideNotify" ]	= EventMask;

    Words[ "VideoGray" ]	= Visual;
    Words[ "VideoColor" ]	= Visual;

    Words[ "atoms" ]		= Term;
    Words[ "Atoms" ]		= Term;
    Words[ "atom" ]		= Term;
    Words[ "Atom" ]		= Term;
    Words[ "device" ]		= Term;
    Words[ "Device" ]		= Term;
    Words[ "VIR" ]		= Term;
    Words[ "VOR" ]		= Term;
    Words[ "VW" ]		= Term;

    Words[ "CreateWindow" ]	= CoreRequest;
    Words[ "CopyArea" ]		= CoreRequest;
    Words[ "CopyPlane" ]	= CoreRequest;
    Words[ "GetImage" ]		= CoreRequest;
    Words[ "PutImage" ]		= CoreRequest;
    Words[ "MapWindow" ]	= CoreRequest;
    Words[ "UnmapWindow" ]	= CoreRequest;
    Words[ "MapSubwindows" ]	= CoreRequest;
    Words[ "UnmapSubwindows" ]	= CoreRequest;
    Words[ "ConfigureWindow" ]	= CoreRequest;
    Words[ "CirculateWindow" ]	= CoreRequest;
    Words[ "DestroyWindow" ]	= CoreRequest;
    Words[ "DestroySubwindow" ]	= CoreRequest;
    Words[ "ReparentWindow" ]	= CoreRequest;

    Words[ "Access" ]		= Error;
    Words[ "Alloc" ]		= Error;
    Words[ "Atom" ]		= Error;
    Words[ "Colormap" ]		= Error;
    Words[ "Drawable" ]		= Error;
    Words[ "GContext" ]		= Error;
    Words[ "IDChoice" ]		= Error;
    Words[ "Length" ]		= Error;
    Words[ "Match" ]		= Error;
    Words[ "Pixmap" ]		= Error;
    Words[ "Window" ]		= Error;
    Words[ "Video" ]		= Error;
    Words[ "Value" ]		= Error;

    Words[ "Acquired" ]		= Value;
    Words[ "Always" ]		= Value;
    Words[ "Capture" ]		= Value;
    Words[ "Clip" ]		= Value;
    Words[ "ClipByChildren" ]	= Value;
    Words[ "Composite" ]	= Value;
    Words[ "Connected" ]	= Value;
    Words[ "Denied" ]		= Value;
    Words[ "Fail" ]		= Value;
    Words[ "Geometric" ]	= Value;
    Words[ "IncludeInferiors" ]	= Value;
    Words[ "InverseGeometric" ]	= Value;
    Words[ "InverseLinear" ]	= Value;
    Words[ "Linear" ]		= Value;
    Words[ "Lost" ]		= Value;
    Words[ "Matrix0" ]		= Value;
    Words[ "NExclusive" ]	= Value;
    Words[ "NotConnected" ]	= Value;
    Words[ "Offline" ]		= Value;
    Words[ "Online" ]		= Value;
    Words[ "Overlap" ]		= Value;
    Words[ "Placement" ]	= Value;
    Words[ "PseudoColor" ]	= Value;
    Words[ "Render" ]		= Value;
    Words[ "Scale" ]		= Value;
    Words[ "Subset" ]		= Value;
    Words[ "Success" ]		= Value;
    Words[ "TrueColor" ]	= Value;

    Words[ "QueryVideo" ]	= Request;
    Words[ "CreateVideo" ]	= Request;
    Words[ "RenderVideo" ]	= Request;
    Words[ "CaptureGraphics" ]	= Request;
    Words[ "StopVideo" ]	= Request;
    Words[ "QueryVideoControls" ]= Request;
    Words[ "ChangeVideoControls" ]= Request;
    Words[ "ChangeConnectivity" ]= Request;
    Words[ "ChangeOwnership" ]	= Request;
    Words[ "SelectVideoEvents" ]= Request;

    Words[ "VIDEOIN" ]		= Type;
    Words[ "VIDEOOUT" ]		= Type;
    Words[ "VIDEODEVICE" ]	= Type;
    Words[ "VIDEOIO" ]		= Type;
    Words[ "VIDEOID" ]		= Type;
    Words[ "VREFERENCE" ]	= Type;
    Words[ "CONNECTION" ]	= Type;
    Words[ "CONTROL" ]		= Type;
    Words[ "SETTING" ]		= Type;
    Words[ "FRACTION" ]		= Type;
    Words[ "FRACTIONRANGE" ]	= Type;
    Words[ "RECTANGLERANGE" ]	= Type;
    Words[ "PLACEMENT" ]	= Type;
    Words[ "VIDEOGEOMETRY" ]	= Type;
    Words[ "RENDERMODEL" ]	= Type;
    Words[ "OWNER" ]		= Type;
}
/^\.NH/ { BeginProcessing = 1; }
BeginProcessing == 0 && /^.*$/	{ print $0; }
BeginProcessing == 1 && /^\.TS/ { InTable = 1; }
BeginProcessing == 1 && /^\.TE/ { InTable = 0; }
BeginProcessing == 1 && /^\./   { print $0; }
BeginProcessing == 1 && /^$/	{ printf("\n"); }
InTable == 1 && BeginProcessing == 1 && /^[^\.]/ { print $0; }
InTable == 0 && BeginProcessing == 1 && /^[^\.]/ \
{
    between = " ";
    brokenLine = 1;
    for (field=1; field<=NF; field++) {
	if (field == NF)
	    between = "";
	special = "";
	if ($field ~ /^[^a-zA-Z0-9][^a-zA-Z0-9]*$/) {
	    printf("%s%s", $field, between);
	    if (field == NF)
		printf("\n");
	    brokenLine = 0;
	    continue;
	}
	if ($field !~ /^[a-zA-Z0-9][a-zA-Z0-9]*$/) {
	    len = length($field);
	    if ($field ~ /^[^a-zA-Z0-9]/) {
		for (j=1; j<=len; j++) {
		    prefix = substr($field, j, 1);
		    if (prefix ~ /^[a-zA-Z0-9]$/) {
			prefix = substr($field, 1, j-1);
			break;
		    }
		}
	    } else
		prefix = "";
	    if ($field ~ /[^a-zA-Z0-9]$/) {
		for (j=len; j>=1; j--) {
		    suffix = substr($field, j, 1);
		    if (suffix ~ /^[a-zA-Z0-9]$/) {
			suffix = substr($field, j+1, len-j);
			break;
		    }
		}
	    } else
		suffix = "";
	    if (length(prefix) + length(suffix) >= len) {
		printf("%s%s", $field, between);
		if (field == NF)
		    printf("\n");
		brokenLine = 0;
		continue;
	    }
	    word = substr($field, length(prefix)+1, \
			  len - length(suffix) - length(prefix));
	} else {
	    suffix = "";
	    prefix = "";
	    word = $field;
	}
	type = Words[ word ];
	if (type != "") {
	    if (type != Term && type != Type) {
		if (brokenLine == 0)
		    printf("\n");
		if (prefix != "")
		    printf(".Pn %s %s %s\n", prefix, word, suffix);
		else
		    printf(".PN %s %s %s\n", prefix, word, suffix);
	    } else
		printf("%s\n", $field);
	    printf(".IN \"%s\" \"%s\" \"\"\n", type, word);
	    brokenLine = 1;
	} else {
	    printf("%s%s", $field, between);
	    if (field == NF)
		printf("\n");
	    brokenLine = 0;
	}
    }
}
