/************************************************************
Copyright 1989,1990 by Tektronix Inc.
Copyright 1989,1990 by The Massachusetts Institute of Technology

                    All Rights Reserved

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the names of MIT and Tektronix not be 
used in advertising or publicity pertaining to distribution of the
software without specific prior written permission.
M.I.T. and Tektronix make no representation about the 
suitability of this software for any purpose. It is provided 
"as is" without any express or implied warranty.

MIT AND TEKTRONIX DISCLAIM ALL WARRANTIES WITH REGARD TO  THIS  
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY 
AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL MIT OR
TEKTRONIX BE LIABLE FOR  ANY SPECIAL, INDIRECT OR CONSEQUENTIAL 
DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
DATA  OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION  WITH
THE USE OR PERFORMANCE OF THIS SOFTWARE.

********************************************************/

/* $Header: VEX.h,v 1.13 90/04/13 15:21:03 toddb Exp $ */

#ifndef _VEX_H_
#define _VEX_H_

/*
 * Protocol requests constants and alignment values
 */

#define VEX_NAME "VEX"

#define VEX_MAJOR_VERSION	1	/* current version numbers */
#define VEX_MINOR_VERSION	0

/*
 * Resources
 */
typedef XID VideoIn;
typedef XID VideoOut;
typedef XID VideoDevice;
typedef XID VideoIO;
typedef XID VideoID;
typedef XID VideoReference;

/*
 * RANGE types
 */
#define VEXGeometricRange		0
#define VEXLinearRange			1

/*
 * Connectivity values
 */
#define	VEXNotConnected			0
#define	VEXConnected			255

/*
 * StopVideo Actions
 */
#define VEXStopRenderVideo			(1 << 0)
#define VEXStopCaptureVideo			(1 << 1)

/*
 * VEXRequest Requests
 */
#define VEXRender				0
#define VEXCapture				1


/*
 * VEXControl event states
 */
#define VEXControlSuccess		0
#define VEXControlFail			1
#define VEXControlDenied		2

/*
 * VEXViolation actionMask values
 */
#define VEXScale			(1L << 0)
#define VEXPlacement			(1L << 1)
#define VEXClip				(1L << 2)
#define VEXOverlap			(1L << 3)
/*
 * VEXViolation event states
 */
#define VEXViolationSuccess		0
#define VEXViolationFail		1
#define VEXViolationSubset		2

/*
 * VEXSync event states
 */
#define VEXSyncAcquired			0
#define VEXSyncLost			1

/*
 * VEXChange event states
 */
#define VEXOffline				0
#define VEXOnline				1

/*
 * VEX event masks
 */
#define VEXRedirectMask			(1L << 0)
#define VEXConnectivityMask		(1L << 1)
#define VEXSyncMask			(1L << 2)
#define VEXControlMask			(1L << 3)
#define VEXOverrideMask			(1L << 4)
#define VEXViolationMask		(1L << 5)

/*
 * Video events
 */
#define VEXControl			0
#define VEXViolation			1
#define VEXSync				2
#define VEXOverride			3
#define VEXChange			4
#define VEXConnectivity			5
#define VEXRequest			6
#define VEXRequestAddendum		7

/*
 * VEX visual classes.
 */
#define VEXVideoColor			6
#define VEXVideoGray			8

#define BadVideo			0


#endif /* _VEX_H_ */
