/************************************************************
Copyright 1989,1990 by Tektronix Inc.
Copyright 1989,1990 by The Massachusetts Institute of Technology

                    All Rights Reserved

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the names of MIT and Tektronix not be 
used in advertising or publicity pertaining to distribution of the
software without specific prior written permission.
M.I.T. and Tektronix make no representation about the 
suitability of this software for any purpose. It is provided 
"as is" without any express or implied warranty.

MIT AND TEKTRONIX DISCLAIM ALL WARRANTIES WITH REGARD TO  THIS  
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY 
AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL MIT OR
TEKTRONIX BE LIABLE FOR  ANY SPECIAL, INDIRECT OR CONSEQUENTIAL 
DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
DATA  OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION  WITH
THE USE OR PERFORMANCE OF THIS SOFTWARE.

********************************************************/

/* $Header: VEXlib.h,v 1.22 90/04/19 16:50:24 toddb Exp $ */

#ifndef _VEXLIB_H_
#define _VEXLIB_H_

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/VEX/VEX.h>


/*
 * New types for video extension client library
 */

/*
 * Base QueryVideo types
 */
typedef struct {
	long	numerator;
	long	denominator;
} XVEXFraction;

typedef struct {
	long	num_base;
	long	num_increment;
	long	num_limit;
	int	num_type;	/* VEXGeometricRange or VEXLinearRange */
	long	denom_base;
	long	denom_increment;
	long	denom_limit;
	int	denom_type;	/* VEXGeometricRange or VEXLinearRange */
} XVEXFractionRange;

typedef struct {
	Atom		name;			/* Control name */
	int		setting_format;		/* 8, 16, or 32 */
	int		description_format;	/* 8, 16, or 32 */
	unsigned long 	setting_length;		/* setting length (bytes) */
	unsigned long 	description_length;	/* description length (bytes) */
	union {					/* description data */
	    char *p8list;
	    short *p16list;
	    long *p32list;
	} value
} XVEXControl;

typedef struct {
	Atom		name;		/* Control name */
	VideoID		id;
	int		format;		/* 8, 16, or 32 */
	unsigned long	length;		/* setting length (bytes) */
	union {				/* setting  data */
	    char *p8list;
	    short *p16list;
	    long *p32list;
	} value
} XVEXSetting;

typedef struct {
	XRectangle	base;
	XRectangle	limit;
	int		x_inc;
	int		y_inc;
	int		width_inc;
	int		height_inc;
	int		type;	/* VEXGeometricRange or VEXLinearRange */
} XVEXRectangleRange;

typedef struct {
	XVEXFraction	frame_rate;	/* max nominal rate (frames/sec) */
	XVEXRectangleRange	src;	/* set of possible source rectangles */
	XVEXRectangleRange	dest;	/* set of possible dest rectangles */
	XVEXFractionRange	x_scale; /* set of dst/src width ratios */
	XVEXFractionRange	y_scale; /* set of dst/src height ratios */
	Bool		identity_aspect; /* true if x and y scale must be = */
} XVEXPlacement;

typedef struct {
	XVEXFraction	frame_rate;	/* frames/sec in signal format */
	XVEXFraction	field_rate;	/* fields/sec in signal format */
	int		width;		/* signal width (in pixels) */
	int		height;		/* signal height (in pixels) */
	int		concurrent_use;	/* max simultaneous use */
	int		nplacement;	/* number of placements */
	XVEXPlacement	*placement;	/* placement list */
} XVEXGeometry;

typedef struct {
	VideoID		src;
	VideoID		dst;
	long		matrix1;
	long		matrix2;
} XVEXTransition;

typedef struct {
	Window		window;	/* identifies client requesting ownership */
	VideoID		vid;	/* resource to be owned */
} XVEXOwner;

/*
 * Aggregate QueryVideo types
 */
typedef struct {
    Bool composite;		/* True if RenderVideo will modify pixels or
				 * if CaptureGraphics will blend video and
				 * graphics */	
    Bool opaque;		/* True if pixels cannot be interpreted
				 * by a Core type */
    VisualID visualid;		/* video window visual ID */
} XVEXWindowModel;

typedef struct {
    int depth;			/* pixmap depth */
    VisualID visualid;		/* visual ID to use for a colormap in
				 * CaptureGraphics */
    unsigned long red_mask;
    unsigned long green_mask;
    unsigned long blue_mask;
} XVEXPixmapModel;

typedef struct {
    int nwindow_models;
    XVEXWindowModel *window_models;
    int npixmap_models;
    XVEXPixmapModel *pixmap_models;
} XVEXModelInfo;

typedef struct {
    VideoReference id;			/* VideoIn reference ID */
    int ndevice_controls;
    XVEXControl *device_controls;
    XVEXGeometry geometry;
    XVEXModelInfo model_info;
    XRectangle clip_size;
} XVEXVin;

typedef struct {
    VideoReference id;			/* VideoOut reference ID */
    int ndevice_controls;
    XVEXControl *device_controls;
    XVEXGeometry geometry;
    XVEXModelInfo model_info;
} XVEXVout;

typedef struct {
    VideoDevice id;			/* VideoDevice id */
    int ndevice_controls;
    XVEXControl *device_controls;
} XVEXVdev;

typedef struct {
        unsigned char row;	/* connectivity for devices or videoIns in the
				 * row */
        unsigned char col;	/* connectivity for devices or videoOuts in the
				 * col */
} XVEXConnectCell;

typedef struct {
        XVEXConnectCell **matrix        /* Matrix representing a possible set
                                         * of connections among video inputs,
                                         * outputs and devices */
} XVEXConnectMatrix;

typedef struct {
	int nrow;		/* number of Rows in connection matrix */
	int ncol;		/* number of Columns in connection matrix */
	XID *row;		/* ID's labelling the rows of the matrix */
	XID *col;		/* ID's labelling the columns of the matrix */
} XVEXConnectLabel;


/*
 * New events for video extension client library
 * A "XEvent" structure always  has type as the first entry.  This
 * uniquely identifies what  kind of event it is.  The second entry
 * is always a pointer to the display the event was read from.
 * The third entry is always a window of one type or another,
 */

typedef struct {
	int type;		/* of event */
	unsigned long serial;	/* # of last request processed by server */
	Bool send_event;	/* true if this came from a SendEvent request */
	Display *display;	/* Display the event was read from */
	Window	window;		/* unused */
	VideoID	vid;		/* from Setting given to ChangeVideoControls */
	Atom	name;		/* from Setting given to ChangeVideoControls */
	Time	time;		/* current server time */
	int	state;		/* Success, Fail */
} XVEXControlEvent;

typedef struct {
	int type;		/* of event */
	unsigned long serial;	/* # of last request processed by server */
	Bool send_event;	/* true if this came from a SendEvent request */
	Display *display;	/* Display the event was read from */
	Drawable drawable;	/* window on which EXPOSURE was selected */
	VideoIO	vid;
	Time	time;		/* current server time */
	unsigned long	action_mask;  /* Scale, Placement, Clip, Overlap */
	int	state;		/* Success, Fail, Subset */
} XVEXViolationEvent;

typedef struct {
	int type;		/* of event */
	unsigned long serial;	/* # of last request processed by server */
	Bool send_event;	/* true if this came from a SendEvent request */
	Display *display;	/* Display the event was read from */
	Drawable drawable;	/* window on which EXPOSURE was selected */
	VideoIO	vid;		/* vid on which Render/Capture was requested */
	Time	time;		/* current server time */
	int	state;		/* Acquired or Lost */
} XVEXSyncEvent;

typedef struct {
	int type;		/* of event */
	unsigned long serial;	/* # of last request processed by server */
	Bool send_event;	/* true if this came from a SendEvent request */
	Display *display;	/* Display the event was read from */
	Drawable drawable;	/* drawable on which EXPOSURE was selected */
	VideoIO	vid;		/* vid on which Render/Capture was requested */
	Time	time;		/* current server time */
} XVEXOverrideEvent;

typedef struct {
	int type;		/* of event */
	unsigned long serial;	/* # of last request processed by server */
	Bool send_event;	/* true if this came from a SendEvent request */
	Display *display;	/* Display the event was read from */
	Window	window;		/* unused */
	int screen;
	VideoDevice vdev;	/* vdev which changed state */
	Time	time;		/* current server time */
	int	state;		/* Online or Offline */
} XVEXChangeEvent;

typedef struct {
	int type;		/* of event */
	unsigned long serial;	/* # of last request processed by server */
	Bool send_event;	/* true if this came from a SendEvent request */
	Display *display;	/* Display the event was read from */
	Window	window;		/* unused */
	int screen;
	unsigned long new_state;/* index into list of adjacency Matrices */
	Time	time;		/* of last successful ChangeVideoConnectivity */
} XVEXConnectivityEvent;

typedef struct {
	int type;		/* of event */
	unsigned long serial;	/* # of last request processed by server */
	Bool send_event;	/* true if this came from a SendEvent request */
	Display *display;	/* Display the event was read from */
	Window	window;		/* unused */
	XID src;
	XID dst;
	XID cmap;
	int src_x;
	int src_y;
	int dst_x;
	int dst_y;
	int src_width;
	int src_height;
	int dst_width;
	int dst_height;
	Bool	redirect;
	Bool	full_motion;
	int	request;	/* VEXRender or VEXCapture */
	int	priority;
	int	subwindow_mode;
	Time	time;		/* current server time */
} XVEXRequestEvent;

/*
 * VEX function declarations.
 */
extern XVEXSetting *XVEXCreateSettingList();
extern Status XVEXQueryVideo();
extern XVEXSetting *XVEXQueryControls();
extern Bool XVideoQueryExtension ();

extern XVisualInfo *XVEXGetVisualInfo();
extern XVEXVin *XVEXGetVins();
extern XVEXVout *XVEXGetVouts();
extern XVEXVdev *XVEXGetVdevs();
extern Status XVEXOverlapsOfScreen();
extern Status XVEXTimestamps();
extern XVEXConnectLabel *XVEXGetConnectLabel();
extern unsigned char **XVEXGetConnectState();


#endif /* _VEXLIB_H_ */
