/************************************************************
Copyright 1989 by Tektronix Inc.
Copyright 1989 by The Massachusetts Institute of Technology

                    All Rights Reserved

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the names of MIT and Tektronix not be 
used in advertising or publicity pertaining to distribution of the
software without specific prior written permission.
M.I.T. and Tektronix make no representation about the 
suitability of this software for any purpose. It is provided 
"as is" without any express or implied warranty.

MIT AND TEKTRONIX DISCLAIM ALL WARRANTIES WITH REGARD TO  THIS  
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY 
AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL MIT OR
TEKTRONIX BE LIABLE FOR  ANY SPECIAL, INDIRECT OR CONSEQUENTIAL 
DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
DATA  OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION  WITH
THE USE OR PERFORMANCE OF THIS SOFTWARE.

********************************************************/

/* $Header: VEXproto.h,v 1.20 90/04/19 14:35:30 toddb Exp $ */

#ifndef _VEXPROTO_H_
#define _VEXPROTO_H_

#include "X11/Xmd.h"
#include "X11/Xprotostr.h"

/*
 * Video requests and replies
 */
typedef struct _QueryVideo {
	CARD8	reqType;		/* always VideoReqCode */
	CARD8	videoReqType;		/* always X_QueryVideo */
	CARD16	length B16;
	CARD32	window B32;
} xQueryVideoReq;
#define sz_xQueryVideoReq	8

typedef struct {
	BYTE	type;			/* X_Reply */
	CARD8	unused;			/* not used */
	CARD16	sequenceNumber B16;
	CARD32	length B32;
	CARD8	screen;
	CARD8	inputOverlap;
	CARD8	captureOverlap;
	CARD8	ioOverlap;
	CARD32	time B32;
	CARD8	nDepths;
	CARD8	nAllowedDepths;
	CARD8	nVin;
	CARD8	nVout;
	CARD8	nVdev;
	CARD8	pad1;
	CARD16	pad2;
	CARD32	nDeviceControls B32;
	CARD32	nAdjacencyMatrices B32;
	CARD32	nTransitions B32;
} xQueryVideoReply;
#define sz_xQueryVideoReply	36


typedef struct _ChangeConnectivity {
	CARD8	reqType;		/* always VideoReqCode */
	CARD8	videoReqType;		/* always X_ChangeConnectivity */
	CARD16	length B16;
	CARD8	screen;
	CARD8	pad1;
	CARD16	pad2;
	CARD32	time B32;
	CARD32	matrix1 B32;
	CARD32	matrix2 B32;
} xChangeConnectivityReq;
#define sz_xChangeConnectivityReq	 20

typedef struct _RenderVideo {
	CARD8	reqType;		/* always VideoReqCode */
	CARD8	videoReqType;		/* always X_RenderVideo */
	CARD16	length B16;
	CARD32	src B32;
	CARD32	dest B32;
	INT16	srcX B16;
	INT16	srcY B16;
	INT16	dstX B16;
	INT16	dstY B16;
	CARD16	srcWidth B16;
	CARD16	srcHeight B16;
	CARD16	dstWidth B16;
	CARD16	dstHeight B16;
	CARD8	fullMotion;
	CARD8	priority;
	CARD8	subWindowMode;
	CARD8	pad1;
} xRenderVideoReq;
#define sz_xRenderVideoReq	32

typedef struct _CaptureGraphics {
	CARD8	reqType;		/* always VideoReqCode */
	CARD8	videoReqType;		/* always X_CaptureGraphics */
	CARD16	length B16;
	CARD32	src B32;
	CARD32	dest B32;
	CARD32	cmap B32;
	INT16	srcX B16;
	INT16	srcY B16;
	INT16	dstX B16;
	INT16	dstY B16;
	CARD16	srcWidth B16;
	CARD16	srcHeight B16;
	CARD16	dstWidth B16;
	CARD16	dstHeight B16;
	CARD8	fullMotion;
	CARD8	priority;
	CARD8	subWindowMode;
	CARD8	pad1;
} xCaptureGraphicsReq;
#define sz_xCaptureGraphicsReq	36

typedef struct _StopVideo {
	CARD8	reqType;		/* always VideoReqCode */
	CARD8	videoReqType;		/* always X_StopVideo */
	CARD16	length B16;
	CARD8	action;
	CARD8	junk1;		/* not used */
	CARD16	junk2 B16;	/* not used */
} xStopVideoReq;
#define sz_xStopVideoReq	8

typedef struct _QueryVideoControls {
	CARD8	reqType;		/* always VideoReqCode */
	CARD8	videoReqType;		/* always X_QueryVideoControls */
	CARD16	length B16;
	CARD32	vid B32;
} xQueryVideoControlsReq;
#define sz_xQueryVideoControlsReq	8

typedef struct {
	BYTE	type;			/* X_Reply */
	CARD8	unused;			/* not used */
	CARD16	sequenceNumber B16;
	CARD32	length B32;
	CARD32	nSettings B32;
	CARD32	pad1 B32;
	CARD32	pad2 B32;
	CARD32	pad3 B32;
	CARD32	pad4 B32;
	CARD32	pad5 B32;
} xQueryVideoControlsReply;
#define sz_xQueryVideoControlsReply	32

typedef struct _ChangeVideoControls {
	CARD8	reqType;		/* always VideoReqCode */
	CARD8	videoReqType;		/* always X_ChangeVideoControls */
	CARD16	length B16;
	CARD32	nSettings B32;
} xChangeVideoControlsReq;
#define sz_xChangeVideoControlsReq	8


typedef struct _CreateVideo {
	CARD8	reqType;		/* always VideoReqCode */
	CARD8	videoReqType;		/* always X_CreateVideo */
	CARD16	length B16;
	CARD32	id B32;
	CARD32	reference B32;
} xCreateVideoReq;
#define sz_xCreateVideoReq	 12

typedef struct _ChangeOwnership {
	CARD8	reqType;		/* always VideoReqCode */
	CARD8	videoReqType;		/* always X_ChangeOwnership */
	CARD16	length B16;
} xChangeOwnershipReq;
#define sz_xChangeOwnershipReq	 4

typedef struct _SelectVideoEvents {
	CARD8	reqType;		/* always VideoReqCode */
	CARD8	videoReqType;		/* always X_SelectVideoEvents */
	CARD16	length B16;
	CARD32	id B32;
	CARD32	mask B32;
} xSelectVideoEventsReq;
#define sz_xSelectVideoEventsReq	 12


/*
 * Video events
 */
typedef struct _VideoControl {
	BYTE	type;			/* always eventBase + VideoControl */
	CARD8	unused;			/* not used */
	CARD16	sequenceNumber B16;
	CARD32	vid B32;
	CARD32	name B32;
	CARD32	time B32;		/* server time */
	BYTE	state;			/* Success, Fail */
	CARD8	pad1;
	CARD16	pad2 B16;
	CARD32	pad3 B32;
	CARD32	pad4 B32;
	CARD32	pad5 B32;
} xVideoControlEvent;
#define sz_xVideoControlEvent	32

typedef struct _VideoViolation {
	BYTE	type;			/* always eventBase + VideoViolation */
	CARD8	unused;			/* not used */
	CARD16	sequenceNumber B16;
	CARD32	id B32;
	CARD32	vid B32;
	CARD32	time B32;		/* server time */
	CARD16	actionMask B16;		/* Scale, Placement, Clip, Overlap */
	BYTE	state;			/* Success, Fail, Subset */
	CARD8	pad1;
	CARD32	pad2 B32;
	CARD32	pad3 B32;
	CARD32	pad4 B32;
} xVideoViolationEvent;
#define sz_xVideoViolationEvent	32

typedef struct _VideoSync {
	BYTE	type;			/* always eventBase + VideoSync */
	CARD8	unused;			/* not used */
	CARD16	sequenceNumber B16;
	CARD32	id B32;
	CARD32	vid B32;
	CARD32	time B32;		/* server time */
	BYTE	state;			/* Acquired or Lost */
	CARD8	pad1;
	CARD16	pad2 B16;
	CARD32	pad3 B32;
	CARD32	pad4 B32;
	CARD32	pad5 B32;
} xVideoSyncEvent;
#define sz_xVideoSyncEvent	32

typedef struct _VideoOverride {
	BYTE	type;			/* always eventBase + VideoOverride */
	CARD8	unused;			/* not used */
	CARD16	sequenceNumber B16;
	CARD32	id B32;
	CARD32	vid B32;
	CARD32	time B32;		/* server time */
	CARD32	pad1 B32;
	CARD32	pad2 B32;
	CARD32	pad3 B32;
	CARD32	pad4 B32;
} xVideoOverrideEvent;
#define sz_xVideoOverrideEvent	32

typedef struct _VideoChange {
	BYTE	type;			/* always eventBase + VideoChange */
	CARD8	unused;			/* not used */
	CARD16	sequenceNumber B16;
	CARD32	screen B32;
	CARD32	vdev B32;
	CARD32	time B32;		/* server time */
	BYTE	state;			/* Online or Offline */
	CARD8	pad1;
	CARD16	pad2 B16;
	CARD32	pad3 B32;
	CARD32	pad4 B32;
	CARD32	pad5 B32;
} xVideoChangeEvent;
#define sz_xVideoChangeEvent	32

typedef struct _VideoConnectivityState {
	BYTE	type;		 /* always eventBase + VideoConnectivityState */
	CARD8	unused;			/* not used */
	CARD16	sequenceNumber B16;
	CARD32	screen B32;
	CARD32	newState B32;
	CARD32	time B32;		/* server time */
	CARD32	pad1 B32;
	CARD32	pad2 B32;
	CARD32	pad3 B32;
	CARD32	pad4 B32;
} xVideoConnectivityStateEvent;
#define sz_xVideoConnectivityStateEvent	32

typedef struct _VideoRequest {
	BYTE	type;			/* always eventBase + VideoRequest */
	CARD8	unused;
	CARD16	sequenceNumber B16;
	CARD32	src B32;
	CARD32	dst B32;
	CARD32	cmap B32;
	INT16	srcx B16;
	INT16	srcy B16;
	INT16	dstx B16;
	INT16	dsty B16;
	CARD16	srcWidth B16;
	CARD16	srcHeight B16;
	CARD16	dstWidth B16;
	CARD16	dstHeight B16;
} xVideoRequestEvent;
#define sz_xVideoRequestEvent	32

typedef struct _VideoRequestAddendum {
	BYTE	type;		/* always eventBase + VideoRequestAddendum */
	CARD8   unused;
	CARD16	sequenceNumber B16;
	CARD32	time B32;
	BYTE	request;		/* Render or Capture */
	BYTE	redirect;
	BYTE	fullMotion;
	BYTE	priority;
	BYTE	subwindowMode;
	CARD8	pad1;
	CARD8	pad2;
	CARD8	pad3;
	CARD32	pad4 B32;
	CARD32	pad5 B32;
	CARD32	pad6 B32;
	CARD32	pad7 B32;
} xVideoRequestAddendumEvent;
#define sz_xVideoRequestAddendumEvent	32

/*
 * Video protocol data structures
 */
typedef struct {
	INT32	numerator B32;
	INT32	denominator B32;
} xFraction;
#define sz_xFraction 8

typedef struct {
	INT32		numBase B32;
	INT32		numIncrement B32;
	INT32		numLimit B32;
	INT32		denomBase B32;
	INT32		denomIncrement B32;
	INT32		denomLimit B32;
	CARD8		numType;
	CARD8		denomType;
	CARD16 		pad1;
} xFractionRange;
#define sz_xFractionRange 28

typedef struct {
	CARD32		name B32;
	CARD32		id B32;
	CARD8		type;
	CARD8		settingFormat;
	CARD8		descriptionFormat;
	CARD8 		pad1;
	CARD32 		settingLength B32;
	CARD32 		descriptionLength B32;
} xControl;
#define sz_xControl 20

typedef struct {
	CARD32		name B32;
	CARD32		id B32;
	CARD8		format;		/* 8, 16, or 32 */
	CARD8 		pad1;
	CARD16 		pad2;
	CARD32 		length B32;	/* in bytes of setting value data */
} xSetting;
#define sz_xSetting 16

typedef struct {
	xRectangle	base;
	xRectangle	limit;
	INT16		xInc B16;
	INT16		yInc B16;
	CARD16		widthInc B16;
	CARD16		heightInc B16;
	CARD8		type;
	CARD8		pad1;
	CARD16 		pad2;
} xRectangleRange;
#define sz_xRectangleRange 28

typedef struct {
	xFraction	frameRate;
	xRectangleRange	src;
	xRectangleRange	dest;
	xFractionRange	xScale;
	xFractionRange	yScale;
	BOOL		identityAspect;
	CARD8		pad1;
	CARD16		pad2;
} xPlacement;
#define sz_xPlacement 124

typedef struct {
	xFraction	frameRate;
	xFraction	fieldRate;
	CARD16		width B16;
	CARD16		height B16;
	CARD16		concurrentUse B16;
	CARD16		pad1;
	CARD32		referenceId B32;
	CARD32		nPlacement B32;
} xVideoGeometry;
#define sz_xVideoGeometry 32

typedef struct {
	CARD8		depth;
	CARD8 		opaque;
	CARD16 		pad2;
	CARD32		visualid B32;
	CARD32		redMask B32;
	CARD32		greenMask B32;
	CARD32		blueMask B32;
} xRenderModel;
#define sz_xRenderModel 20

typedef struct {
	CARD32	window;
	CARD32	vid;
} xOwner;
#define sz_xOwner	8


typedef struct {
	CARD32		src B32;
	CARD32		dst B32;
	CARD32		matrix1 B32;
	CARD32		matrix2 B32;
} xVideoTransition;
#define sz_xVideoTransition 16

/*
 * Video Requests
 */
#define X_CaptureGraphics		0
#define X_ChangeConnectivity		1
#define X_ChangeOwnership		2
#define X_ChangeVideoControls		3
#define X_CreateVideo			4
#define X_QueryVideo			5
#define X_QueryVideoControls		6
#define X_RenderVideo			7
#define X_SelectVideoEvents		8
#define X_StopVideo			9

#endif /* _VEXPROTO_H_ */
