/* $Header: XVEXChOwn.c,v 1.3 90/04/10 13:29:47 scotthe Exp $ */
/************************************************************
Copyright 1989,1990 by Tektronix Inc.
Copyright 1989,1990 by The Massachusetts Institute of Technology

                    All Rights Reserved

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the names of MIT and Tektronix not be
used in advertising or publicity pertaining to distribution
of the software without specific prior written permission.
M.I.T. and Tektronix make no representation about the 
suitability of this software for any purpose. It is provided 
"as is" without any express or implied warranty.

MIT AND TEKTRONIX DISCLAIM ALL WARRANTIES WITH REGARD TO  THIS  
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY 
AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL MIT OR
TEKTRONIX BE LIABLE FOR  ANY SPECIAL, INDIRECT OR CONSEQUENTIAL 
DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
DATA  OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION  WITH
THE USE OR PERFORMANCE OF THIS SOFTWARE.

********************************************************/

#include "Xlibint.h"
#include "VEXlibint.h"
#include "Xutil.h"
#include "VEXlib.h"
#include "VEXproto.h"


XVEXChangeOwnership(dpy, owners, nowners)
    Display *dpy;
    XVEXOwner owners[];
    unsigned long nowners;
{
    register xChangeOwnershipReq	*req;
    XExtCodes			*codes;
    int				nbytes, len;
    int				n;

    if (!(codes = _VEXCheckExtension (dpy)))
	return;
    LockDisplay (dpy);
    while (nowners > 0) {
	GetReq (ChangeOwnership, req);
	req->reqType = codes->major_opcode;
	req->videoReqType = X_ChangeOwnership;

	nbytes = nowners * sizeof(XVEXOwner);
	len = nbytes >> 2;
	if (req->length + len > dpy->max_request_size) {
	    n = (dpy->max_request_size - req->length) / sizeof(XVEXOwner);
	    nbytes = n * sizeof(XVEXOwner);
	    len = nbytes >> 2;
	}
	else
	    n = nowners;
	req->length += len;

	/*
	 * owner consists of 2 CARD32's
	 */
	Data32 (dpy, owners, nbytes);

	nowners -= n;
	owners += n;
    }

    UnlockDisplay (dpy);
    SyncHandle ();
}
