/* $Header: XVEXQuCont.c,v 1.4 90/04/19 11:53:31 scotthe Exp $ */
/************************************************************
Copyright 1989,1990 by Tektronix Inc.
Copyright 1989,1990 by The Massachusetts Institute of Technology

                    All Rights Reserved

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the names of MIT and Tektronix not be
used in advertising or publicity pertaining to distribution
of the software without specific prior written permission.
M.I.T. and Tektronix make no representation about the 
suitability of this software for any purpose. It is provided 
"as is" without any express or implied warranty.

MIT AND TEKTRONIX DISCLAIM ALL WARRANTIES WITH REGARD TO  THIS  
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY 
AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL MIT OR
TEKTRONIX BE LIABLE FOR  ANY SPECIAL, INDIRECT OR CONSEQUENTIAL 
DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
DATA  OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION  WITH
THE USE OR PERFORMANCE OF THIS SOFTWARE.

********************************************************/

#define NEED_REPLIES
#include "Xlibint.h"
#include "VEXlibint.h"
#include "Xutil.h"
#include "VEXlib.h"
#include "VEXproto.h"

/* XXX
 * Should check for dpy->max_request_size
 */
XVEXSetting *XVEXQueryControls(dpy, vid, controls, ncontrols, nsettings_return)
    Display *dpy;
    VideoID vid;
    Atom controls[];
    unsigned long ncontrols;
    unsigned long *nsettings_return;
{
    register xQueryVideoControlsReq *req;
    XExtCodes			    *codes;
    xQueryVideoControlsReply	    rep;
    int				    nbytes;
    char			    *settings_data_cur;
    int				    bytesSettingsData;
    int				    bytesSettingsHeaders;
    XVEXSetting 			    *settings_return;
    XVEXSetting 			    *settings_cur;
    int				    j;
    union {
	xSetting *sp;
	char *charp;
    } u;
    char *pReplyData;

    if (!(codes = _VEXCheckExtension (dpy)))
	return (XVEXSetting *) None;
    LockDisplay (dpy);
    GetReq (QueryVideoControls, req);
    req->reqType = codes->major_opcode;
    req->videoReqType = X_QueryVideoControls;
    req->vid = vid;
    req->length += ncontrols;

    nbytes = ncontrols * 4;
    /* use _XSend instead of Data, since subsequent _XReply will flush buffer */
    _XSend (dpy, controls, nbytes);

    if (!_XReply (dpy, (xReply *) &rep, 0, xFalse)) {
	UnlockDisplay (dpy);
	SyncHandle ();
	return (XVEXSetting *) None;
    }

    /* 
     * XXX
     * This implementation works only if sizeof(short) == CARD16 and
     * sizeof(long) == CARD32
     */
    *nsettings_return = rep.nSettings;
    bytesSettingsHeaders = rep.nSettings * SIZEOF(xSetting);
    bytesSettingsData = 
	    ((rep.length << 2) - (SIZEOF(xQueryVideoControlsReply) - 32))
	    - bytesSettingsHeaders;
    settings_cur = settings_return = (XVEXSetting *)
	    Xmalloc(rep.nSettings * sizeof(XVEXSetting) + bytesSettingsData);
    settings_data_cur = (char *)(settings_return + rep.nSettings);
    pReplyData = u.charp = Xmalloc(bytesSettingsHeaders + bytesSettingsData);
    _XRead (dpy, (char *) u.sp, bytesSettingsHeaders + bytesSettingsData);

    for (j = 0; j < rep.nSettings; j++) {
	XVEXSetting *sp = &settings_return[j];
	sp->name = u.sp->name;
	sp->id = u.sp->id;
	sp->format = u.sp->format;
	sp->length = u.sp->length;
	u.sp = (xSetting *) (((char *) u.sp) + sz_xSetting);
	switch (sp->format) {
	    case 16:
		settings_cur->value.p16list = (short *) settings_data_cur;
		break;
	    case 32:
		settings_cur->value.p32list = (long *) settings_data_cur;
		break;
	    default:
		settings_cur->value.p8list = settings_data_cur;
		break;
	}
	bcopy(u.charp, settings_data_cur, sp->length);
	settings_data_cur += (sp->length + 3) & ~0x3;
	u.charp += (sp->length + 3) & ~0x3;
    }
    Xfree((char *)pReplyData);

    UnlockDisplay (dpy);
    SyncHandle ();

    return settings_return;
}
