/* $Header: XVEXQuVid.c,v 1.8 90/04/19 16:52:56 toddb Exp $ */
/************************************************************
Copyright 1989,1990 by Tektronix Inc.
Copyright 1989,1990 by The Massachusetts Institute of Technology

                    All Rights Reserved

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the names of MIT and Tektronix not be
used in advertising or publicity pertaining to distribution
of the software without specific prior written permission.
M.I.T. and Tektronix make no representation about the 
suitability of this software for any purpose. It is provided 
"as is" without any express or implied warranty.

MIT AND TEKTRONIX DISCLAIM ALL WARRANTIES WITH REGARD TO  THIS  
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY 
AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL MIT OR
TEKTRONIX BE LIABLE FOR  ANY SPECIAL, INDIRECT OR CONSEQUENTIAL 
DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
DATA  OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION  WITH
THE USE OR PERFORMANCE OF THIS SOFTWARE.

********************************************************/

#define NEED_REPLIES
#include "Xlibint.h"
#include "VEXlibint.h"
#include "Xutil.h"
#include "VEXlib.h"
#include "VEXcommon.h"
#include "VEXproto.h"

Status XVEXQueryVideo(dpy, screen_number)
    Display *dpy;
    int screen_number;
{
    XExtCodes	*codes;
    XEDataObject object;
    XExtData **pScreenXExtData;
    XExtData *videoXExtData;
    unsigned long videoConnectivityTime;
    unsigned long queryVideoTime;

    if (!(codes = _VEXCheckExtension (dpy)))
	return 0;

    object.screen = ScreenOfDisplay(dpy, screen_number);
    pScreenXExtData = XEHeadOfExtensionList(object);
    videoXExtData = XFindOnExtensionList(pScreenXExtData, codes->extension);
    videoConnectivityTime = 
	    ((VideoInfo *)videoXExtData->private_data)->video_connect_time;
    _VEXFreeVideoInfo((VideoInfo *)videoXExtData->private_data);
    (void) _VEXQueryVideo(dpy, RootWindow(dpy, screen_number),
	    (VideoInfo **)&videoXExtData->private_data, codes);
    /*
     * If saved videoConnectivityTime is more recent than queryVideoTime,
     * set videoConnectivityTime in VideoInfo structure to the saved time.
     * Otherwise set videoConnectivityTime to queryVideoTime.
     */
    if (videoXExtData->private_data) {
	queryVideoTime = 
		((VideoInfo *)videoXExtData->private_data)->query_video_time;
	if (    ((videoConnectivityTime > queryVideoTime) &&
		    (videoConnectivityTime - queryVideoTime) < 
		    (unsigned long)(1 << 31)) ||
		((videoConnectivityTime < queryVideoTime) &&
		    (queryVideoTime - videoConnectivityTime) < 
		    (unsigned long)(1 << 31))) {
	    ((VideoInfo *)videoXExtData->private_data)->video_connect_time =
		    videoConnectivityTime;
	} else
	    ((VideoInfo *)videoXExtData->private_data)->video_connect_time =
		   ((VideoInfo *)videoXExtData->private_data)->query_video_time;
    }

    return 1;
}

#define CARD32		unsigned long
#define sz_CARD32	4
Status _VEXQueryVideo(dpy, w, vinfo, codes)
    Display *dpy;
    Window w;
    VideoInfo **vinfo;
    XExtCodes   *codes;
{
    register xQueryVideoReq *req;
    xQueryVideoReply	    rep;
    char *pReplyData;
    int i,j,k;
    int dataLength;
    VideoInfo *pVideoInfo;
    int nattrList;
    int nbytesAdjMat;
    int nbytesAdjMats;
    int nbytesAdjPtrs;
    int nbytesConnMat;
    int nbytes;
    unsigned char *adjMats;
    int             nvio;
    int             ndevice_controls;
    int             nallowed_depths;
    xRenderModel     *allowed_depths;
    int nwindowModels;
    int npixmapModels;
    XVEXWindowModel *windowModels;
    XVEXPixmapModel *pixmapModels;
    unsigned char model_mask;
    XVEXModelInfo *ioModel;
    int nvid;
    VideoID vid;
    int *nctrl;
    XVEXControl **ctrl, *ctrlp;
    int type;
    xControl *protocolp;
    union {
	    xDepth *dp;
	    xVisualType *vp;
	    xRenderModel *rmp;
	    xVideoGeometry *vgp;
	    xPlacement *pp;
	    CARD32 *card32p;
	    unsigned char *iomdl;
	    xControl *ctrlp;
	    xRectangle *rectp;
	    char *adjp;
	    xVideoTransition *transp;
    } u;

    *vinfo = (VideoInfo *) NULL;

    LockDisplay (dpy);
    GetReq (QueryVideo, req);
    req->reqType = codes->major_opcode;
    req->videoReqType = X_QueryVideo;
    req->window = w;

    if (!_XReply (dpy, (xReply *) &rep, (SIZEOF(xQueryVideoReply) - 32) >> 2,
	    xFalse)) {
	UnlockDisplay (dpy);
	SyncHandle ();
	return 0;
    }

    /*
     * Create a VideoInfo struct and fill in the "non-pointer" values
     */
    pVideoInfo = (VideoInfo *) Xmalloc(sizeof(VideoInfo));
    if (!pVideoInfo)
	return 1;
    pVideoInfo->screen = rep.screen;
    pVideoInfo->input_overlap = rep.inputOverlap;
    pVideoInfo->capture_overlap = rep.captureOverlap;
    pVideoInfo->io_overlap = rep.ioOverlap;
    pVideoInfo->query_video_time = rep.time;
    pVideoInfo->ndepths = rep.nDepths;
    pVideoInfo->nvin = rep.nVin;
    pVideoInfo->nvout = rep.nVout;
    pVideoInfo->nvdev = rep.nVdev;
    pVideoInfo->nadjacency_matrices = rep.nAdjacencyMatrices;
    pVideoInfo->ntransitions = rep.nTransitions;

    nallowed_depths = rep.nAllowedDepths;
    ndevice_controls = rep.nDeviceControls;

    /*
     * Read all of the lists of data from the connection into the "u" structure
     * XXX Maybe if the reply is HUGE, this isn't such a good idea -- we should
     * just read one list at a time.
     */
    dataLength = (rep.length << 2) - (SIZEOF(xQueryVideoReply) - 32);
    u.dp = (xDepth *)  Xmalloc ((unsigned) dataLength);
    pReplyData = (char *)u.dp;
    _XRead (dpy, (char *)u.dp, dataLength);

    /*
     * Read in Depth structures
     */
    pVideoInfo->depths = (Depth *)Xmalloc(pVideoInfo->ndepths*sizeof(Depth));
    for (j = 0; j < pVideoInfo->ndepths; j++) {
	Depth *dp = &pVideoInfo->depths[j];
	dp->depth = u.dp->depth;
	dp->nvisuals = u.dp->nVisuals;
	u.dp = (xDepth *) (((char *) u.dp) + sz_xDepth);
	if (dp->nvisuals > 0) {
	    dp->visuals = 
	      (Visual *)Xmalloc((unsigned)dp->nvisuals*sizeof(Visual));
	    for (k = 0; k < dp->nvisuals; k++) {
		register Visual *vp = &dp->visuals[k];
		vp->visualid = u.vp->visualID;
		vp->class	= u.vp->class;
		vp->bits_per_rgb= u.vp->bitsPerRGB;
		vp->map_entries	= u.vp->colormapEntries;
		vp->red_mask	= u.vp->redMask;
		vp->green_mask	= u.vp->greenMask;
		vp->blue_mask	= u.vp->blueMask;
		vp->ext_data	= NULL;
		u.vp = (xVisualType *) (((char *) u.vp) +
					sz_xVisualType);
	    }
	} else {
	    dp->visuals = (Visual *) NULL;
	}
    }
    /*
     * "Remember" allowedDepths
     */
    allowed_depths = u.rmp;
    u.rmp = (xRenderModel *) 
	    (((char *) u.rmp) + nallowed_depths*sz_xRenderModel);
    
    pVideoInfo->vin = (XVEXVin *)
	    Xmalloc(pVideoInfo->nvin*sizeof(XVEXVin));
    pVideoInfo->vout = (XVEXVout *)
	    Xmalloc(pVideoInfo->nvout*sizeof(XVEXVout));
    /*
     * Read in VideoDevice's
     */
    pVideoInfo->vdev = (XVEXVdev *)
	    Xmalloc(pVideoInfo->nvdev*sizeof(XVEXVdev));
    for (j = 0; j < pVideoInfo->nvdev; j++) {
	pVideoInfo->vdev[j].id = *u.card32p;
	u.card32p = (CARD32 *) (((char *) u.card32p) + sz_CARD32);
    }
    /*
     * Read in Input Attribute and Output Attribute structures
     */
    for (i=0; i<2; i++) {
	if (i==0)
	    nattrList = pVideoInfo->nvin;
	else
	    nattrList = pVideoInfo->nvout;
	for (j = 0; j < nattrList; j++) {
	    XVEXGeometry *vgp;
	    if (i==0) {
		vgp = &pVideoInfo->vin[j].geometry;
		pVideoInfo->vin[j].id = u.vgp->referenceId;
	     } else {
		vgp = &pVideoInfo->vout[j].geometry;
		pVideoInfo->vout[j].id = u.vgp->referenceId;
	    }
	    vgp->frame_rate.numerator = u.vgp->frameRate.numerator;
	    vgp->frame_rate.denominator = u.vgp->frameRate.denominator;
	    vgp->field_rate.numerator = u.vgp->fieldRate.numerator;
	    vgp->field_rate.denominator = u.vgp->fieldRate.denominator;
	    vgp->width = u.vgp->width;
	    vgp->height = u.vgp->height;
	    vgp->concurrent_use = u.vgp->concurrentUse;
	    vgp->nplacement = u.vgp->nPlacement;
	    u.vgp = (xVideoGeometry *) (((char *) u.vgp) + sz_xVideoGeometry);
	    if (vgp->nplacement > 0) {
		vgp->placement = (XVEXPlacement *)
			Xmalloc((unsigned)vgp->nplacement*sizeof(XVEXPlacement));
		for (k = 0; k < vgp->nplacement; k++) {
		    /* XXX
		     * On machines where xPlacement == XPlacement,
		     * we could just do a bcopy here.
		     */
		    copyPlacement(&vgp->placement[k], u.pp);
		    u.pp = (xPlacement *) (((char *) u.pp) + sz_xPlacement);
		}
	    } else {
		vgp->placement = (XVEXPlacement *) NULL;
	    }
	}
    }
    /*
     * Read in VideoInputModels
     * Read in VideoOutputModels
     */
    for (i = 0; i < 2; i++) {
	if (i == 0)
	    nvio = pVideoInfo->nvin;
	else
	    nvio = pVideoInfo->nvout;
	for (j = 0; j < nvio; j++) {
	    nwindowModels = 0;
	    npixmapModels = 0;
	    windowModels = (XVEXWindowModel *) NULL;
	    pixmapModels = (XVEXPixmapModel *) NULL;
	    for (k = 0; k < nallowed_depths; k++) {
		model_mask = *u.iomdl++;
		if (model_mask & PixmapModel) {
		    npixmapModels++;
		    if (pixmapModels)
			pixmapModels = (XVEXPixmapModel *) 
			    Xrealloc(pixmapModels,
			    sizeof(XVEXPixmapModel) * npixmapModels);
		    else
			pixmapModels = (XVEXPixmapModel *)
			    Xmalloc(sizeof(XVEXPixmapModel));
		    pixmapModels[npixmapModels-1].depth = 
			allowed_depths[k].depth;
		    pixmapModels[npixmapModels-1].visualid = 
			allowed_depths[k].visualid;
		    pixmapModels[npixmapModels-1].red_mask = 
			allowed_depths[k].redMask;
		    pixmapModels[npixmapModels-1].green_mask = 
			allowed_depths[k].greenMask;
		    pixmapModels[npixmapModels-1].blue_mask = 
			allowed_depths[k].blueMask;
		}
		if (model_mask & WindowModel) {
		    nwindowModels++;
		    if (windowModels)
			windowModels = (XVEXWindowModel *) 
			    Xrealloc(windowModels, 
			    sizeof(XVEXWindowModel) * nwindowModels);
		    else
			windowModels = (XVEXWindowModel *)
			    Xmalloc(sizeof(XVEXWindowModel));
		    windowModels[nwindowModels-1].visualid = 
			allowed_depths[k].visualid;
		    windowModels[nwindowModels-1].opaque = 
			allowed_depths[k].opaque;
		    if (model_mask & CompositeModel)
			windowModels[nwindowModels-1].composite = True;
		    else
			windowModels[nwindowModels-1].composite = False;
		}
	    }
	    if (i==0)
		ioModel = &pVideoInfo->vin[j].model_info;
	    else
		ioModel = &pVideoInfo->vout[j].model_info;
	    ioModel->nwindow_models = nwindowModels;
	    ioModel->npixmap_models = npixmapModels;
	    ioModel->window_models = windowModels;
	    ioModel->pixmap_models = pixmapModels;
	}
	nbytes = nallowed_depths * nvio;
	u.iomdl += ((nbytes + 3) & ~0x3) - nbytes;
    }

    /*
     * Read in Device Controls
     */
    for (i = 0; i < 3; i++) {
	switch (i) {
	    case 0:
		nvid = pVideoInfo->nvin;
		type = Input; 
		break;
	    case 1:
		nvid = pVideoInfo->nvout;
		type = Output; 
		break;
	    case 2:
		nvid = pVideoInfo->nvdev;
		type = Device; 
		break;
	};
	for (j = 0; j < nvid; j++) {
	    switch (i) {
		case 0:
		    vid = j;
		    nctrl = &pVideoInfo->vin[j].ndevice_controls;
		    ctrl = &pVideoInfo->vin[j].device_controls;
		    break;
		case 1:
		    vid = j;
		    nctrl = &pVideoInfo->vout[j].ndevice_controls;
		    ctrl = &pVideoInfo->vout[j].device_controls;
		    break;
		case 2:
		    vid = pVideoInfo->vdev[j].id;
		    nctrl = &pVideoInfo->vdev[j].ndevice_controls;
		    ctrl = &pVideoInfo->vdev[j].device_controls;
		    break;
	    };
	    /*
	     * Find out how many controls there are for this vid
	     * and allocate space for control array.
	     */
	    *nctrl = 0;
	    protocolp = u.ctrlp;
	    for (k = 0; k < ndevice_controls; k++) {
		if (vid == protocolp->id && type == protocolp->type) {
		    (*nctrl)++;
		}
		protocolp = (xControl *) (((char *) protocolp) 
			+ sz_xControl + ((protocolp->descriptionLength +3) & ~0x3));
	    }
	    if (*nctrl) {
		ctrlp = *ctrl = (XVEXControl *) Xmalloc(*nctrl * sizeof(XVEXControl));
	    } else {
		*ctrl = (XVEXControl *) NULL;
		continue;
	    }
	    /*
	     * Fill in control array.
	     */
	    protocolp = u.ctrlp;
	    for (k = 0; k < ndevice_controls; k++) {
		if (vid == protocolp->id && type == protocolp->type) {
		    ctrlp->name = protocolp->name;
		    ctrlp->setting_format = protocolp->settingFormat;
		    ctrlp->setting_length = protocolp->settingLength;
		    ctrlp->description_format = protocolp->descriptionFormat;
		    ctrlp->description_length = protocolp->descriptionLength;
		    protocolp = (xControl *) 
			    (((char *) protocolp) + sz_xControl);
		    if (ctrlp->description_length) {
			ctrlp->value.p8list = 
				(char *)Xmalloc(ctrlp->description_length);
			bcopy((char *)protocolp, ctrlp->value.p8list,
				ctrlp->description_length);
			protocolp = (xControl *) (((char *) protocolp)
				+ ((ctrlp->description_length+3) & ~0x3));
		    }
		    else
			ctrlp->value.p8list = (char *) NULL;
		    ctrlp++;
		}
	    }
	}
    }
    for (k = 0; k < ndevice_controls; k++) {
	u.ctrlp = (xControl *) (((char *) u.ctrlp) 
		+ sz_xControl + ((u.ctrlp->descriptionLength + 3) & ~0x3));
    }
    /*
     * Read in clip-size Rectangle list
     */
    for (j = 0; j < pVideoInfo->nvin; j++) {
	XRectangle *rectp = &pVideoInfo->vin[j].clip_size;
	rectp->x = u.rectp->x;
	rectp->y = u.rectp->y;
	rectp->width = u.rectp->width;
	rectp->height = u.rectp->height;
	u.rectp = (xRectangle *) (((char *) u.rectp) + sz_xRectangle);
    }
    /*
     * Read in Adjacency matrix
     */
    if (pVideoInfo->nadjacency_matrices) {
	nbytesAdjMat = 2 * (pVideoInfo->nvdev + pVideoInfo->nvin) * 
		(pVideoInfo->nvdev + pVideoInfo->nvout);
	nbytesAdjMats =  pVideoInfo->nadjacency_matrices * nbytesAdjMat;
	nbytesAdjPtrs = (sizeof (char **)) * pVideoInfo->nadjacency_matrices;
	pVideoInfo->adj_matrix = (unsigned char **) Xmalloc(nbytesAdjPtrs);
	adjMats = (unsigned char *) Xmalloc(nbytesAdjMats);
	pVideoInfo->nadj_mat_col = pVideoInfo->nvdev + pVideoInfo->nvout;
	bcopy(u.adjp, adjMats, nbytesAdjMats);
	for (i=0; i< pVideoInfo->nadjacency_matrices; i++) {
	    pVideoInfo->adj_matrix[i] = adjMats;
	    adjMats += nbytesAdjMat;
	}
	u.adjp += (nbytesAdjMats + 3) & ~0x3;
	/*
	 * The protocol says the current state is matrix0, with all
	 * NExclusive values set to VEXNotConnected.
	 */
	nbytesConnMat = nbytesAdjMat / 2;
	pVideoInfo->cur_state.index = 0;
	pVideoInfo->cur_state.matrix = (char *)Xmalloc(nbytesConnMat);
	for (i=0, j=0; i < nbytesConnMat; i++, j+=2) {
	    if (pVideoInfo->adj_matrix[0][j] == VEXConnected)
		pVideoInfo->cur_state.matrix[i] = VEXConnected;
	    else
		pVideoInfo->cur_state.matrix[i] = VEXNotConnected;
	}
    }
    /*
     * Read in transitions
     */
    if (pVideoInfo->ntransitions) {
	pVideoInfo->transitions = (XVEXTransition *)
		Xmalloc(pVideoInfo->ntransitions*sizeof(XVEXTransition));
	for (j = 0; j < pVideoInfo->ntransitions; j++) {
	    XVEXTransition *transp = &pVideoInfo->transitions[j];
	    transp->src = u.transp->src;
	    transp->dst = u.transp->dst;
	    transp->matrix1 = u.transp->matrix1;
	    transp->matrix2 = u.transp->matrix2;
	    u.transp = (xVideoTransition *) 
		    (((char *) u.transp) + sz_xVideoTransition);
	}
    }

    *vinfo = pVideoInfo;
    Xfree((char *)pReplyData);
    UnlockDisplay (dpy);
    SyncHandle ();

    return 1;
}
#undef CARD32
#undef sz_CARD32

static copyPlacement(clientPlacement, protocolPlacement)
    XVEXPlacement *clientPlacement;
    xPlacement *protocolPlacement;
{
    clientPlacement->frame_rate.numerator = 
	    protocolPlacement->frameRate.numerator;
    clientPlacement->frame_rate.denominator = 
	    protocolPlacement->frameRate.denominator;
    copyRectangleRange(&clientPlacement->src, &protocolPlacement->src);
    copyRectangleRange(&clientPlacement->dest, &protocolPlacement->dest);
    /* XXX
     * On machines where xFractionRange == XFractionRange,
     * we could just do a bcopy here.
     */
    copyFractionRange(&clientPlacement->x_scale, &protocolPlacement->xScale);
    copyFractionRange(&clientPlacement->y_scale, &protocolPlacement->yScale);
    clientPlacement->identity_aspect = protocolPlacement->identityAspect;
}

static copyRectangleRange(clientRectRange, protocolRectRange)
    XVEXRectangleRange *clientRectRange;
    xRectangleRange *protocolRectRange;
{
    clientRectRange->base.x = protocolRectRange->base.x;
    clientRectRange->base.y = protocolRectRange->base.y;
    clientRectRange->base.width = protocolRectRange->base.width;
    clientRectRange->base.height = protocolRectRange->base.height;
    clientRectRange->limit.x = protocolRectRange->limit.x;
    clientRectRange->limit.y = protocolRectRange->limit.y;
    clientRectRange->limit.width = protocolRectRange->limit.width;
    clientRectRange->limit.height = protocolRectRange->limit.height;
    clientRectRange->x_inc = protocolRectRange->xInc;
    clientRectRange->y_inc = protocolRectRange->yInc;
    clientRectRange->width_inc = protocolRectRange->widthInc;
    clientRectRange->height_inc = protocolRectRange->heightInc;
    clientRectRange->type = protocolRectRange->type;
}

static copyFractionRange(clientFracRange, protocolFracRange)
    XVEXFractionRange *clientFracRange;
    xFractionRange *protocolFracRange;
{
    clientFracRange->num_base = protocolFracRange->numBase;
    clientFracRange->num_increment= protocolFracRange->numIncrement;
    clientFracRange->num_limit = protocolFracRange->numLimit;
    clientFracRange->num_type = protocolFracRange->numType;
    clientFracRange->denom_base = protocolFracRange->denomBase;
    clientFracRange->denom_increment= protocolFracRange->denomIncrement;
    clientFracRange->denom_limit = protocolFracRange->denomLimit;
    clientFracRange->denom_type = protocolFracRange->denomType;
}
