
/* rpd_driver.h */

/* RMS: this supercedes the 'tdriv.h' file */

#ifndef RPD_DRIVER_H
#define RPD_DRIVER_H

typedef int (*METHOD)();

typedef struct 
{
	int		fd;		/* the file for talking */
#ifdef GALATEA
	Server          *serv;          /* for netrpd's */
#endif /* GALATEA */
	char		port[16];	/* tty_port name - for debugging */
	char		model[32];	/* manufacturer's name */
	char		devname[32];	/* logical name */
	char		volume[128];	/* what's currently mounted */
	int             volnum;         /* this to use for netrpd's */
	int             speed;          /* to cache this info */
	int             frame;          /* negative means invalid frame */
	struct
	{
		unsigned	audio1_on :	1;
		unsigned	audio2_on :	1;
		unsigned	indexon :	1;
		unsigned	volume_loaded : 1;
		unsigned	not_responding: 1;	/* gets set after no response to reset */
	}		state;

	METHOD		reset;		/* no args */
	METHOD		cmd;		/* 1 arg; see below */
	METHOD		search;		/* ( frame, wait ) */
	METHOD		segplay;	/* ( fr1, fr2, , speed, wait ) */
	METHOD		getframe;	/* no args */
	METHOD		varspeed;	/* 1 arg; see below */
	METHOD		jog;		/* jog( 1 arg; +- n frames ); */
	METHOD		record;		/* (disabled) */

} RPD, *RPD_ptr;

#ifdef GALATEA_XXX
RPD_ptr	rpdutil_open();
RPD_ptr	rpdutil_close();
#endif /* GALATEA_XXX */

/* standard defined speeds */

#define R_MAX		-300		/* maximum possible velocity */
#define R_VERY_FAST	-150		/* really moving along */
#define R_FAST		-90		/* 3-5 times normal; still visible */
#define R_PLAY		-30		/* reverse normal */
#define R_SLOW		-10		/* 1/2 to 1/5 normal */
#define R_VERY_SLOW	-3		/* just barely moving */
#define STOP		0		/* transport halted */
#define F_VERY_SLOW     3		/* just barely moving */
#define F_SLOW		10		/* 1/2 to 1/5 normal */
#define F_PLAY		30		/* forward normal */
#define F_FAST		90		/* 3-5 times normal; still visible */
#define F_VERY_FAST	150		/* really moving along */
#define F_MAX		300		/* maximum possible velocity */

/* Standard defined errors */
#define NO_ERROR              999999
#define LOWEST_ERROR         1000000  /* use this for < LOWEST_ERROR */
#define VOLUME_LIST_OLD      1000000  /* something has changed */
#define BAD_VOLUME            1000001  /* not a real volume */
#define FUNC_NOT_SUPPORTED    1000002  /* volume doesn't support func */
#define BAD_COMMAND           1000003  /* unknown command */
#define COULDNT_SEARCH        1000004  /* fault in RPD search */
#define COULDNT_STOP          1000005  /* couldn't stop RPD */
#define COULDNT_CHANGE_SPEED  1000006  /* couldn't change RPD speed */
#define COULDNT_DO_FUNC       1000007  /* fault while trying func */
#define BAD_ARGUMENT          1000008  /* an argument was faulty */
#define GIO_ERROR             1000010  /* a write to a server failed */
#define TIME_OVERLAP          1000011  /* reserve time overlaps another */
#define VOLUME_RESERVED       1000012  /* volume is currently reserved */
#define RESERVE_TOO_LONG      1000013  /* reservation too long */
#define SEGMENT_TOO_LONG      1000014  /*PlaySeg request would block too long*/
#define PERMISSION_DENIED     1000015  /* unpermitted command */

#ifdef GALATEA_XXX
/* standard defined cmds */

#define INDEX_ON		0
#define INDEX_OFF		1
#define A1_ON			2
#define A1_OFF			3
#define A2_ON			4
#define A2_OFF			5
#define LOAD			6
#define UNLOAD			7
#define EJECT                   8
#define INDEX_TOGGLE            9
#endif /* GALATEA_XXX */

/* stuff for player caching -- hal */
#define rpd_getspeed(rpd) (rpd->speed)
#define rpd_getframe(rpd) (rpd->frame)
#define rpd_setspeed(rpd,spd) (rpd->speed = spd)
#define rpd_setframe(rpd,frm) (rpd->frame = frm)

/*
 * rpd functions for pioneer
 */
extern int	pioneer_reset();		/* no args */
extern int	pioneer_cmd();		/* 1 arg; see below */
extern int	pioneer_search();		/* ( frame, wait ) */
extern int	pioneer_segplay();	/* ( fr1, fr2, , speed, wait ) */
extern int	pioneer_getframe();	/* no args */
extern int	pioneer_varspeed();	/* 1 arg; see below */
extern int	pioneer_jog();		/* jog( 1 arg; +- n frames ); */

#endif
