/* $Header: plxvideo.c,v 2.7 90/04/20 16:18:08 toddb Exp $ */
/*
 *   Copyright (c) 1989, 90 by Tektronix, inc.
 *   Copyright (c) 1987, 88 by
 *   PARALLAX GRAPHICS, INCORPORATED, Santa Clara, California.
 *   All rights reserved
 *
 *   This software is furnished on an as-is basis, and may be used and copied
 *   only with the inclusion of the above copyright notice.
 *
 *   The information in this software is subject to change without notice.
 *   No committment is made as to the usability or reliability of this
 *   software.
 *
 *   Parallax Graphics, Inc.
 *   2500 Condensa Street
 *   Santa Clara, California  95051
 */

#ifndef lint
static char *sid_ = "@(#)plxVideo.c    1.17 09/01/88 Parallax Graphics Inc";
#endif

#include "Xplx.h"
#include "VEX.h"
#include "VEXproto.h"
#include "videostr.h"

#if defined(sun) || defined(is68k) || defined(motorola131) || defined(hpux)
#define WE_HAVE_VME_BUS
#include    "plxvme.h"
#endif

/*
 * This routine should implement the protocol semantics for StopVideo.
 * Namely, if the drawable is of a core visual type, then leave the
 * last frame in the drawable.  If the visual class is VideoGray or
 * VideoColor, the result is undefined, but either the picture ought
 * to stay on the screen or it should be completely removed and an
 * area filled with a solid color take its place.  The former is preferred.
 */
void
plxStopVideo(vp, pDrawable, action)
    VideoScreenPtr	vp;
    DrawablePtr pDrawable;
    int action;			/* Render/Capture bits */
{
    plxPrivScrPtr sp = plxGetScreenPriv(pDrawable->pScreen);
    VideoDrawPtr vDraw;

    ifdebug(15) printf("plxVideoStop()\n");

    if (action & VEXStopRenderVideo) {
	if (pDrawable == sp->fullMotionVideo) {
	    if ((vDraw = GetVideoDrawable(vp, pDrawable)) == NULL)
		FatalError("plxStopVideo: drawable lost\n");
	    p_floff();
	    sp->fullMotionVideo = (DrawablePtr)NULL;
	    vDraw->renderActive = NoVideo;
	}
    }
    if (action & VEXStopCaptureVideo) {
#ifdef XXX
Do we need something like this for capturegraphics??
	if (pDrawable == sp->fullMotionCapture) {
#endif XXX
	    if ((vDraw = GetVideoDrawable(vp, pDrawable)) == NULL)
		FatalError("plxStopVideo: drawable lost\n");
	    if (vDraw->captureActive) {
		dviStopVideo(pDrawable, vDraw->videoOut);
		vDraw->captureActive = NoVideo;
	    }
	}
}

/*
 * remove the GC references and clip it for real
 */
plxVideoClipDownload(pScreen, pRegionClip, pRect)
    ScreenPtr pScreen;
    RegionPtr pRegionClip;
    BoxPtr pRect;
{
    register RegionPtr pRegion1, pRegion2;
    register BoxPtr pbox;
    int rval, nbox, tmp;

#ifdef needed
    register MapPrivPtr mp;

    mp = (MapPrivPtr)(pWindow->devPrivates[plxWindowPrivateIndex].ptr);
#endif

    ifdebug(15) printf("plxVClipDownload() r=%d,%d,%d,%d\n",
            pRect->x1,
            pRect->y1,
            pRect->x2,
            pRect->y2);

    pRegion1 = (* pScreen->RegionCreate)(NULL, REGION_NUM_RECTS(pRegionClip));
    (* pScreen->RegionCopy)(pRegion1, pRegionClip);
    pRegion2 = (* pScreen->RegionCreate)(pRect, 1);
    (* pScreen->Intersect)(pRegion2, pRegion1, pRegion2);
    /* region2 contains the area to be "painted" */
    (* pScreen->RegionCopy)(pRegion1, pRegion2);

    pbox = REGION_RECTS(pRegion2);
    nbox = REGION_NUM_RECTS(pRegion2);

    while (--nbox >= 0) {
        pbox->x1 = ROUNDUP16(pbox->x1);
        if (!ISROUND16(pbox->x2 - 1 + 1)) {
            pbox->x2 = ROUNDDN16(pbox->x2);
        }
        if (pbox->x1 > pbox->x2)
            pbox->x1 = pbox->x2;        /* XXX */
        ifdebug(15) printf("\t x1,y1,x2,y2=%d,%d,%d,%d\n",
                pbox->x1, pbox->y1,
                pbox->x2, pbox->y2);
        pbox++;
    }
    /* region2 now follows the parallax rules */

    (* pScreen->Subtract)(pRegion1, pRegion1, pRegion2);
    /* region1 now contains the parts that are not to be painted */

#ifdef notdef
    tmp = mp->video;
    mp->video = VIDEO_NO;
    (*pScreen->PaintWindowBackground)(pWindow, pRegion1, PW_BACKGROUND);
    mp->video = tmp;
#endif

    plxClipInvalidate(pScreen);
    rval = plxClipDownLoad(pScreen, pRegion2, 0, 0);

    (* pScreen->RegionDestroy)(pRegion1);
    (* pScreen->RegionDestroy)(pRegion2);

    return (rval);
}

void
plxVideoReshape(pWin, dx, dy)
WindowPtr pWin;
int    dx, dy;
{
    plxPrivScrPtr sp = plxGetScreenPriv(pWin->drawable.pScreen);
    WindowPtr  vWin = (WindowPtr)sp->fullMotionVideo;

    if (vWin != pWin)
        return;

    p_floff();
    sp->fullMotionVideo = (DrawablePtr) NULL;

    plxClipInvalidate(((DrawablePtr)pWin)->pScreen);

    /*
     * only do this if the window hasn't been moved --
     * when it's moved, plxCopyWindow will deal with
     * the problem there
     */
    if (dx == 0 && dy == 0) {
        /*
         * this will force the client to start the video again
          */
        (*pWin->drawable.pScreen->ClearToBackground) (pWin, 0, 0, 0, 0,
						      TRUE);
    }
}
