/* $Header: render.c,v 1.15 90/04/19 11:56:13 scotthe Exp $ */
/************************************************************
Copyright 1989 by Tektronix Inc.
Copyright 1989 by The Massachusetts Institute of Technology

                    All Rights Reserved

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the names of MIT and Tektronix not be
used in advertising or publicity pertaining to distribution 
of the software without specific prior written permission.
M.I.T. and Tektronix make no representation about the 
suitability of this software for any purpose. It is provided 
"as is" without any express or implied warranty.

MIT AND TEKTRONIX DISCLAIM ALL WARRANTIES WITH REGARD TO  THIS  
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY 
AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL MIT OR
TEKTRONIX BE LIABLE FOR  ANY SPECIAL, INDIRECT OR CONSEQUENTIAL 
DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
DATA  OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION  WITH
THE USE OR PERFORMANCE OF THIS SOFTWARE.

********************************************************/

#define NEED_REPLIES
#define NEED_EVENTS
#include <stdio.h>
#include "X.h"
#include "Xproto.h"
#include "misc.h"
#include "os.h"
#include "windowstr.h"
#include "colormapst.h"
#include "scrnintstr.h"
#include "pixmapstr.h"
#include "extnsionst.h"
#include "gcstruct.h"
#include "dixstruct.h"
#include "resource.h"
#include "opaque.h"
#include "regionstr.h"

#include "VEX.h"
#include "VEXproto.h"
#include "VEXcommon.h"
#include "videostr.h"

#ifdef VIDEO_DBG

#define VIDEO_DBG_RETURN(rtval) \
    {\
    fprintf(FpVideoErrFile, "Returning %d\n", rtval); \
    fflush(FpVideoErrFile); \
    return (rtval); \
    }

#else

#define VIDEO_DBG_RETURN(rtval) \
    return (rtval);

#endif

#define USE_SATURATED(vRes) \
    (vRes->useCount > vRes->maxUse - 1)

static DrawablePtr
GetUseWithoutOwner(vRes)
    VideoResourcePtr    vRes;
{
    int i;

    for (i=0; i < vRes->useCount; i++)
	if (!vRes->usage[i].owned) 
	    return (vRes->usage[i].pDraw);

    return (DrawablePtr) NULL;
}

static void 
DeleteVideoUse(pDraw, vio)
    DrawablePtr         pDraw;
    VideoIO		vio;
{
    VideoScreenPtr	vp;
    VideoResourcePtr	vRes;
    int			i;

    vp = ScreenVideoInfo[ pDraw->pScreen->myNum ];
    vRes = (VideoResourcePtr) 
	    LookupIDByType(vio, vp->vIdType);
    for (i=0; i < vRes->useCount; i++)
	if (vRes->usage[i].pDraw == pDraw) {
	    vRes->useCount--;
	    vRes->usage[i].pClient = (ClientPtr) NULL;
	    vRes->usage[i].pDraw = (DrawablePtr) NULL;
	    vRes->usage[i].owned = FALSE;
	    break;
	}
}

static Bool 
AddVideoUse(pDraw, vio, client)
    DrawablePtr         pDraw;
    VideoIO		vio;
    ClientPtr		client;
{
    VideoScreenPtr	vp;
    VideoResourcePtr	vRes;
    int			i,k;

    vp = ScreenVideoInfo[ pDraw->pScreen->myNum ];
    vRes = (VideoResourcePtr) 
	    LookupIDByType(vio, vp->vIdType);
    if (USE_SATURATED(vRes))
	return FALSE;

    i = vRes->useCount++;
    vRes->usage[i].pClient = client;
    vRes->usage[i].pDraw = pDraw;
    for (k=0; k < vRes->ownerCount; k++)
	if (vRes->owners[k].pClient == client && !vRes->owners[k].inUse) {
	    vRes->owners[k].inUse = TRUE;
	    vRes->usage[i].owned = TRUE;
	    return TRUE;
	}

    vRes->usage[i].owned = FALSE;
    return TRUE;
}

/*
 * Stop a video action (Render and/or Capture) on a drawable.
 * This routine calls the dix routine (*vp->StopVideo).
 * Generate Override event(s) on the drawable.
 */
StopVideo(vp, vDraw, pDraw, action)
    VideoScreenPtr	vp;	/* Video screen of drawable */
    VideoDrawPtr	vDraw;	/* Drawable whose video is to be stopped */
    DrawablePtr		pDraw;	/* Drawable whose video is to be stopped */
    int			action;	/* (VEXStopRenderVideo | VEXStopCaptureVideo) */
{
    if (vDraw->renderActive && (action & VEXStopRenderVideo)) {
	DeleteVideoUse(pDraw, vDraw->videoIn);
	SendVideoOverrideEvent(pDraw, vDraw->videoIn);
    }
    if (vDraw->captureActive && (action & VEXStopCaptureVideo)) {
	DeleteVideoUse(pDraw, vDraw->videoOut);
	SendVideoOverrideEvent(pDraw, vDraw->videoOut);
    }
    (*vp->StopVideo)(vp, pDraw, action);
    /* XXX
     * I am letting lower level routines modify '*Active'.  Eventually,
     * I think management of these fields should move up here.
     */
    /*
    /* XXX
     * Can I delete vDraw now?  vDraw is a resource associated with a
     * pDraw.
     */
}


int RenderOrCapture(client, pVideoAction, request)
    ClientPtr		client;
    VideoActionPtr	pVideoAction;
    int			request;
{
    VideoScreenPtr	vp;
    VideoResourcePtr	vRes;
    VideoDrawPtr	vDraw;
    DrawablePtr		pDraw = pVideoAction->drawable;
    DrawablePtr		pDrawWithoutOwner;
    screenIndexRec	*screen = (screenIndexRec *) NULL;
    short		*active;
    XID			*vio;
    int			stop;
    Bool		(* func)();
    int			ret;


    /*
     * check the Vin/Vout.
     */
    vp = ScreenVideoInfo[ pDraw->pScreen->myNum ];
    if (vp == NULL)
	vRes = (VideoResourcePtr) NULL;
    else
	vRes = (VideoResourcePtr) 
		LookupIDByType(pVideoAction->videoIO, vp->vIdType);
    if (vRes) {
	for (screen = vRes->screens; screen; screen = screen->next) {
	    if (pDraw->pScreen == screen->pScreen) {
		break;
	    }
	}

	if (!screen) {
	    client->errorValue = pVideoAction->videoIO;
	    return BadMatch;
	}
    }

    if (vRes->type != ((request == VEXRender) ? Input: Output)) {
	client->errorValue = pVideoAction->videoIO;
	return BAD_VIDEO;
    }
    pVideoAction->vRes = vRes;

    /*
     * be sure the depth/visual of the vin/vout and the drawable match
     */
    if (! ModelMatch(vp, (request == VEXRender), screen->index, pDraw)) {
	client->errorValue = pDraw->id;
	VIDEO_DBG_RETURN (BadMatch);
    }

    pVideoAction->vDraw = vDraw = GetVideoDrawable(vp, pDraw);
    if (request == VEXRender) {
	active = &vDraw->renderActive;
	stop = VEXStopRenderVideo;
	func = vp->RenderVideo;
	vio = &vDraw->videoIn;
    } else {
	active = &vDraw->captureActive;
	stop = VEXStopCaptureVideo;
	func = vp->CaptureGraphics;
	vio = &vDraw->videoOut;
    }

    /*
     * Figure out if concurrent use prevents this request from happening
     * See if we need to StopVideo on some other drawable used by this
     * videoIO to allow this one to happen.
     *
     * The decision tree:
     *		If (current use < max use - 1)
     *			Request succeeds
     *			No events generated
     *		else if (there is current use by a client having insufficient
     *			 ownerships)
     *			StopVideo on one of that client's uses
     *				VideoOverride event is generated
     *			Request succeeds
     *		else 
     *			Request fails
     *			VideoRequest event is generated
     */
    if (USE_SATURATED(vRes)) {
	pDrawWithoutOwner = GetUseWithoutOwner(vRes);
	if (!pDrawWithoutOwner) {
	    SendVideoRequestEvent(request, pVideoAction, TRUE);
	    return Success;
	}
	else
	    StopVideo(vp, vDraw, pDrawWithoutOwner, stop);
    }

    /*
     * If there there is already a competing VideoAction on this drawable,
     * Stop it.
     */
    if (*active) {
	StopVideo(vp, vDraw, pDraw, stop);
    }

    ret = (*func)(vp, pVideoAction);
    if (ret == Success) {
	/* XXX
	 * I assume that StillVideo will complete before (*func) returns.
	 *
	 * XXX
	 * I am letting lower level routines modify '*active'.  Eventually,
	 * I think management of these fields should move up here.
	 *	*active = (pVideoAction->fullMotion) ? MotionVideo : NoVideo;
	 */
	*vio = pVideoAction->videoIO;
	SendVideoRequestEvent(request, pVideoAction, FALSE);
	SendVideoSyncEvent(pVideoAction->videoIO, VEXSyncAcquired);
	if (!pVideoAction->fullMotion)
	    SendVideoOverrideEvent(pDraw, pVideoAction->videoIO);
	else
	    AddVideoUse(pDraw, vRes->id, client);
    }

    return (ret);
}

static Bool ModelRowMatch(vp, modelRow, modelMask, pDraw)
    VideoScreenPtr	vp;
    unsigned char	*modelRow;
    unsigned char	modelMask;
    DrawablePtr		pDraw;
{
    int	column;
    WindowOptPtr ancwopt;

    for (column = 0; column < vp->nAllowedDepths; column++) {
	if ((modelRow[ column ] & modelMask) == 0
	 || vp->pAllowedDepths[ column ].depth != pDraw->depth)
	    continue;
	if (modelMask & PixmapModel)
	    return (TRUE);

	/*
	 * Check the visual id for Windows
	 */
	ancwopt = ((WindowPtr)pDraw)->optional;
	if (!ancwopt)
	    ancwopt = FindWindowWithOptional((WindowPtr)pDraw)->optional;
	if (ancwopt->visual == vp->pAllowedDepths[column].visualid)
	    return (TRUE);
    }
    return (FALSE);
}

/*
 * Check whether the Vin/Vout and the depth/visual of the window match.
 */
Bool ModelMatch(vp, input, index, pDraw)
    VideoScreenPtr	vp;
    Bool		input;
    int			index;
    DrawablePtr		pDraw;
{
    unsigned char	*modelRow;
    unsigned char	modelMask;

    switch (pDraw->type) {
    case DRAWABLE_PIXMAP:
	modelMask = PixmapModel;
	break;
    case DRAWABLE_WINDOW:
	modelMask = WindowModel;
	break;
    default:
        return (FALSE);
    }
    modelRow = (input ? vp->pVinModels : vp->pVoutModels)
		    + index * vp->nAllowedDepths;

    return (ModelRowMatch(vp, modelRow, modelMask, pDraw));
}
