/* $Header: video.c,v 1.18 90/04/19 11:55:04 scotthe Exp $ */
/************************************************************
Copyright 1989 by Tektronix Inc.
Copyright 1989 by The Massachusetts Institute of Technology

                    All Rights Reserved

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the names of MIT and Tektronix not be
used in advertising or publicity pertaining to distribution 
of the software without specific prior written permission.
M.I.T. and Tektronix make no representation about the 
suitability of this software for any purpose. It is provided 
"as is" without any express or implied warranty.

MIT AND TEKTRONIX DISCLAIM ALL WARRANTIES WITH REGARD TO  THIS  
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY 
AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL MIT OR
TEKTRONIX BE LIABLE FOR  ANY SPECIAL, INDIRECT OR CONSEQUENTIAL 
DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
DATA  OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION  WITH
THE USE OR PERFORMANCE OF THIS SOFTWARE.

********************************************************/

#define NEED_REPLIES
#define NEED_EVENTS
#include <stdio.h>
#include "X.h"
#include "Xproto.h"
#include "misc.h"
#include "os.h"
#include "windowstr.h"
#include "colormapst.h"
#include "scrnintstr.h"
#include "pixmapstr.h"
#include "extnsionst.h"
#include "gcstruct.h"
#include "dixstruct.h"
#include "resource.h"
#include "opaque.h"
#include "regionstr.h"

#include "VEX.h"
#include "VEXproto.h"
#include "VEXcommon.h"
#include "videostr.h"

#define NextSetting(p)	((xSetting *)((int)((p)+1) + (((p)->length +3) & (~3))))
#define NBYTES_BASIC_REPLY	32

extern int Ones();
XID clientErrorValue;   /* XXX this is a kludge */

static unsigned char VideoReqCode = 0;

extern TimeStamp lastVideoChangeConnectivityTime;


#ifdef R3
#define LEGAL_NEW_RESOURCE(id,client)\
    if ((LookupID(id, RT_ANY, RC_CORE) != 0) || (id & SERVER_BIT) \
        || (client->clientAsMask != CLIENT_BITS(id)))\
    {\
        client->errorValue = id;\
        return(BadIDChoice);\
    }
#else
/* LEGAL_NEW_RESOURCE defined in dix.h */
#endif

#define LOOKUP_DRAWABLE(did, client)\
    ((client->lastDrawableID == did) ? \
     client->lastDrawable : (DrawablePtr)LookupDrawable(did, client))

#ifdef R3
#define VERIFY_GC(pGC, rid, client)\
    if (client->lastGCID == rid)\
        pGC = client->lastGC;\
    else\
        pGC = (GC *)LookupID(rid, RT_GC, RC_CORE);\
    if (!pGC)\
    {\
        client->errorValue = rid;\
        return (BadGC);\
    }

#else
/* VERIFY_GC defined in dix.h */
#endif

#ifdef VIDEO_DBG

#include <stdio.h>
static FILE *FpVideoErrFile;

#define VIDEO_DBG_RETURN(rtval) \
    {\
    fprintf(FpVideoErrFile, "Returning %d\n", rtval); \
    fflush(FpVideoErrFile); \
    return (rtval); \
    }
#define VIDEO_DBG_PRINT_HEX(num) \
    fprintf(FpVideoErrFile, "num 0%x\n", num); \
    fflush(FpVideoErrFile);
#define VIDEO_DBG_PRINT_INT(num) \
    fprintf(FpVideoErrFile, "num %d\n", num); \
    fflush(FpVideoErrFile);
#define VIDEO_DBG_PRINT_UNSIGNED(num) \
    fprintf(FpVideoErrFile, "num %u\n", num); \
    fflush(FpVideoErrFile);
#define VIDEO_DBG_PRINT_STRING(str) \
    fprintf(FpVideoErrFile, "str\n"); \
    fflush(FpVideoErrFile);
#define VIDEO_DBG_OPEN_FILE \
    FpVideoErrFile = fopen("/tmp/VideoErrFile", "w");


#else

#define VIDEO_DBG_RETURN(rtval) \
    return (rtval);
#define VIDEO_DBG_PRINT_HEX(num)
#define VIDEO_DBG_PRINT_INT(num)
#define VIDEO_DBG_PRINT_UNSIGNED(num)
#define VIDEO_DBG_PRINT_STRING(str)
#define VIDEO_DBG_OPEN_FILE

#endif

/*
 * DestroyWindow is too late to do anything... do we
 * need this anymore?  XXXX
 */
static Bool vexDestroyWindow(pWindow)
    WindowPtr pWindow;
{
    ScreenPtr		pScr = pWindow->drawable.pScreen;
    Bool		result;

    pScr->DestroyWindow = ScreenVideoInfo[ pScr->myNum ]->DestroyWindow;
    result = (*pScr->DestroyWindow)(pWindow);
    pScr->DestroyWindow = vexDestroyWindow;

    return (result);
}

static void vexCopyWindow(pWindow, lastPosition, pRegionSrc)
    WindowPtr pWindow;
    DDXPointRec lastPosition;
    RegionPtr pRegionSrc;
{
    ScreenPtr		pScr = pWindow->drawable.pScreen;
    Bool		hasVideo;
    VideoScreenPtr	vp;

    vp = ScreenVideoInfo[ pScr->myNum ];
    hasVideo = (*vp->PreCopyWindow)(pWindow, lastPosition, pRegionSrc);

    pScr->CopyWindow = vp->CopyWindow;
    (*pScr->CopyWindow)(pWindow, lastPosition, pRegionSrc);
    pScr->CopyWindow = vexCopyWindow;

    if (hasVideo)
	(*vp->PostCopyWindow)(pWindow, lastPosition, pRegionSrc);
}

static Bool vexCreateWindow(pWindow)
    WindowPtr pWindow;
{
    ScreenPtr		pScr = pWindow->drawable.pScreen;
    Bool		result;

    pScr->CreateWindow = ScreenVideoInfo[ pScr->myNum ]->CreateWindow;
    result = (*pScr->CreateWindow)(pWindow);
    pScr->CreateWindow = vexCreateWindow;

    return (result);
}

static DeleteVideoDrawable(vDraw, id)
    VideoDrawPtr vDraw;
    XID id;
{
    VideoScreenPtr	vp;

    if (vDraw->renderActive || vDraw->captureActive) {
	vp = ScreenVideoInfo[ vDraw->pDraw->pScreen->myNum ];
	StopVideo (vp, vDraw, vDraw->pDraw, (VEXStopRenderVideo|VEXStopCaptureVideo));
    }
    xfree(vDraw);
}

static DeleteVideoResource(value, id)
    pointer value;
    XID id;
{
    xfree(value);
}

static DeleteVideoId(value, id)
    pointer value;
    XID id;
{
    /*
     * If this is a VideoDevice, delete storage.  Otherwise, this id is an
     * alias for a VReference.
     */
    if (((VideoResourcePtr)value)->type == Device)
	xfree(value);
}

#define WIN_OWNER	0
#define CLIENT_OWNER	1
#define RES_OWNER(type,owner,id) \
	((type == WIN_OWNER && owner.window == id) || \
	(type == CLIENT_OWNER && owner.clientID == id))

/*
 * "value" is a pointer to an XID.  "id" is a window ID.
 * The "value" XID is used to find the VideoResource.
 */
static DeleteWinOwner(value, id)
    pointer value;
    XID id;
{
    DeleteWinOrClientOwner(value, id, WIN_OWNER);
}
/*
 * "value" is a pointer to an XID.  "id" is a Fake client ID.
 * The XID is used to find the VideoResource.
 */
static DeleteClientOwner(value, id)
    pointer value;
    XID id;
{
    DeleteWinOrClientOwner(value, id, CLIENT_OWNER);
}
/*
 * "value" is a pointer to an XID.  "id" is a window ID or a Fake client ID.
 * The "value" XID is used to find the VideoResource.
 * Delete all ownerships for this id for the VideoResource.
 * "DisOwn" any current uses which are owned by this "window/client"
 */
static DeleteWinOrClientOwner(value, id, resType)
    pointer value;
    XID id;
    int resType;
{
    VideoResourcePtr vRes;
    int i,k;

    vRes = (VideoResourcePtr) LookupIDByType(*value,
			ScreenVideoInfo[0]->vIdType);
    if (vRes) {
	for (i=0; i < vRes->maxUse; i++) {
	    if (RES_OWNER(resType,vRes->owners[i],id)) {
		for (k=0; k < vRes->maxUse; k++) {
		    if (vRes->usage[k].pClient == vRes->owners[i].pClient &&
			    vRes->usage[k].owned) {
			vRes->usage[i].owned = FALSE;
			break;
		    }
		}
		vRes->owners[i].pClient = (ClientPtr) NULL;
		vRes->owners[i].clientID = INVALID;
		vRes->owners[i].window = INVALID;
		vRes->owners[i].inUse = FALSE;
		vRes->ownerCount--;
	    }
	}
    }
    xfree(value);
}
#undef WIN_OWNER
#undef CLIENT_OWNER
#undef RES_OWNER

/****************
 *
 * VexExtensionInit()
 *
 * Called from InitExtensions in main() or from QueryExtension() if the
 * extension is dynamically loaded.
 *
 ****************/
void
VexExtensionInit()
{
    ExtensionEntry *extEntry, *AddExtension();
    int ProcVideoDispatch(), SProcVideoDispatch();
    void  VideoResetProc();
    int i, j, k;
    int nvio;
    XID reference;
    int type;
    RESTYPE vDrawType;
    RESTYPE vResType;
    RESTYPE vIdType;
    RESTYPE vClientOwnerType;
    RESTYPE vWinOwnerType;
    VideoResourcePtr	vRes;
    VideoGeometry   *attrs;
    xVideoGeometry *pxvg;
    screenIndexRec *vscreens, *next;
    DeviceElement *pElement;

    lastVideoChangeConnectivityTime = currentTime;

    ScreenVideoInfo = (VideoScreenPtr *) 
	    xalloc (screenInfo.numScreens * sizeof (VideoScreenPtr));
    if (!ScreenVideoInfo) {
	return;
    }

    vDrawType = CreateNewResourceType(DeleteVideoDrawable);
    vResType = CreateNewResourceType(DeleteVideoResource);
    vIdType = CreateNewResourceType(DeleteVideoId);
    vClientOwnerType = CreateNewResourceType(DeleteClientOwner);
    vWinOwnerType = CreateNewResourceType(DeleteWinOwner);

    for (i=0; i<screenInfo.numScreens; i++) {
#ifdef R3
	if (ddxVexInit(&screenInfo.screen[i], &ScreenVideoInfo[i]) == FALSE) {
	    /* XXX Do something here someday */
	}
#else
	if (ddxVexInit(screenInfo.screens[i], &ScreenVideoInfo[i]) == FALSE) {
	    /* XXX Do something here someday */
	}

	if (!ScreenVideoInfo[i])
	    continue;
	/*
	 * initialize
	 */
	ScreenVideoInfo[i]->id = FakeClientID(0);
	ScreenVideoInfo[i]->CreateWindow = screenInfo.screens[i]->CreateWindow;
	ScreenVideoInfo[i]->CopyWindow = screenInfo.screens[i]->CopyWindow;
	ScreenVideoInfo[i]->DestroyWindow =
	    screenInfo.screens[i]->DestroyWindow;
	ScreenVideoInfo[i]->vDrawType = vDrawType;
	ScreenVideoInfo[i]->vResType = vResType;
	ScreenVideoInfo[i]->vIdType = vIdType;
	ScreenVideoInfo[i]->vClientOwnerType = vClientOwnerType;
	ScreenVideoInfo[i]->vWinOwnerType = vWinOwnerType;
	screenInfo.screens[i]->CreateWindow = vexCreateWindow;
	screenInfo.screens[i]->CopyWindow = vexCopyWindow;
	screenInfo.screens[i]->DestroyWindow = vexDestroyWindow;
	ScreenVideoInfo[i]->lastVideoChangeTime = currentTime;

	/*
	 * Add reference resources to each of the video inputs, outputs
	 * and devices.  There are 3 relevant lists per screen:
	 *	pInattrs -- Input attribute structures
	 *	pOutattrs -- Input attribute structures
	 *	deviceInfo.devices -- DeviceElement structures
	 * There should be 1 and only 1 reference resource per ID.
	 * There are some complications:
	 *	A single VReference ID may be used on multiple screens, but
	 *		refers to one VideoInput or VideoOutput and should
	 *		have only one reference resource for the ID.
	 *	VideoInputs and VideoOutputs may or may not have controls,
	 *		so some VReference IDs will show up on the
	 *		deviceInfo.devices list.
	 *
	 * We will not allow a ddx to try to put Controls on a VideoInput or
	 * VideoOutput on a screen in which the VideoInput or VideoOutput was
	 * not listed in an attribute structure list.
	 */
	for (k=0; k < 2; k++) {
	    if (k == 0) {
		nvio = ScreenVideoInfo[i]->nVin;
		attrs = ScreenVideoInfo[i]->pInattrs;
		type = Input;
	    } else {
		nvio = ScreenVideoInfo[i]->nVout;
		attrs = ScreenVideoInfo[i]->pOutattrs;
		type = Output;
	    }
	    for (j=0; j < nvio; j++) {
		pxvg = &attrs[ j ].xvg;
		reference = pxvg->referenceId;
		if (!(vRes = (VideoResourcePtr) LookupIDByType(reference,
			    ScreenVideoInfo[0]->vResType))) {
		    assert (pxvg->concurrentUse >= 1);
		    vRes = (VideoResourcePtr) xalloc(sizeof(VideoResourceRec));
		    vRes->owners = (Ownership *) 
			    xalloc(pxvg->concurrentUse * sizeof(Ownership));
		    vRes->usage = (ResourceUsage *) 
			    xalloc(pxvg->concurrentUse *sizeof(ResourceUsage));
		    vRes->type = type;
		    vRes->maxUse = pxvg->concurrentUse;
		    InitOwnership(vRes);
		    InitUsage(vRes);
		    vRes->id = reference;
		    vRes->pElement = (DeviceElement *) NULL;
		    vRes->screens = (screenIndexRec *) NULL;
		    if (! AddResource(reference, vResType, (pointer)vRes)) {
			/* XXX Do something here someday */
			return;
		    }
		}
		next = vRes->screens;
		vscreens = (screenIndexRec *)xalloc(sizeof(screenIndexRec));
		if (!vscreens)
		    /* XXX Do something here someday */
		    return;
		vscreens->index = j;
		vscreens->pScreen = screenInfo.screens[i];
		vscreens->next = next;
		vRes->screens = vscreens;
	    }
	}
	/*
	 * Add VideoResource resource for each VideoDevice.
	 */
	for (j=0; j < ScreenVideoInfo[i]->deviceInfo.devices.nDevice; j++) {
	    pElement = ScreenVideoInfo[i]->deviceInfo.devices.pDeviceElement[j];
	    if (!(vRes = (VideoResourcePtr) LookupIDByType(pElement->id,
			ScreenVideoInfo[0]->vIdType))) {
		assert(pElement->type == Device);
		if (!(vRes=(VideoResourcePtr)xalloc(sizeof(VideoResourceRec)))){
		    /* XXX Do something here someday */
		    return;
		}
		vRes->type = Device;
		vRes->maxUse = 1;
		vRes->owners = (Ownership *) xalloc(sizeof(Ownership));
		vRes->usage = (ResourceUsage *) NULL;
		InitOwnership(vRes);
		vRes->id = pElement->id;
		vRes->screens = (screenIndexRec *) NULL;
		if (! AddResource(pElement->id, vIdType, (pointer)vRes)) {
		    /* XXX Do something here someday */
		    return;
		}
	    }
	    vRes->pElement = pElement;
	    if (pElement->type == Device) {
		next = vRes->screens;
		vscreens = (screenIndexRec *)xalloc(sizeof(screenIndexRec));
		if (! vscreens)
		    /* XXX Do something here someday */
		    return;
		vscreens->pScreen = screenInfo.screens[i];
		vscreens->next = next;
		vRes->screens = vscreens;
	    }
	}

#endif
    }
#ifdef R3
    extEntry = AddExtension(VEX_NAME, VideoNumberEvents, VideoNumberErrors, 
		    ProcVideoDispatch, SProcVideoDispatch, VideoResetProc);
#else
    extEntry = AddExtension(VEX_NAME, VideoNumberEvents, VideoNumberErrors,
    ProcVideoDispatch, SProcVideoDispatch, VideoResetProc, StandardMinorOpcode);
#endif
    if (extEntry)
    {
	VideoReqCode = (unsigned char)extEntry->base;
	VideoErrorBase = extEntry->errorBase;
	(void) InitVideoEvents(extEntry);
    }
    VIDEO_DBG_OPEN_FILE;
}

/*ARGSUSED*/
void
VideoResetProc (extEntry)
ExtensionEntry	*extEntry;
{

    int i;

    /*
     * XXX
     * Is screenInfo still valid at this point?
     */
    VideoReqCode = 0;
    for (i=0; i<screenInfo.numScreens; i++)
	ddxVexReset(screenInfo.screens[i], &ScreenVideoInfo[i]);
}


ProcQueryVideo (client)
    register ClientPtr	client;
{
    REQUEST(xQueryVideoReq);
    WindowPtr	pWin;
    int retval;

    REQUEST_SIZE_MATCH (xQueryVideoReq);
    pWin = LookupWindow (stuff->window, client);
    if (!pWin) {
	client->errorValue = stuff->window;
	VIDEO_DBG_RETURN(BadWindow);
    }
    /*
     * No video hardware for this screen
     */
    if (ScreenVideoInfo[pWin->drawable.pScreen->myNum] == NULL) {
	client->errorValue = stuff->window;
	VIDEO_DBG_RETURN(BadMatch);
    }
    /* XXX
     * If a client calls QueryVideo but gets a BadWindow error, does it get 
     * signed up for VideoChange events?
     * Here we assume not.
     */
    SelectEvents (ScreenVideoInfo[pWin->drawable.pScreen->myNum]->id,
	    client, ChangeNotify);

    /*
     * QueryVideo will output the reply
     */

    if (retval = QueryVideo(pWin, client)) {
	if (client->noClientException != Success) {
	    VIDEO_DBG_RETURN(client->noClientException);
	} else {
	    client->errorValue = clientErrorValue;
	    VIDEO_DBG_RETURN (retval);
	}
    }

    return (client->noClientException);
}


#ifdef IMPLEMENTED
int
ProcChangeConnectivity (client)
    register ClientPtr client;
{
    TimeStamp time;
    int retval;
    VideoScreenRec *pVideoScreen;
    REQUEST(xChangeConnectivityReq);

VIDEO_DBG_PRINT_STRING(ProcChangeConnectivity);
VIDEO_DBG_PRINT_HEX(stuff->time);
VIDEO_DBG_PRINT_HEX(stuff->oldState);
VIDEO_DBG_PRINT_HEX(stuff->newState);

    REQUEST_SIZE_MATCH (xChangeConnectivityReq);
    time = ClientTimeToServerTime(stuff->time);
    pVideoScreen = ScreenVideoInfo[stuff->screen];

    if (CompareTimeStamps(time, pVideoScreen->lastVideoChangeTime) != EARLIER) {
	client->errorValue = stuff->time;
	VIDEO_DBG_RETURN(BadValue);
    }

    if (retval = 
	   ChangeConnectivity(pVideoScreen, stuff->oldState, stuff->newState)) {
	if (client->noClientException != Success) {
	    VIDEO_DBG_RETURN(client->noClientException);
	} else {
	    client->errorValue = clientErrorValue;
	    VIDEO_DBG_RETURN (retval);
	}
    }

    return (client->noClientException);

}
#endif /* IMPLEMENTED */


int
ProcRenderVideo (client)
    register ClientPtr client;
{
    VideoActionRec	render;
    int			result;
    DrawablePtr		pDest;
    REQUEST(xRenderVideoReq);

VIDEO_DBG_PRINT_STRING(ProcRenderVideo);
VIDEO_DBG_PRINT_HEX(stuff->src);
VIDEO_DBG_PRINT_HEX(stuff->dest);
VIDEO_DBG_PRINT_INT(stuff->srcX);
VIDEO_DBG_PRINT_INT(stuff->srcY);
VIDEO_DBG_PRINT_UNSIGNED(stuff->srcWidth);
VIDEO_DBG_PRINT_UNSIGNED(stuff->srcHeight);
VIDEO_DBG_PRINT_INT(stuff->dstX);
VIDEO_DBG_PRINT_INT(stuff->dstY);
VIDEO_DBG_PRINT_UNSIGNED(stuff->dstWidth);
VIDEO_DBG_PRINT_UNSIGNED(stuff->dstHeight);
VIDEO_DBG_PRINT_INT(stuff->fullMotion);
VIDEO_DBG_PRINT_INT(stuff->priority);
VIDEO_DBG_PRINT_INT(stuff->subWindowMode);

    REQUEST_SIZE_MATCH (xRenderVideoReq);

    if (!(pDest = LOOKUP_DRAWABLE(stuff->dest, client)))
    {
        client->errorValue = stuff->dest;
        VIDEO_DBG_RETURN (BadDrawable);
    }

    if (stuff->subWindowMode != ClipByChildren &&
	stuff->subWindowMode != IncludeInferiors) {
	    client->errorValue = stuff->subWindowMode;
	    VIDEO_DBG_RETURN(BadValue);
    }
    if (stuff->priority > 100) {
	    client->errorValue = stuff->subWindowMode;
	    VIDEO_DBG_RETURN(BadValue);
    }

    render.videoIO = stuff->src;
    render.srcX = stuff->srcX;
    render.srcY = stuff->srcY;
    render.dstX = stuff->dstX;
    render.dstY = stuff->dstY;
    render.srcWidth = stuff->srcWidth;
    render.srcHeight = stuff->srcHeight;
    render.dstWidth = stuff->dstWidth;
    render.dstHeight = stuff->dstHeight;
    render.fullMotion = stuff->fullMotion;
    render.priority = stuff->priority;
    render.subWindowMode = stuff->subWindowMode;
    render.drawable = pDest;

    result = RenderOrCapture(client, &render, VEXRender);

    if (client->noClientException != Success)
        return(client->noClientException);
    else
        return(result);
}


int
ProcCaptureGraphics (client)
    register ClientPtr client;
{
    VideoActionRec	capture;
    int			result;
    DrawablePtr		pSrc;
    Colormap		cmap;
    ColormapPtr		pcmp;
    REQUEST(xCaptureGraphicsReq);

VIDEO_DBG_PRINT_STRING(ProcCaptureGraphics);
VIDEO_DBG_PRINT_HEX(stuff->src);
VIDEO_DBG_PRINT_HEX(stuff->dest);
VIDEO_DBG_PRINT_INT(stuff->srcX);
VIDEO_DBG_PRINT_INT(stuff->srcY);
VIDEO_DBG_PRINT_UNSIGNED(stuff->srcWidth);
VIDEO_DBG_PRINT_UNSIGNED(stuff->srcHeight);
VIDEO_DBG_PRINT_INT(stuff->dstX);
VIDEO_DBG_PRINT_INT(stuff->dstY);
VIDEO_DBG_PRINT_UNSIGNED(stuff->dstWidth);
VIDEO_DBG_PRINT_UNSIGNED(stuff->dstHeight);
VIDEO_DBG_PRINT_INT(stuff->fullMotion);
VIDEO_DBG_PRINT_INT(stuff->priority);
VIDEO_DBG_PRINT_INT(stuff->subWindowMode);

    REQUEST_SIZE_MATCH (xCaptureGraphicsReq);

    if (!(pSrc = LOOKUP_DRAWABLE(stuff->src, client)))
    {
        client->errorValue = stuff->src;
        VIDEO_DBG_RETURN (BadDrawable);
    }
    if (pSrc->type == DRAWABLE_WINDOW) {
	if (stuff->cmap != None) {
	    client->errorValue = stuff->cmap;
	    VIDEO_DBG_RETURN (BadMatch);
	}
	cmap = wColormap(((WindowPtr)pSrc));
	pcmp = (ColormapPtr  )LookupIDByType(cmap, RT_COLORMAP);
	if (!pcmp) {
	    client->errorValue = stuff->cmap;
	    VIDEO_DBG_RETURN (BadColor);
	}
    } else {
	if (stuff->cmap != None) {
	    pcmp = (ColormapPtr  )LookupIDByType(stuff->cmap, RT_COLORMAP);
	    if (!pcmp) {
		client->errorValue = stuff->cmap;
		VIDEO_DBG_RETURN (BadColor);
	    }
	} else {
	    pcmp = (ColormapPtr  ) NULL;
	}
    }

    if (stuff->subWindowMode != ClipByChildren &&
	stuff->subWindowMode != IncludeInferiors) {
	    client->errorValue = stuff->subWindowMode;
	    VIDEO_DBG_RETURN(BadValue);
    }
    if (stuff->priority > 100) {
	    client->errorValue = stuff->subWindowMode;
	    VIDEO_DBG_RETURN(BadValue);
    }

    capture.videoIO = stuff->dest;
    capture.srcX = stuff->srcX;
    capture.srcY = stuff->srcY;
    capture.dstX = stuff->dstX;
    capture.dstY = stuff->dstY;
    capture.srcWidth = stuff->srcWidth;
    capture.srcHeight = stuff->srcHeight;
    capture.dstWidth = stuff->dstWidth;
    capture.dstHeight = stuff->dstHeight;
    capture.fullMotion = stuff->fullMotion;
    capture.priority = stuff->priority;
    capture.subWindowMode = stuff->subWindowMode;
    capture.drawable = pSrc;
    capture.pcmap = pcmp;

    result = RenderOrCapture(client, &capture, VEXCapture);

    if (client->noClientException != Success)
        return(client->noClientException);
    else
        return(result);

}


int
ProcStopVideo (client)
    register ClientPtr client;
{
    REQUEST(xStopVideoReq);
    int			nDrawables;
    DrawablePtr		pDraw;
    Drawable		*drawables;
    VideoScreenPtr	vp;
    int			error = Success;
    int			errorValue;
    int			i;
    VideoDrawPtr	vDraw;
    unsigned char	actionMask;

VIDEO_DBG_PRINT_STRING(ProcStopVideo);
VIDEO_DBG_PRINT_UNSIGNED(stuff->action);

    REQUEST_AT_LEAST_SIZE (xStopVideoReq);

    actionMask = VEXStopRenderVideo | VEXStopCaptureVideo;
    if (stuff->action & ~actionMask) {
	    client->errorValue = stuff->action;
	    VIDEO_DBG_RETURN(BadValue);
    }
    if (!(stuff->action & actionMask))
	return (client->noClientException);

    nDrawables = stuff->length -  (sizeof(xStopVideoReq) >> 2);
    drawables = (Drawable *) (stuff + 1);
    for (i=0; i<nDrawables; i++) {
	if (!(pDraw = LOOKUP_DRAWABLE(drawables[i], client))) {
	    error = BadDrawable;
	    errorValue = drawables[i];
	}
	else {
	    vp = ScreenVideoInfo[ pDraw->pScreen->myNum ];
	    if (vDraw = GetVideoDrawable(vp, pDraw))
		StopVideo(vp, vDraw, pDraw, (int) stuff->action);
	}
    }
    if (error != Success) {
	client->errorValue = errorValue;
	return error;
    }

    return (client->noClientException);
}



int
ProcQueryVideoControls (client)
    register ClientPtr client;
{
    REQUEST(xQueryVideoControlsReq);
    int		len;
    int		nAtoms;
    int		i, j;
    VideoDevice	vid;
    Atom	*atoms;
    xSetting	*pSetting;
    xQueryVideoControlsReply *preply;
    DeviceElement	*pElement;
    ControlElement	*pControl;
    VideoResourcePtr	vRes;

    REQUEST_AT_LEAST_SIZE (xQueryVideoControlsReq);


    atoms = (Atom *)(stuff+1);
    nAtoms = stuff->length -  (sizeof(xQueryVideoControlsReq) >> 2);
    vid = stuff->vid;

VIDEO_DBG_PRINT_STRING(ProcQueryVideoControls);
VIDEO_DBG_PRINT_HEX(stuff->vid);
VIDEO_DBG_PRINT_INT(nAtoms);

    if (nAtoms == 0) {
	client->errorValue = 0;
	return (BadLength);
    }

    /* 
     * Get DeviceElement whose id matches the vid.
     */
    vRes = (VideoResourcePtr) LookupIDByType(vid, ScreenVideoInfo[0]->vIdType);
    if (!vRes || !vRes->pElement->onLine) {
	client->errorValue = vid;
	return (BAD_VIDEO);
    }
    pElement = vRes->pElement;

    /*
     * First pass: just count up the lengths
     */
    len = sizeof(xQueryVideoControlsReply);
    for (i=0; i<nAtoms; i++) {
	if (!ValidAtom(atoms[ i ])) {
	     client->errorValue = atoms[ i ];
	     return (BadAtom);
	}
	for (j=0; j<pElement->nControl; j++) {
	    pControl = &pElement->pControl[j];
	    if (atoms[ i ] == pControl->xc.name) {
		len += sizeof(xSetting) + 
			((pControl->xc.settingLength + 3) & (~3));
		break;
	    }
	}
	if (j == pElement->nControl) {
	    client->errorValue = atoms[ i ];
	    return (BadMatch);
	}
    }

    /*
     * allocate the space.
     */
    preply = (xQueryVideoControlsReply *)ALLOCATE_LOCAL(len);
    if (preply == NULL) {
	client->errorValue = len;
	return (BadAlloc);
    }

    /*
     * Finally, go back and fill in all the settings.
     */
    pSetting = (xSetting *) (preply + 1);
    for (i=0; i<nAtoms; i++, pSetting = NextSetting(pSetting)) {
	for (j=0; j<pElement->nControl; j++) {
	    pControl = &pElement->pControl[j];
	    if (atoms[ i ] == pControl->xc.name) {
		if (!(*pElement->QueryVideoControls)
			(pElement, j, pSetting + 1)){
		    DEALLOCATE_LOCAL(preply);
		    return (BadAlloc);
		}
		pSetting->name = pControl->xc.name;
		pSetting->id = pControl->xc.id;
		pSetting->format = pControl->xc.settingFormat;
		pSetting->length = pControl->xc.settingLength;
		break;
	    }
	}
    }
    preply->type = X_Reply;
    preply->sequenceNumber = client->sequence;
    preply->length = (len - NBYTES_BASIC_REPLY) >> 2;
    preply->nSettings = nAtoms;

    if (client->swapped)
	SQueryVideoControlsReply(client, len, preply);	
    else 
	(void) WriteToClient(client, len, (char *) preply);
    DEALLOCATE_LOCAL(preply);
    return(client->noClientException);
}

int
ProcChangeVideoControls (client)
    register ClientPtr client;
{
    REQUEST(xChangeVideoControlsReq);
    xSetting		*settingList;
    unsigned long	nSettings;
    int			i,j;
    int			error = Success;
    int			errorValue;
    int			valueReturn;
    DeviceElement	*pElement;
    VideoResourcePtr	vRes;
    ControlElement	*pControl;

VIDEO_DBG_PRINT_STRING(ProcChangeVideoControls);

    REQUEST_AT_LEAST_SIZE (xChangeVideoControlsReq);

    /*
     * The protocol says to execute all valid Control Settings even if
     * some controls in the list generate errors.  It is up to implementors
     * to decide which error to return if multiple errors occur.
     * We will return the last error encountered cuz it is the easiest.
     */

    nSettings = stuff->nSettings;
    settingList = (xSetting *) (stuff + 1);
    for (i=0; i<nSettings; i++, settingList = NextSetting(settingList)) {
	if (!ValidAtom(settingList->name)) {
	     errorValue = settingList->name;
	     error = BadAtom;
	     break;
	}
	/* 
	 * Get DeviceElement whose id matches the vid.
	 */
	vRes = (VideoResourcePtr) LookupIDByType(settingList->id,
		    ScreenVideoInfo[0]->vIdType);
	if (!vRes || !vRes->pElement->onLine) {
	    /*
	     * Setting id does not correspond to an advertised device
	     */
	     errorValue = settingList->id;
	     error = BAD_VIDEO;
	     break;
	}
	pElement = vRes->pElement;

	for (j=0; j<pElement->nControl; j++) {
	    pControl = &pElement->pControl[j];
	    if (settingList->name == pControl->xc.name) {
		if (settingList->format != pControl->xc.settingFormat) {
		     errorValue = settingList->format;
		     if (settingList->format == 8 ||
			 settingList->format == 16 ||
			 settingList->format == 32)
			 error = BadMatch;
		     else
			 error = BadValue;
		     break;
		}
		if (settingList->length != pControl->xc.settingLength) {
		     errorValue = settingList->length;
		     error = BadLength;
		     break;
		}
		if (!(*pElement->ChangeVideoControls)
		    (pElement, j, settingList + 1, &valueReturn)){
		    errorValue = valueReturn;
		    error = BadValue;
		}
		break;
	    }
	}
	if (j == pElement->nControl) {
	     errorValue = settingList->name;
	     error = BadMatch;
	}
    }

    if (error != Success) {
	client->errorValue = errorValue;
	return (error);
    }

    return (client->noClientException);
}

int
ProcCreateVideo (client)
    register ClientPtr client;
{
    VideoResourcePtr	vRes;
    REQUEST(xCreateVideoReq);

VIDEO_DBG_PRINT_STRING(ProcCreateVideo);
VIDEO_DBG_PRINT_HEX(stuff->id);
VIDEO_DBG_PRINT_HEX(stuff->reference);

    REQUEST_SIZE_MATCH(xCreateVideoReq);
    /* XXX
     * Is LEGAL_NEW_RESOURCE the proper macro to call for a VEX resource ID??
     */
    LEGAL_NEW_RESOURCE(stuff->id, client);

    /*
     * This is a bit of a hack, because we need the resource type,
     * but they are kept with the video info which is stored by screen,
     * but we don't yet know what screen we are talking about, so
     * we use the 0th (all the resource types are the same for all screens).
     */
    vRes = (VideoResourcePtr) LookupIDByType(stuff->reference,
			ScreenVideoInfo[0]->vResType);
    if (vRes == NULL) {
        client->errorValue = stuff->reference;
        return(BAD_VIDEO);
    }

    AddResource(stuff->id, ScreenVideoInfo[0]->vIdType, (pointer)vRes);

    /*
     * CreateVideo
     * return result
     */
    return (client->noClientException);
}

#ifdef IMPLEMENTED
int
ProcChangeOwnership (client)
    register ClientPtr client;
{
    REQUEST(xChangeOwnershipReq);
    int			nOwners;
    VideoResourcePtr	vRes;
    int			i;
    xOwner		*pOwners;
    int			error = Success;

VIDEO_DBG_PRINT_STRING(ProcChangeOwnership);

    REQUEST_AT_LEAST_SIZE (xChangeOwnershipReq);

    nOwners = stuff->length -  (sizeof(xChangeOwnershipReq) >> 2);

    pOwners = (xOwner *)(stuff + 1);
    for (i=0; i < nOwners; i++) {
	if (!LookupWindow(pOwners[i].window, client)) {
	    /*
	     * If we find errors, just remember the last one and process
	     * the rest of the owner list.
	     */
	    error = BadWindow;
	    break;
	}
#ifdef XXXfinished
	XXX If client no longer exists
	    break;
#endif XXXfinished
	vRes = (VideoResourcePtr) LookupIDByType(pOwners[i].vid,
			    ScreenVideoInfo[0]->vIdType);
	if (vRes == NULL) {
	    error = BAD_VIDEO;
	    break;
	}
    }
/*
 * XXX Not implemented
 * ChangeOwnership
 * return result
 */
    return (client->noClientException);

}
#endif /* IMPLEMENTED */

int
ProcSelectVideoEvents (client)
    register ClientPtr client;
{
    int retval;
    REQUEST(xSelectVideoEventsReq);

VIDEO_DBG_PRINT_STRING(ProcSelectVideoEvents);
VIDEO_DBG_PRINT_UNSIGNED(stuff->id);
VIDEO_DBG_PRINT_HEX(stuff->mask);

    REQUEST_SIZE_MATCH(xSelectVideoEventsReq);


    if (stuff->mask & ~AllVEXEventMask) {
	client->errorValue = stuff->mask;
	return BadValue;
    }

    if ((retval = VideoSelectInput( stuff->id, client, stuff->mask)) != Success)
	return retval;
    else
	return (client->noClientException);
}

#ifdef XXXBlend
int
ProcListInstalledBlendmaps(client)
    register ClientPtr client;
{
    xListInstalledBlendmapsReply *preply; 
    int nummaps;
    WindowPtr pWin;
    REQUEST(xResourceReq);
    VideoScreenRec *pVideoScreen;
    void SListInstalledBlendmapsReply();

    REQUEST_SIZE_MATCH(xResourceReq);
    pWin = (WindowPtr)LookupWindow(stuff->id, client);

    if (!pWin)
        return(BadWindow);

    pVideoScreen = ScreenVideoInfo[pWin->drawable.pScreen->myNum];
    preply = (xListInstalledBlendmapsReply *) 
		ALLOCATE_LOCAL(sizeof(xListInstalledBlendmapsReply) +
		     pVideoScreen->maxInstalledMaps * sizeof(Colormap));
    if(!preply)
        return(BadAlloc);

    preply->type = X_Reply;
    preply->sequenceNumber = client->sequence;
    nummaps = (*pVideoScreen->ListInstalledBlendmaps)
        (pWin->drawable.pScreen, (Colormap *)&preply[1]);
    preply->nBlendmaps = nummaps;
    preply->length = nummaps;
    if (client->swapped)
	SListInstalledBlendmapsReply(client, 
		sizeof (xListInstalledBlendmapsReply), preply);	
    else 
	(void) WriteToClient(client, 
		sizeof (xListInstalledBlendmapsReply), (char *) preply);
    client->pSwapReplyFunc = Swap32Write;
    WriteSwappedDataToClient(client, nummaps * sizeof(Colormap), &preply[1]);
    DEALLOCATE_LOCAL(preply);
    return(client->noClientException);
}
#endif XXXBlend

InitOwnership(vRes)
    VideoResourcePtr vRes;
{
    int i;

    vRes->ownerCount = 0;
    for (i=0; i < vRes->maxUse; i++) {
	vRes->owners[i].pClient = (ClientPtr) NULL;
	vRes->owners[i].clientID = INVALID;
	vRes->owners[i].window = INVALID;
	vRes->owners[i].inUse = FALSE;
    }
}

InitUsage(vRes)
    VideoResourcePtr vRes;
{
    int i;

    vRes->useCount = 0;
    for (i=0; i < vRes->maxUse; i++) {
	vRes->usage[i].pClient = (ClientPtr) NULL;
	vRes->usage[i].pDraw = (DrawablePtr) NULL;
	vRes->usage[i].owned = FALSE;
    }
}


int
ProcVideoDispatch (client)
    register ClientPtr	client;
{
    REQUEST(xReq);
    switch (stuff->data) {
    case X_QueryVideo:
	return ProcQueryVideo (client);
    case X_RenderVideo:
	return ProcRenderVideo (client);
    case X_CaptureGraphics:
	return ProcCaptureGraphics (client);
    case X_StopVideo:
	return ProcStopVideo (client);
    case X_QueryVideoControls:
	return ProcQueryVideoControls (client);
    case X_ChangeVideoControls:
	return ProcChangeVideoControls (client);
    case X_CreateVideo:
	return ProcCreateVideo (client);
#ifdef IMPLEMENTED
    case X_ChangeConnectivity:
	return ProcChangeConnectivity (client);
    case X_ChangeOwnership:
	return ProcChangeOwnership (client);
#endif /* IMPLEMENTED */
    case X_SelectVideoEvents:
	return ProcSelectVideoEvents (client);
    default:
	SendErrorToClient (client, VideoReqCode, stuff->data, (XID)0,
			   BadRequest);
	return BadRequest;
    }
}

/* XXX
 * Stubs.  These fns will move out to other files when they are really written.
 */

ChangeConnectivity(pVideoScreen, oldState, newState)
    VideoScreenRec *pVideoScreen;
    unsigned long oldState;
    unsigned long newState;
{return 0;}

int
SProcVideoDispatch (client)
    register ClientPtr	client;
{
    REQUEST(xReq);
    switch (stuff->data) {
    case X_QueryVideo:
	return SProcQueryVideo (client);
    case X_CreateVideo:
	return SProcCreateVideo (client);
    case X_RenderVideo:
	return SProcRenderVideo (client);
    case X_CaptureGraphics:
	return SProcCaptureGraphics (client);
    case X_StopVideo:
	return SProcStopVideo (client);
    case X_QueryVideoControls:
	return SProcQueryVideoControls (client);
    case X_ChangeVideoControls:
	return SProcChangeVideoControls (client);
#ifdef IMPLEMENTED
    case X_ChangeConnectivity:
	return SProcChangeConnectivity (client);
    case X_ChangeOwnership:
	return SProcChangeOwnership (client);
#endif /* IMPLEMENTED */
    case X_SelectVideoEvents:
	return SProcSelectVideoEvents (client);
    default:
	SendErrorToClient (client, VideoReqCode, stuff->data, (XID)0,
			   BadRequest);
	return BadRequest;
    }
}


#ifdef STASH

void
SListInstalledBlendmapsReply(pClient, size, pRep)
    ClientPtr				pClient;
    int					size;
    xListInstalledBlendmapsReply	*pRep;
{
    int n;

    swaps(&pRep->sequenceNumber, n);
    swapl(&pRep->length, n);
    swaps(&pRep->nBlendmaps, n);
    (void)WriteToClient(pClient, size, (char *) pRep);
}
#endif /* STASH */
