/* $Header: plxFill.c,v 3.1 90/03/06 15:50:11 toddb Exp $ */
/*
 *   Copyright (c) 1987, 88 by
 *   PARALLAX GRAPHICS, INCORPORATED, Santa Clara, California.
 *   All rights reserved
 *
 *   This software is furnished on an as-is basis, and may be used and copied
 *   only with the inclusion of the above copyright notice.
 *
 *   The information in this software is subject to change without notice.
 *   No committment is made as to the usability or reliability of this
 *   software.
 *
 *   Parallax Graphics, Inc.
 *   2500 Condensa Street
 *   Santa Clara, California  95051
 */

#ifndef lint
static char *sid_ = "@(#)plxFill.c	1.18 09/01/88 Parallax Graphics Inc";
#endif

#include	"Xplx.h"

void
plxPolyFillRect(pDrawable, pGC, nrectFill, prectInit)
    DrawablePtr pDrawable;
    GCPtr pGC;
    int nrectFill;			/* number of rectangles to fill */
    xRectangle *prectInit;		/* Pointer to first rectangle to fill */
{
    int i, rop, x, y, w, h, curx, cury, curw, curh;
    register xRectangle *prect;
    short xorg,yorg,xtile,ytile;
    PixmapPtr pix;
    register MapPrivPtr mp;

    ifdebug(2) printf("plxPolyFillRect(), nrect=%d\n", nrectFill);

    switch(pGC->fillStyle) {
    case FillStippled :
    case FillOpaqueStippled :
	{
	    plxPrivGCPtr pPriv = plxGetGCPriv(pGC);

	    pix = pPriv->plxStipple;
	    if (!plxPreparePattern(pix, &xtile, &ytile)) {
		ErrorF("plxPolyFillRect: STIPPLE NOT IN CACHE\n");
		return;
	    }
	}
	break;
    case FillTiled :
	pix = pGC->tile.pixmap;
	if (!plxPreparePattern(pix, &xtile, &ytile)) {
	    ErrorF("plxPolyFillRect: TILE NOT IN CACHE\n");
	return;
	}
	break;
    }

    switch (pDrawable->type) {
    case DRAWABLE_WINDOW:
	if (pGC->miTranslate) {
	    xorg = pDrawable->x;
	    yorg = pDrawable->y;
	} else {
	    xorg = yorg = 0;
	}
	break;
    case DRAWABLE_PIXMAP:
	if (!plxPixmapUse(PIXMAP_WRITE, pDrawable, &xorg, &yorg)) {
	    ErrorF("plxPolyFillRect: PIXMAP NOT IN CACHE\n");
	    return;
	}
	/* translate X cordinate system origin to cache item origin */
	yorg = PTY(yorg);
	break;
    }

    if (xorg || yorg) {
	prect = prectInit;
	for (i = 0; i<nrectFill; i++, prect++) {
	    prect->x += xorg;
	    prect->y += yorg;
	}
    }

    /* reset xorg & yorg correct for clipping */
    if (pDrawable->type == DRAWABLE_WINDOW) {
	xorg = yorg = 0;
    }

    if (!plxClipDownLoad(pGC->pScreen, plxGetPrivGCClip(pGC), xorg, yorg))
	return;
    plxMask(pDrawable, pGC);

    prect = prectInit;

    switch(pGC->fillStyle) {
    case FillSolid :
	rop = PLX_FROM_X_OP(pGC->alu);

	if (rop < 0) {
	    while (--nrectFill >= 0) {
		ifdebug(2) printf("\tFillSolid pixel,x,y,w,h=%d,%d,%d,%d,%d\n",
				  pGC->fgPixel, prect->x, prect->y,
				  prect->width, prect->height);
		CLIPREG(p_box(pGC->fgPixel, prect->x, PTY(prect->y),
			      prect->x+prect->width-1,
			      PTY(prect->y+prect->height-1)));
		prect++;
	    }
	} else {
	    p_srop1(rop, ROP1_RMAP_TABLE, 0xff);
	    while (--nrectFill >= 0) {
		ifdebug(2) printf("\tFillSolid x,y,w,h=%d,%d,%d,%d\n",
				  prect->x, prect->y,
				  prect->width, prect->height);
		CLIPREG(p_boxr1(ROP1_RMAP_TABLE, prect->x, PTY(prect->y),
				prect->x+prect->width-1,
				PTY(prect->y+prect->height-1)));
		prect++;
	    }
	}
	break;
    case FillStippled :
	p_opaq(STIPPLE_OPAQ_TABLE);
	p_opaqm(0xff, pGC->fgPixel);
	goto tileArea;
    case FillOpaqueStippled :
	/*
	 * Since the source stipple has already been prepared with foregroun
	 * and background pixels, this operation is equivalent to a FillTiled.
	 * Therefore, fall through...
	 */
    case FillTiled :
	p_opaq(0);
tileArea:
	mp = (MapPrivPtr)pix->devPrivate.ptr;
	/*
	 * If the prepared tile is exactly the right size,
	 * then the work is easy.  Note that we must tile (with boxs)
	 * from lower left to upper right to get it on a mod 16 y boundary.
	 */
	if (mp->plxtile.canTile) {
	    ytile -= mp->plxtile.h - 1;
	    while (--nrectFill >= 0) {
		ifdebug(2) {
		    printf("\tfast Fill*Stipple/Tiled x,y,w,h=%d,%d,%d,%d\n",
			      prect->x, prect->y, prect->width, prect->height);
		}
		CLIPREG(p_boxs(xtile, ytile, prect->x, PTY(prect->y),
			       prect->x+prect->width-1,
			       PTY(prect->y+(prect->height-1))));
		prect++;
	    }
	}
	/*
	 * If the prepared tile is not 16x16, then we need
	 * to iterate through the destination, copying instances of
	 * the tile.  This could be improved by tiling a larger area
	 * and then propogating that.
	 */
	else {
	    w = mp->plxtile.w;
	    h = mp->plxtile.h;
	    while (--nrectFill >= 0) {
		ifdebug(2) {
		    printf("\tslow Fill*Stipple/Tiled x,y,w,h=%d,%d,%d,%d\n",
			      prect->x, prect->y, prect->width, prect->height);
		}
		curx = prect->x;
		for (x=0; ; x += w) {
		    if ((curw = prect->width - x) <= 0)
			break;
		    if (curw > w)
			curw = w;
		    cury = prect->y;
		    for (y=0; ; y += h) {
			if ((curh = prect->height - y) <= 0)
			    break;
			if (curh > h)
			    curh = h;
			CLIPREG(p_boxc(xtile, ytile, curx, PTY(cury),
				       curx + curw - 1, PTY(cury + curh - 1)));
			cury += h;
		    }
		    curx += w;
		}
		prect++;
	    }
	}
	break;
    }
    p_opaq(0);
    p_mask(0xffff);
}

/*
* scanline filling for parallax graphics board.
*
* these routines all clip. they assume that anything that has called
* them has already translated the points. (i.e. pGC->miTranslate is
* non-zero, which is howit gets set in plxCreateGC().)
*/

void
plxSolidFS(pDrawable, pGC, nInit, pptInit, pwidthInit, fSorted)
    DrawablePtr pDrawable;
    GCPtr pGC;
    int nInit;				/* number of spans to fill */
    DDXPointPtr pptInit;		/* pointer to list of start points */
    int *pwidthInit;			/* pointer to list of n widths */
    int fSorted;
{
    int n;				/* number of spans to fill */
    register DDXPointPtr ppt;	/* pointer to list of start points */
    short xorg,yorg;
    short rop;

    ifdebug(2) printf("plxSolidFS(), n=%d\n", nInit);

    switch (pDrawable->type) {
    case DRAWABLE_WINDOW:
	xorg = yorg = 0;
	break;
    case DRAWABLE_PIXMAP:
	if (!plxPixmapUse(PIXMAP_WRITE, pDrawable, &xorg, &yorg)) {
	    ErrorF("plxSolidFS: PIXMAP NOT IN CACHE\n");
	    return;
	}
	yorg = PTY(yorg);
	break;
    }
    if (!plxClipDownLoad(pGC->pScreen, plxGetPrivGCClip(pGC), xorg, yorg))
	    return;
    plxMask(pDrawable, pGC);

    if (xorg || yorg) {
	n = nInit; 
	ppt = pptInit;
	while (n--) {
	    ppt->x += xorg;
	    ppt->y += yorg;
	    ppt++;
	}
    }

    rop = PLX_FROM_X_OP(pGC->alu);

    while (nInit--) {
	ifdebug(2)
	    printf("\tx,y,width=%d,%d,%d\n",
		pptInit->x, pptInit->y, *pwidthInit);

	if(rop < 0) {
	    CLIPREG(p_box(pGC->fgPixel, pptInit->x, PTY(pptInit->y),
			  pptInit->x + *pwidthInit - 1, PTY(pptInit->y)));
	} else {
		p_srop1(rop, ROP1_RMAP_TABLE, 0xff);
		CLIPREG(p_boxr1(ROP1_RMAP_TABLE, pptInit->x, PTY(pptInit->y),
			        pptInit->x + *pwidthInit - 1, PTY(pptInit->y)));
	}
	pwidthInit++;
	pptInit++;
    }
    p_mask(0xffff);
}

/*
 * Fill spans with tile or stipples
 */
static void
TileOrStippleFS(pDrawable, pix, pGC, nInit, pptInit, pwidthInit, fSorted)
    DrawablePtr pDrawable;
    PixmapPtr pix;
    GCPtr pGC;
    int nInit;				/* number of spans to fill */
    DDXPointPtr pptInit;		/* pointer to list of start points */
    int *pwidthInit;			/* pointer to list of n widths */
    int fSorted;
{
    int n;				/* number of spans to fill */
    register DDXPointPtr ppt;	/* pointer to list of start points */
    short xorg,yorg,xtile,ytile;
    register MapPrivPtr mp;

    if (!plxPreparePattern(pix, &xtile, &ytile)) {
	ErrorF("plxStippleFS: STIPPLE NOT IN CACHE\n");
	return;
    }

    switch (pDrawable->type) {
    case DRAWABLE_WINDOW:
	xorg = yorg = 0;
	break;
    case DRAWABLE_PIXMAP:
	if (!plxPixmapUse(PIXMAP_WRITE, pDrawable, &xorg, &yorg)) {
	    ErrorF("plxStippleFS: PIXMAP NOT IN CACHE\n");
	    return;
	}
	/* translate X cordinate system origin to cache item origin */
	yorg = PTY(yorg);
	break;
    }
    if (!plxClipDownLoad(pGC->pScreen, plxGetPrivGCClip(pGC), xorg, yorg))
	    return;
    plxMask(pDrawable, pGC);

    if (xorg || yorg) {
	n = nInit; 
	ppt = pptInit;
	while (n--) {
	    ppt->x += xorg;
	    ppt->y += yorg;
	    ppt++;
	}
    }

    switch (pGC->fillStyle) {
    case FillStippled:			/* only write foreground */
	p_opaq(STIPPLE_OPAQ_TABLE);
	p_opaqm(0xff, pGC->fgPixel);
	break;
    case FillOpaqueStippled :
    case FillTiled :
	/*
	 * Since the source stipple has already been prepared with foregroun
	 * and background pixels, this operation is equivalent to a FillTiled.
	 */
	p_opaq(0);
	break;
    }

    mp = (MapPrivPtr)pix->devPrivate.ptr;
    /*
     * If the prepared tile is exactly the right size,
     * then the work is easy.  Note that we must tile (with boxs)
	 * from lower left to upper right to get it on a mod 16 y boundary.
     */
    if (mp->plxtile.canTile) {
	ytile -= mp->plxtile.h - 1;
	while (nInit--) {
	    ifdebug(2) printf("\t(fast) x,y,width=%d,%d,%d\n",
			      pptInit->x, pptInit->y, *pwidthInit);

	    CLIPREG(p_boxs(xtile, ytile, pptInit->x, PTY(pptInit->y),
			   pptInit->x + *pwidthInit - 1, PTY(pptInit->y)));
	    pwidthInit++;
	    pptInit++;
	}
    }
    /*
     * If the prepared tile is not 16x16, then we need
     * to iterate through the destination, copying instances of
     * the tile.  Note that we are copying single scan lines...
     */
    else {
	int x, y, w, h, curx, cury, curw;

	w = mp->plxtile.w;
	h = mp->plxtile.h;
	while (nInit--) {
	    ifdebug(2) printf("\t(slow) x,y,width=%d,%d,%d\n",
			      pptInit->x, pptInit->y, *pwidthInit);
	    for (x = y = 0;;x += w) {
		if ((curw = *pwidthInit - x) <= 0)
		    break;
		if (curw > w)
		    curw = w;
		curx = pptInit->x + x;
		cury = pptInit->y + y;
		CLIPREG(p_boxc(xtile, ytile - y, curx, PTY(cury),
			       curx + curw - 1, PTY(cury)));
		if (++y > h)
		    y = 0;
	    }
	    pwidthInit++;
	    pptInit++;
	}
    }

    p_opaq(0);
    p_mask(0xffff);
}

void
plxTileFS(pDrawable, pGC, nInit, pptInit, pwidthInit, fSorted)
    DrawablePtr pDrawable;
    GCPtr pGC;
    int nInit;				/* number of spans to fill */
    DDXPointPtr pptInit;		/* pointer to list of start points */
    int *pwidthInit;			/* pointer to list of n widths */
    int fSorted;
{
    ifdebug(2) printf("plxTileFS(), n=%d\n", nInit);

    TileOrStippleFS(pDrawable, pGC, pGC->tile.pixmap,
		    nInit, pptInit, pwidthInit, fSorted);
}

void
plxStippleFS(pDrawable, pGC, nInit, pptInit, pwidthInit, fSorted)
    DrawablePtr pDrawable;
    GCPtr pGC;
    int nInit;				/* number of spans to fill */
    DDXPointPtr pptInit;		/* pointer to list of start points */
    int *pwidthInit;			/* pointer to list of n widths */
    int fSorted;
{
    ifdebug(2) printf("plxStippleFS(), n=%d\n", nInit);

    TileOrStippleFS(pDrawable, pGC, plxGetGCPriv(pGC)->plxStipple,
		    nInit, pptInit, pwidthInit, fSorted);
}
