/* $Header: plxGC.c,v 3.2 90/03/06 15:50:18 toddb Exp $ */
/*
 *   Copyright (c) 1987, 88 by
 *   PARALLAX GRAPHICS, INCORPORATED, Santa Clara, California.
 *   All rights reserved
 *
 *   This software is furnished on an as-is basis, and may be used and copied
 *   only with the inclusion of the above copyright notice.
 *
 *   The information in this software is subject to change without notice.
 *   No committment is made as to the usability or reliability of this
 *   software.
 *
 *   Parallax Graphics, Inc.
 *   2500 Condensa Street
 *   Santa Clara, California  95051
 */

#ifndef lint
static char *sid_ = "@(#)plxGC.c	1.19 09/01/88 Parallax Graphics Inc";
#endif

#include	"Xplx.h"

#include	"mistruct.h"
#include	"mibstore.h"

static void plxValidateGC(), plxChangeGC(), plxCopyGC(), plxDestroyGC();
static void plxChangeClip(), plxDestroyClip(), plxCopyClip();
static plxDestroyOps();

static GCFuncs  plxFuncs = {
    plxValidateGC,
    plxChangeGC,
    plxCopyGC,
    plxDestroyGC,
    plxChangeClip,
    plxDestroyClip,
    plxCopyClip,
};

static GCOps	plxOps = {
    plxSolidFS,
    plxSetSpans,
    plxPutImage,
    plxCopyArea,
    plxCopyPlane,
    plxPolyPoint,
    plxZeroPolylines,
    plxZeroPolySegment,
    plxZeroPolyRectangle,
    miPolyArc,
    plxFillPolygon,
    plxPolyFillRect,
    miPolyFillArc,
    miPolyText8,
    miPolyText16,
    miImageText8,
    miImageText16,
    plxImageGlyphBlt,
    plxPolyGlyphBlt,
    mfbPushPixels,
    miMiter,
};

static GCOps *
matchCommon (pGC)
    GCPtr   pGC;
{
    if (pGC->lineWidth != 0)
	return 0;
    if (pGC->lineStyle != LineSolid)
	return 0;
    if (pGC->fillStyle != FillSolid)
	return 0;
    return &plxOps;
}

Bool
plxCreateGC(pGC)
    register GCPtr pGC;
{
    plxPrivGCPtr	pPriv;

    switch (pGC->depth) {
    case 1:
#ifdef notdef
	/*
	 * If we did this, many other changes would have to happen
	 * to support pixmaps on the processor instead of on the parallax.
	 * As it is, almost nothing is kept locally.
	 */
	return (mfbCreateGC(pGC));
#endif /* notdef */
    case PSZ:
	break;
    default:
	ErrorF("plxCreateGC: unsupported depth: %d\n", pGC->depth);
	return FALSE;
    }
    pGC->clientClip = NULL;
    pGC->clientClipType = CT_NONE;

    /*
     * some of the output primitives aren't really necessary, since they
     * will be filled in ValidateGC because of dix/CreateGC() setting all
     * the change bits.  Others are necessary because although they depend
     * on being a color frame buffer, they don't change 
     */

    pGC->ops = &plxOps;
    pGC->funcs = &plxFuncs;

    /* plx wants to translate before scan conversion */
    pGC->miTranslate = 1;

    pPriv = plxGetGCPriv(pGC);
    pPriv->rop = pGC->alu;
    pPriv->fExpose = TRUE;
    pPriv->pCompositeClip = (RegionPtr)NULL;
    pPriv->freeCompClip = FALSE;
    pPriv->plxStipple = NullPixmap;
    return TRUE;
}

/*ARGSUSED*/
static void
plxChangeGC(pGC, mask)
    GC              *pGC;
    BITS32          mask;
{
    return;
}

static void
plxDestroyGC(pGC)
    GC 			*pGC;
{
    plxPrivGCPtr	pPriv;

    pPriv = plxGetGCPriv(pGC);
    if (pPriv->freeCompClip)
	(*pGC->pScreen->RegionDestroy)(pPriv->pCompositeClip);
    if(pPriv->plxStipple)
	 (*pGC->pScreen->DestroyPixmap)(pPriv->plxStipple);
    plxDestroyOps (pGC->ops);
}

/*
 * create a private op array for a gc
 */

static GCOps *
plxCreateOps (prototype)
    GCOps	*prototype;
{
    GCOps	*ret;
    extern Bool	Must_have_memory;

    /* XXX */ Must_have_memory = TRUE;
    ret = (GCOps *) xalloc (sizeof(GCOps));
    /* XXX */ Must_have_memory = FALSE;
    if (!ret)
	return 0;
    *ret = *prototype;
    ret->devPrivate.val = 1;
    return ret;
}

static
plxDestroyOps (ops)
    GCOps   *ops;
{
    if (ops->devPrivate.val)
	xfree (ops);
}

/* Clipping conventions
	if the drawable is a window
	    CT_REGION ==> pCompositeClip really is the composite
	    CT_other ==> pCompositeClip is the window clip region
	if the drawable is a pixmap
	    CT_REGION ==> pCompositeClip is the translated client region
		clipped to the pixmap boundary
	    CT_other ==> pCompositeClip is the pixmap bounding box
*/

static void
plxValidateGC(pGC, changes, pDrawable)
    register GCPtr  pGC;
    Mask	    changes;
    DrawablePtr	    pDrawable;
{
    WindowPtr   pWin;
    int		xrot, yrot;	/* rotations for tile and stipple pattern */
    int         mask;		/* stateChanges */
    int         index;		/* used for stepping through bitfields */
    int         new_line, new_text, new_fillspans, new_rotation, new_stipple;
    plxPrivGCPtr pGCPriv;
    plxClipInfoPtr	privClip;

    pGCPriv = plxGetGCPriv(pGC);
    privClip = & (plxGetScreenPriv(pGC->pScreen)->clip);

    pGC->lastWinOrg.x = pDrawable->x;
    pGC->lastWinOrg.y = pDrawable->y;
    if (pDrawable->type == DRAWABLE_WINDOW)
    {
	pWin = (WindowPtr) pDrawable;
    }
    else
    {
	pWin = (WindowPtr) NULL;
    }

    /*
     * if the client clip is different or moved OR the subwindowMode has
     * changed OR the window's clip has changed since the last validation
     * we need to recompute the composite clip 
     */

    if ((changes & (GCClipXOrigin | GCClipYOrigin | GCClipMask)) ||
	(changes & GCSubwindowMode) ||
	(pDrawable->serialNumber != (pGC->serialNumber & DRAWABLE_SERIAL_BITS))
	)
    {
	ScreenPtr pScreen = pGC->pScreen;

	if (pWin) {
	    RegionPtr   pregWin;
	    Bool        freeTmpClip, freeCompClip;

	    if (pGC->subWindowMode == IncludeInferiors) {
		pregWin = NotClippedByChildren(pWin);
		freeTmpClip = TRUE;
	    }
	    else {
		pregWin = &pWin->clipList;
		freeTmpClip = FALSE;
	    }
	    freeCompClip = pGCPriv->freeCompClip;

	    /*
	     * if there is no client clip, we can get by with just keeping
	     * the pointer we got, and remembering whether or not should
	     * destroy (or maybe re-use) it later.  this way, we avoid
	     * unnecessary copying of regions.  (this wins especially if
	     * many clients clip by children and have no client clip.) 
	     */
	    if (pGC->clientClipType == CT_NONE) {
		if (freeCompClip)
		    (*pScreen->RegionDestroy) (pGCPriv->pCompositeClip);
		pGCPriv->pCompositeClip = pregWin;
		pGCPriv->freeCompClip = freeTmpClip;
	    }
	    else {
		/*
		 * we need one 'real' region to put into the composite
		 * clip. if pregWin the current composite clip are real,
		 * we can get rid of one. if pregWin is real and the
		 * current composite clip isn't, use pregWin for the
		 * composite clip. if the current composite clip is real
		 * and pregWin isn't, use the current composite clip. if
		 * neither is real, create a new region. 
		 */

		(*pScreen->TranslateRegion)(pGC->clientClip,
					    pDrawable->x + pGC->clipOrg.x,
					    pDrawable->y + pGC->clipOrg.y);
						  
		if (freeCompClip)
		{
		    (*pGC->pScreen->Intersect)(pGCPriv->pCompositeClip,
					       pregWin, pGC->clientClip);
		    if (freeTmpClip)
			(*pScreen->RegionDestroy)(pregWin);
		}
		else if (freeTmpClip)
		{
		    (*pScreen->Intersect)(pregWin, pregWin, pGC->clientClip);
		    pGCPriv->pCompositeClip = pregWin;
		}
		else
		{
		    pGCPriv->pCompositeClip = (*pScreen->RegionCreate)(NullBox,
								       0);
		    (*pScreen->Intersect)(pGCPriv->pCompositeClip,
					  pregWin, pGC->clientClip);
		}
		pGCPriv->freeCompClip = TRUE;
		(*pScreen->TranslateRegion)(pGC->clientClip,
					    -(pDrawable->x + pGC->clipOrg.x),
					    -(pDrawable->y + pGC->clipOrg.y));
						  
	    }
	}			/* end of composite clip for a window */
	else {
	    BoxRec      pixbounds;

	    pixbounds.x1 = 0;
	    pixbounds.y1 = 0;
	    pixbounds.x2 = pDrawable->width;
	    pixbounds.y2 = pDrawable->height;

	    if (pGCPriv->freeCompClip)
		(*pScreen->RegionReset)(pGCPriv->pCompositeClip, &pixbounds);
	    else {
		pGCPriv->freeCompClip = TRUE;
		pGCPriv->pCompositeClip = (*pScreen->RegionCreate)(&pixbounds,
								   1);
	    }

	    if (pGC->clientClipType == CT_REGION)
		(*pScreen->Intersect)(pGCPriv->pCompositeClip,
				      pGCPriv->pCompositeClip,
				      pGC->clientClip);
	}			/* end of composute clip for pixmap */
	if (pGCPriv->pCompositeClip == privClip->regionClip)
	    plxClipInvalidate (pGC->pScreen);
    }

    if (pWin) {
	    /* rotate tile patterns so that pattern can be
	     * combined in word by word, but the pattern seems
	     * to begin aligned with the window
	     */
	    /* rotation code uses this */
	    xrot = pDrawable->x;
	    yrot = pDrawable->y;
    } else {
	    yrot = 0;
	    xrot = 0;
    }

    new_line = FALSE;
    new_text = FALSE;
    new_fillspans = FALSE;
    new_rotation = FALSE;
    new_stipple = FALSE;

    mask = changes;
    while (mask) {
	index = lowbit (mask);
	mask &= ~index;

	/*
	 * this switch acculmulates a list of which procedures might have
	 * to change due to changes in the GC.  in some cases (e.g.
	 * changing one 16 bit tile for another) we might not really need
	 * a change, but the code is being paranoid. this sort of batching
	 * wins if, for example, the alu and the font have been changed,
	 * or any other pair of items that both change the same thing. 
	 */
	switch (index) {
	case GCFunction:
	case GCForeground:
	    new_text = TRUE;
	    new_stipple = TRUE;
	    break;
	case GCPlaneMask:
	    break;
	case GCBackground:
	    new_fillspans = TRUE;
	    new_stipple = TRUE;
	    break;
	case GCLineStyle:
	case GCLineWidth:
	case GCJoinStyle:
	    new_line = TRUE;
	    break;
	case GCCapStyle:
	    break;
	case GCFillStyle:
	    new_text = TRUE;
	    new_fillspans = TRUE;
	    new_line = TRUE;
	    break;
	case GCFillRule:
	    break;
	case GCTile:
	    if (pGC->tileIsPixel)
		    break;
	    new_rotation = TRUE;
	    new_fillspans = TRUE;
	    break;

	case GCStipple:
	    if(pGC->stipple == (PixmapPtr)NULL) {
		    break;
	    }
	    new_stipple = TRUE;
	    new_rotation = TRUE;
	    new_fillspans = TRUE;
	    break;

	case GCFont:
	    new_text = TRUE;
	    break;
	case GCSubwindowMode:
	    break;
	case GCGraphicsExposures:
	    break;
	case GCClipXOrigin:
	case GCClipYOrigin:
	    new_rotation = TRUE;
	    new_stipple = TRUE;
	    break;
	case GCClipMask:
	    break;
	case GCDashOffset:
	    break;
	case GCDashList:
	    break;
	case GCArcMode:
	    break;
	default:
	    break;
	}
    }

    /*
     * If the drawable has changed,  check its depth & ensure suitable
     * entries are in the proc vector. 
     */
    if (pDrawable->serialNumber != (pGC->serialNumber & (DRAWABLE_SERIAL_BITS))) {
	new_fillspans = TRUE;	/* deal with FillSpans later */
    }

    if (new_line || new_fillspans || new_text)
    {
	GCOps	*newops;

	if (newops = matchCommon (pGC))
 	{
	    if (pGC->ops->devPrivate.val)
		plxDestroyOps (pGC->ops);
	    pGC->ops = newops;
	    new_line = new_fillspans = new_text = 0;
	}
 	else
 	{
	    if (!pGC->ops->devPrivate.val)
	    {
		pGC->ops = plxCreateOps (pGC->ops);
		pGC->ops->devPrivate.val = 1;
	    }
	}
    }

    /* deal with the changes we've collected */

    if (new_line)
    {
	if(pGC->lineWidth == 0) {
	    pGC->ops->Polylines = plxZeroPolylines;
	    pGC->ops->PolySegment = plxZeroPolySegment;
	    pGC->ops->PolyRectangle = plxZeroPolyRectangle;
	} else {
	    pGC->ops->Polylines = miWideLine;      /* XXXX wrong*/
	    pGC->ops->PolySegment = miPolySegment;
	    pGC->ops->PolyRectangle = miPolyRectangle;
	}

	if (pGC->lineStyle == LineSolid)
	{
	    if(pGC->lineWidth == 0)
		pGC->ops->Polylines = miZeroLine;
	    else
		pGC->ops->Polylines = miWideLine;
	}
	else
	    pGC->ops->Polylines = miWideDash;

	switch(pGC->joinStyle)
	{
	  case JoinMiter:
	    pGC->ops->LineHelper = miMiter;
	    break;
	  case JoinRound:
	  case JoinBevel:
	    pGC->ops->LineHelper = miNotMiter;
	    break;
	}
    }

    if (new_text && (pGC->font))
    {
	pGC->ops->PolyGlyphBlt = plxPolyGlyphBlt;
	pGC->ops->ImageGlyphBlt = plxImageGlyphBlt;
    }    


    if (new_fillspans) {
	switch (pGC->fillStyle) {
	case FillSolid:
	    pGC->ops->FillSpans = plxSolidFS;
	    break;
	case FillTiled:
	    pGC->ops->FillSpans = plxTileFS;
	    break;
	case FillStippled:
	    pGC->ops->FillSpans = plxStippleFS;
	    break;
	case FillOpaqueStippled:
	    if (pGC->fgPixel == pGC->bgPixel)
		pGC->ops->FillSpans = plxSolidFS;
	    else
		pGC->ops->FillSpans = plxStippleFS;
	    break;
	default:
	    FatalError("plxValidateGC: illegal fillStyle\n");
	}
    } /* end of new_fillspans */

    if (new_rotation) {
	xrot += pGC->patOrg.x;
	yrot += pGC->patOrg.y;
    }

    /* 
     * If there is a new tile/stipple pixmap, or the rotation has changed,
     * Rotate the pixmap correctly.
     */
    if (xrot || yrot || new_rotation) {
	if (pGC->stipple)
	    plxrotatepixmap(pGC->stipple, xrot, yrot);
	if (! pGC->tileIsPixel)
	    plxrotatepixmap(pGC->tile.pixmap, xrot, yrot);
    }
    if (new_stipple) {
	if (pGC->stipple)
	    plxchangestipplecolor(pGC, pDrawable);
    }
}

static void
plxDestroyClip(pGC)
    GCPtr	pGC;
{
    if(pGC->clientClipType == CT_NONE)
	return;
    else if (pGC->clientClipType == CT_PIXMAP)
    {
	plxDestroyPixmap((PixmapPtr)(pGC->clientClip));
    }
    else
    {
	/* we know we'll never have a list of rectangles, since
	   ChangeClip immediately turns them into a region 
	*/
        (*pGC->pScreen->RegionDestroy)(pGC->clientClip);
    }
    pGC->clientClip = NULL;
    pGC->clientClipType = CT_NONE;
}

static void
plxChangeClip(pGC, type, pvalue, nrects)
    GCPtr	pGC;
    int		type;
    pointer	pvalue;
    int		nrects;
{
    plxDestroyClip(pGC);
    if(type == CT_PIXMAP)
    {
	pGC->clientClip = (pointer) (*pGC->pScreen->BitmapToRegion)((PixmapPtr)pvalue);
	(*pGC->pScreen->DestroyPixmap)(pvalue);
    }
    else if (type == CT_REGION) {
	/* stuff the region in the GC */
	pGC->clientClip = pvalue;
    }
    else if (type != CT_NONE)
    {
	pGC->clientClip = (pointer) (*pGC->pScreen->RectsToRegion)(nrects,
						    (xRectangle *)pvalue,
						    type);
	xfree(pvalue);
    }
    pGC->clientClipType = (type != CT_NONE && pGC->clientClip) ? CT_REGION :
								 CT_NONE;
    pGC->stateChanges |= GCClipMask;
}

static void
plxCopyClip (pgcDst, pgcSrc)
    GCPtr pgcDst, pgcSrc;
{
    RegionPtr prgnNew;

    switch(pgcSrc->clientClipType)
    {
      case CT_PIXMAP:
	((PixmapPtr) pgcSrc->clientClip)->refcnt++;
	/* Fall through !! */
      case CT_NONE:
        plxChangeClip(pgcDst, pgcSrc->clientClipType, pgcSrc->clientClip, 0);
        break;
      case CT_REGION:
        prgnNew = (*pgcSrc->pScreen->RegionCreate)(NULL, 1);
        (*pgcSrc->pScreen->RegionCopy)(prgnNew,
                                       (RegionPtr)(pgcSrc->clientClip));
        plxChangeClip(pgcDst, CT_REGION, (pointer)prgnNew, 0);
        break;
    }
}

/*ARGSUSED*/
static void
plxCopyGC (pGCSrc, changes, pGCDst)
    GCPtr	pGCSrc;
    Mask 	changes;
    GCPtr	pGCDst;
{
    RegionPtr		pClip;

    if(changes & GCClipMask)
    {
	if(pGCDst->clientClipType == CT_PIXMAP)
	{
	    ((PixmapPtr)pGCDst->clientClip)->refcnt++;
	}
	else if(pGCDst->clientClipType == CT_REGION)
	{
	    BoxRec pixbounds;

	    pixbounds.x1 = 0;
	    pixbounds.y1 = 0;
	    pixbounds.x2 = 0;
	    pixbounds.y2 = 0;

	    pClip = (RegionPtr) pGCDst->clientClip;
	    pGCDst->clientClip =
	        (pointer)(* pGCDst->pScreen->RegionCreate)(&pixbounds, 1);
	    (* pGCDst->pScreen->RegionCopy)(pGCDst->clientClip, pClip);
	}
    }
}

plxchangestipplecolor(pGC, pDrawable)
register GCPtr pGC;
DrawablePtr pDrawable;
{
    plxPrivGCPtr pPriv;
    ScreenPtr pScreen;
    PixmapPtr pstipple;
    short xorg, yorg, xt, yt;

    pPriv = plxGetGCPriv(pGC);
    pScreen = pGC->pScreen;

    pstipple = pGC->stipple;

    pl_cache_lock(pstipple);

    /*
     * first check the size of any allocated pixmap
     */
    if (pPriv->plxStipple) {
	if ((pPriv->plxStipple->drawable.width != pstipple->drawable.width)
	 || (pPriv->plxStipple->drawable.height != pstipple->drawable.height)) {
		 (*pScreen->DestroyPixmap)(pPriv->plxStipple);
		 pPriv->plxStipple = (PixmapPtr)0;
	}
    }

    /*
     * second allocate pixmap for correctly colored stipple
     */
    if (!pPriv->plxStipple) {
	pPriv->plxStipple =
	(*pScreen->CreatePixmap)(pScreen,
				 pstipple->drawable.width,
				 pstipple->drawable.height,
				 pDrawable->depth);
	if (!pPriv->plxStipple) {
	    ErrorF("Out of Cache for stipple");
	    pl_cache_unlock(pstipple);
	    return;
	}
    }
    pl_cache_lock(pPriv->plxStipple);

    /*
     * now copy the stipple
     */
    if (!plxPreparePattern(pstipple, &xt, &yt)) {
	ErrorF("plxchangestipplecolor: STIPPLE NOT IN CACHE\n");
	return;
    }
    if (!plxPixmapUse(PIXMAP_WRITE, pPriv->plxStipple, &xorg, &yorg)) {
	ErrorF("plxchangestipplecolor: PIXMAP NOT IN CACHE\n");
	return;
    }
    yorg = PTY(yorg);

    plxClipInvalidate(pGC->pScreen);
    p_mask(0xffff);
    SetFontMaps(pGC->fgPixel, pGC->bgPixel, 0x01, 0);
    p_boxc(xt, yt,
	   xorg, PTY(yorg), xorg+pstipple->drawable.width-1,
	   PTY(yorg+pstipple->drawable.height-1));
    p_rmap(0);
    pl_cache_unlock(pstipple);
    pl_cache_unlock(pPriv->plxStipple);
}



plxClipInit(pScr)
ScreenPtr pScr;
{
    plxClipInfoPtr	privClip;

    ifdebug(17) printf("plxClipinit()\n");

    privClip = & (plxGetScreenPriv(pScr)->clip);
    privClip->regionClip = (RegionPtr)0;
    privClip->x = 0;
    privClip->y = 0;
    privClip->size = 0;
    privClip->devClip = (short *)0;
}

/*
 * plxClipDownLoad()
 *	returns 0 if no clip area is valid, ie: dont draw anything.
 *	returns non 0 if clip is setup and ready to draw.
 */

plxClipDownLoad(pScreen, pRegion, xorg, yorg)
    ScreenPtr pScreen;
    register RegionPtr pRegion;
    register short xorg, yorg;
{
    register BoxPtr pbox, pboxLast;
    register short *p;
    plxClipInfoPtr	privClip;
    static int	debugNoClip = FALSE;

    privClip = & (plxGetScreenPriv(pScreen)->clip);

    ifdebug(7) printf("plxClipDownLoad() 0x%08x n=%d, xorg,yorg=%d,%d\n",
			pRegion, REGION_NUM_RECTS(pRegion), xorg, yorg);

    if (debugNoClip)
	return(1);

    if (REGION_NUM_RECTS(pRegion) == 0)
	    return (0);

    if ((pRegion == privClip->regionClip)
     && (xorg == privClip->x) && (yorg == privClip->y)) {
	    ifdebug(7) printf("\tclip ok\n");
	    p_clipe();
	    return (1);
    }

    privClip->regionClip = pRegion;
    privClip->x = xorg;
    privClip->y = yorg;
    ifdebug(7) printf("\tclip reload\n");

    /*p_tranc(xorg, yorg);*/
    if (REGION_NUM_RECTS(pRegion) == 1) {
	pbox = REGION_RECTS(pRegion);
	ifdebug(7) printf("\t%d,%d,%d,%d\n",
			    pbox->x1, pbox->y1, pbox->x2 - 1, pbox->y2 - 1);
	ifdebug(7) p_boxo(0x30,xorg+pbox->x1, PTY(yorg+pbox->y1),
			    xorg+pbox->x2-1, PTY(yorg+pbox->y2-1));
	p_clip(xorg+pbox->x1, PTY(yorg+pbox->y1),
		xorg+pbox->x2-1, PTY(yorg+pbox->y2-1));
    } else {
	if (privClip->size < REGION_NUM_RECTS(pRegion)) {
	    privClip->size = REGION_NUM_RECTS(pRegion);
	    privClip->devClip = (short *)Xrealloc(privClip->devClip,
					    privClip->size*sizeof(short)*4);
	}
	pbox = REGION_RECTS(pRegion);
	pboxLast = pbox + REGION_NUM_RECTS(pRegion);
	p = privClip->devClip;
	for (;pbox<pboxLast;pbox++) {
	    ifdebug(7) printf("\t%d,%d,%d,%d\n",
			      pbox->x1, pbox->y1, pbox->x2-1, pbox->y2-1);
	    *p++ = xorg+pbox->x1;
	    *p++ = PTY(yorg+pbox->y1);
	    *p++ = xorg+pbox->x2-1;
	    *p++ = PTY(yorg+pbox->y2-1);
	    ifdebug(7) p_boxo(0x30,xorg+pbox->x1, PTY(yorg+pbox->y1),
			      xorg+pbox->x2-1, PTY(yorg+pbox->y2-1));
	}
	p_clipm(REGION_NUM_RECTS(pRegion), privClip->devClip);
    }
    return (1);
}

plxClipInvalidate(pScr)
    ScreenPtr	pScr;
{
    ifdebug(7) printf("plxClipInvalidate()\n");

    plxGetScreenPriv(pScr)->clip.regionClip = (RegionPtr)NULL;
    p_clipd();
}
