/* $Header: plxMouse.c,v 3.1 90/03/06 15:50:27 toddb Exp $ */
/*
 *   Copyright (c) 1987, 88 by
 *   PARALLAX GRAPHICS, INCORPORATED, Santa Clara, California.
 *   All rights reserved
 *
 *   This software is furnished on an as-is basis, and may be used and copied
 *   only with the inclusion of the above copyright notice.
 *
 *   The information in this software is subject to change without notice.
 *   No committment is made as to the usability or reliability of this
 *   software.
 *
 *   Parallax Graphics, Inc.
 *   2500 Condensa Street
 *   Santa Clara, California  95051
 */

#ifndef lint
static char *sid_ = "@(#)plxMouse.c    1.22 07/30/88 Parallax Graphics Inc";
#endif

#define    PARALLAX_QEVENT
#include    "Xplx.h"

#define NEED_EVENTS
#include "Xproto.h"
#include "cursorstr.h"
#include "input.h"
#include "scrnintstr.h"

extern int plxGetMotionEvents();
extern void plxChangePointerControl();

extern vsEventQueue *queue;
extern DevicePtr plxPointer;
extern int lastEventTime;

extern int plx_wfd;

/*
 * Cursor/Mouse code.
 */

Bool
plxRealizeCursor(pScreen, pCursor)
ScreenPtr pScreen;
CursorPtr pCursor;
{
    PixmapPtr pPixmap;
    short x, y;

    ifdebug(5) printf("plxRealizeCursor() 0x%08x\n", pCursor);

    plxClipInvalidate(pScreen);

    pPixmap = (*pScreen->CreatePixmap)(pScreen,
				       pCursor->bits->width,
				       pCursor->bits->height,
				       BITPLANES);
    if (!plxPixmapUse(PIXMAP_WRITE, pPixmap, &x, &y)) {
        ErrorF("plxRealizeCursor: CURSOR AREA NOT IN CACHE\n");
        return FALSE;
    }
    pl_cache_lock(((MapPrivPtr)(pPixmap->devPrivate.ptr))->plxcache);

    p_opaq(0);
    p_rmap(0);
    p_mask(0xff);
    p_box(0, x, y, x+(pCursor->bits->width-1), y-(pCursor->bits->height-1));

    p_rmap(LBIT_RMAP_TABLE);
    p_mask(1);
    p_lbitl(x, y,
	    x+(pCursor->bits->width-1),
	    y-(pCursor->bits->height-1),
	    pCursor->bits->source);
    p_mask(2);
    p_lbitl(x, y,
	    x+(pCursor->bits->width-1),
	    y-(pCursor->bits->height-1),
	    pCursor->bits->mask);

    p_rmap(0);
    p_mask(0xff);

    pCursor->devPriv[pScreen->myNum] = (pointer)pPixmap;

    /* make sure the save area is large enough */
    plxsetsavearea(pScreen, pCursor->bits->width, pCursor->bits->height);

    return TRUE;
}

Bool
plxUnrealizeCursor(pScreen, pCursor)
ScreenPtr pScreen;
CursorPtr pCursor;
{
    ifdebug(5) printf("plxUnrealizeCursor() 0x%08x\n", pCursor);

    return ((*pScreen->DestroyPixmap)(pCursor->devPriv[pScreen->myNum]));
}

static BYTE mouse_mapping[4] = {
    0, 1, 2, 3,
};

int
plxMouseProc(pDev, onoff, argc, argv)
DevicePtr pDev;
char *argv[];
{
    int fd, i;

    ifdebug(5) printf("plxMouseProc(), onoff=%d\n", onoff);

    /*
     * we remove the clip becuase the cursor state on the board
     * will inherit the clip list
     */
    for (i=0; i<screenInfo.numScreens; i++)
	plxClipInvalidate(screenInfo.screens[i]);

    switch (onoff) {
    case DEVICE_INIT:
        plxPointer = pDev;
        fd = px_mouse_init();
        pDev->devicePrivate = (pointer)&queue;
        InitPointerDeviceStruct(plxPointer,
				mouse_mapping,
				3,
				plxGetMotionEvents,
				plxChangePointerControl);
#if defined(sun) || defined(interactive) || defined(motorola131)
        {
	    static long c1 = 1, c2 = 2;

            SetInputCheck(&c1, &c2);
        }
#else
        SetInputCheck(&queue->head, &queue->tail);
#endif
        pl_cursor_init();
        pl_cursor_report(1);        /* should this be 1 ? */
	for (i=0; i<screenInfo.numScreens; i++)
	    plxsetsavearea(screenInfo.screens[i], 16, 16);
        pl_cursor_color(1, 0);
        break;
    case DEVICE_ON:
        pDev->on = TRUE;
        pl_cursor_active(1);
        AddEnabledDevice(plx_wfd);
        break;
    case DEVICE_OFF:
        pDev->on = FALSE;
	for (i=0; i<screenInfo.numScreens; i++)
	    plxsetsavearea(screenInfo.screens[i], -1, -1);
        pl_cursor_active(0);
        RemoveEnabledDevice(plx_wfd);
        break;
    case DEVICE_CLOSE:
	for (i=0; i<screenInfo.numScreens; i++)
	    plxsetsavearea(screenInfo.screens[i], -1, -1);
        pl_cursor_active(0);
        break;
    }
    return Success;
}

void
plxChangePointerControl(pDevice, ctrl)
DevicePtr pDevice;
PtrCtrl *ctrl;
{
    ifdebug(5) printf("plxChangePointerControl() num,den,threshold=%d,%d,%d\n",
		      ctrl->num, ctrl->den, ctrl->threshold);

    pl_cursor_speed(min(ctrl->num / ctrl->den, 1), ctrl->threshold);
}

int
plxGetMotionEvents(buff, start, stop)
xTimecoord *buff;
CARD32 start, stop;
{
    ifdebug(5) printf("plxGetMotionEvents()\n");

    return (0);
}

Bool
plxSetCursorPosition(pScreen, hotX, hotY, generateEvent)
ScreenPtr pScreen;
unsigned int hotX, hotY;
Bool generateEvent;            /* do we generate a motion event? */
{
    ifdebug(5) printf("plxSetCursorPosition(), x,y=%d,%d\n", hotX, hotY);

    pl_cursor_position(PTX(hotX), PTY(hotY));

    if (generateEvent) {
        register DevicePtr pDev;
        xEvent motion;

        pDev = LookupPointerDevice();
        motion.u.keyButtonPointer.rootX = hotX;
        motion.u.keyButtonPointer.rootY = hotY;
        motion.u.keyButtonPointer.time = lastEventTime;
        motion.u.u.type = MotionNotify;
        (* pDev->processInputProc)(&motion, pDev, 1);
    }
    return TRUE;
}

Pixel
plxgetpixel(pScreen, r, g, b)
ScreenPtr pScreen;                /* Screen to allocate from */
u_short r, g, b;
{
    ColormapPtr pColormap =
	(ColormapPtr)LookupIDByType(pScreen->defColormap, RT_COLORMAP);
    Pixel pixelvalue;

    if (!pColormap)
        FatalError("plxgetpixel: Can't get default colormap\n");
    if (AllocColor(pColormap, &r, &g, &b, &pixelvalue, 0))
        FatalError("plxgetpixel: Can't alloc pixel value\n");
    return (pixelvalue);
}

Bool
plxDisplayCursor(pScreen, pCursor)
ScreenPtr pScreen;
CursorPtr pCursor;
{
    int i;
    unsigned short x, y;            /* cursor pattern location */
    Pixel fg, bg;

    ifdebug(5) printf("plxDisplayCursor() 0x%08x\n", pCursor);

    if (!plxPixmapUse(PIXMAP_READ, pCursor->devPriv[pScreen->myNum], &x, &y)) {
        ErrorF("plxRealizeCursor: CURSOR AREA NOT IN CACHE\n");
        return FALSE;
    }
    ifdebug(5) printf("\tx,y,w,h=%d,%d,%d,%d\n",
		      x, y, pCursor->bits->width, pCursor->bits->height);

    plxClipInvalidate(pScreen);

    pl_cursor_sizes(x, y, pCursor->bits->width, pCursor->bits->height,
		    pCursor->bits->xhot, pCursor->bits->xhot);
#ifdef notdef
    /* done in plxRealizeCursor by hand */
    pl_cursor_new(pCursor->bits->source, pCursor->bits->mask);
#endif

    fg = plxgetpixel(pScreen,
		     pCursor->foreRed,
		     pCursor->foreGreen,
		     pCursor->foreBlue);
    bg = plxgetpixel(pScreen,
		     pCursor->backRed,
		     pCursor->backGreen,
		     pCursor->backBlue);
    pl_cursor_color(fg, bg);

    pl_cursor_active(1);

    return TRUE;
}

void
plxPointerNonInterestBox(pScreen, pBox)
ScreenPtr pScreen;
BoxPtr pBox;
{
    ifdebug(5) printf("plxPointerNonInterestBox(), %d,%d,%d,%d\n",
		    pBox->x1, pBox->y1, pBox->x2, pBox->y2);

    pl_cursor_window(
        0,
        PTX(min(pBox->x1, pBox->x2)),
        PTY(max(pBox->y1, pBox->y2)),
        PTX(max(pBox->x1, pBox->x2)),
        PTY(min(pBox->y1, pBox->y2)));
}

void
plxConstrainCursor(pScreen, pBox)
ScreenPtr pScreen;
BoxPtr pBox;
{
    ifdebug(5) printf("plxConstrainCursor(), %d,%d,%d,%d\n",
                pBox->x1, pBox->y1, pBox->x2, pBox->y2);

    pl_cursor_constrain(
        PTX(min(pBox->x1, pBox->x2)),
        PTY(max(pBox->y1, pBox->y2)),
        PTX(max(pBox->x1, pBox->x2)),
        PTY(min(pBox->y1, pBox->y2)));
}

void
plxCursorLimits(pScreen, pCursor, pHotBox, pBox)
ScreenPtr pScreen;
CursorPtr pCursor;
BoxPtr pHotBox;
BoxPtr pBox;                /* return value */
{
    pBox->x1 = max(pHotBox->x1, 0);
    pBox->y1 = max(pHotBox->y1, 0);
    pBox->x2 = min(pHotBox->x2, 1279);
    pBox->y2 = min(pHotBox->y2, 1023);

    ifdebug(5) printf("plxCursorLimits(), %d,%d,%d,%d\n",
                pBox->x1, pBox->y1, pBox->x2, pBox->y2);
}

plxsetsavearea(pScr, xsize, ysize)
    ScreenPtr	pScr;
{
    static plxCache *savearea = (plxCache *)0;
    static int oldxsize = 0, oldysize = 0;

    plxClipInvalidate(pScr);

    if (xsize == -1) {
        /* closing down cursor */
        if (savearea) {
            pl_cache_free(savearea, 0);
        }
        oldxsize = 0; oldysize = 0;
        savearea = (plxCache *)0;
        return;
    }
    if ((oldxsize >= xsize) && (oldysize >= ysize))
        return;

    if (savearea) {
        pl_cache_free(savearea, 0);
    }

    savearea = pl_cache_find(xsize, ysize);
    if (!savearea) {
        FatalError("plxMouse: no save area for cursor\n");
        return;
    }
    oldxsize = xsize;
    oldysize = ysize;
    pl_cache_lock(savearea);
    pl_cursor_savearea(savearea->x, savearea->y);
}
