package TTTGame;

use warnings;
use strict;

use TTT;

use POE;
use POE::Session;

sub new
{
	my $proto = shift;
	my $class = ref($proto) || $proto;
	my $self = {};
	$self->{WHO}		= shift;
	$self->{PLAY_AS}	= -1 * shift;
	$self->{BOARD}		= TTT->new;
	bless($self,$class);

	$self->{SESSION}	= POE::Session->create(
		object_states	=>	[
			$self	=>	[qw(_start ttt_message update)]
			]
	);
	return $self;
}

sub _start
{
	my ($kernel,$self) = @_[KERNEL,OBJECT];
	$self->{KERNEL} = $kernel;
	$self->{BOARD}->newGame;
	$kernel->alias_set($self->{WHO});
	$self->sendMessage("Accept");
	$kernel->yield("update");
}

sub update
{
	my ($kernel,$self) = @_[KERNEL,OBJECT];
	my $board = $self->{BOARD};
	if($board->player == $self->{PLAY_AS})
	{
		my ($row,$col) = $board->moveAI;
		$self->sendMessage("Move","$row,$col");
		$self->move($row,$col);
	}
}

sub ttt_message
{
	my ($kernel,$self,$type,$msg) = @_[KERNEL,OBJECT,ARG0,ARG1];
	if($type eq "Cancel" || $type eq "End Game")
	{
		#FIXME:	Any pending updates or what have you will still get processed
		$self->endGame;
	}
	elsif($type eq "Move")
	{
		if($msg =~ /(\d),(\d)/)
		{
			my ($row,$col) = ($1,$2);
			$self->move($1,$2);
			$kernel->yield("update");
		}
		else
		{
			print "Bad Move: $msg\n";
		}
	}
}

sub sendMessage
{
	my($self,$type,$msg) = @_;
	$msg ||= "";
	$self->{KERNEL}->post("TOC","send_im",$self->{WHO},
											"[TTT/$type]:$msg");
}

sub move
{
	my ($self,$row,$col) = @_;
	my $board = $self->{BOARD};
	if($board->move($row,$col))
	{
		if(!$board->player)
		{
			$self->endGame;
			print "Game versus ", $self->{WHO}, " ended: ", $board->winner, "\n";
		}
	}
}

sub session
{
	my $self = shift;
	return $self->{SESSION};
}

sub endGame
{
	my $self = shift;
	$self->{KERNEL}->post("TOC","game_over",$self->{WHO});
	$self->{KERNEL}->alias_remove($self->{WHO});
}

1;
