;******************************************************************************
;* This file contains  the macros of 10 bit ADC library module for 
;* polled option
;******************************************************************************
;*File name:      ADCPol.inc
;*Dependencies:   ADCPol.asm
;*Processors:     PIC18                          
;*Assembler:      MPASMWIN 02.70.02 or higher
;*Linker:         MPLINK 2.33.00 or Higher
;*Company:        Microchip Technology, Inc.
;*
;* Software License Agreement
;*
;* The software supplied herewith by Microchip Technology Incorporated
;* (the "Company") for its PICmicro Microcontroller is intended and
;* supplied to you, the Company's customer, for use solely and
;* exclusively on Microchip PICmicro Microcontroller products. The
;* software is owned by the Company and/or its supplier, and is
;* protected under applicable copyright laws. All rights are reserved.
;* Any use in violation of the foregoing restrictions may subject the
;* user to criminal sanctions under applicable laws, as well as to
;* civil liability for the breach of the terms and conditions of this
;* license.
;*
;* THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES,
;* WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED
;* TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
;* PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT,
;* IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR
;* CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
;*
;*
;*
;* Author               Date            Comment
;*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;* B.K. Anantha Ramu    Mar 12, 2003    Initial Release (V1.0)
;* 
;********************************************************************/
#ifndef __ADCPol_INC
    #define __ADCPol_INC                ;Check if inc file already included

    #include <ADCPol.def>               ;This file is created by MpAM, with 
                                        ;user entered options


;------------------------------------------------------------------------------
                                        ;ADCPol_Source to be defined where the 
                                        ;variables are defined. 
    IFNDEF ADCPol_Source
        #define A2D_10BIT_MODULE        ;With this definition, availability of
                                        ;module features will be known.
        #define _GEN_MODULE_ERROR       ;If ADC module is not available this 
                                        ;enables to generate error.
        #include <P18xxx.INC>           ;This defines module features for 
                                        ;different processors.

        EXTERN vADCPolChannelNumber_A
        EXTERN _ADCPolChannelSelect 
        EXTERN ADCPolAcquisitionTime
    ELSE
        GLOBAL vADCPolChannelNumber_A
        GLOBAL _ADCPolChannelSelect
        GLOBAL ADCPolAcquisitionTime             
    ENDIF

;------------------------------------------------------------------------------
                                        ;The following lines extracts the 
                                        ;features of the processor used
                                        ;from P18xxx.inc file.
    IFDEF _A2D_10BIT_1CHANNEL_MODULE
        #define _ADCPOL_CHANNELS D'1'
    ENDIF

    IFDEF _A2D_10BIT_2CHANNEL_MODULE
        #define _ADCPOL_CHANNELS D'2'
    ENDIF

    IFDEF _A2D_10BIT_3CHANNEL_MODULE
        #define _ADCPOL_CHANNELS D'3'
    ENDIF

    IFDEF _A2D_10BIT_4CHANNEL_MODULE
        #define _ADCPOL_CHANNELS D'4'
    ENDIF

    IFDEF _A2D_10BIT_5CHANNEL_MODULE
        #define _ADCPOL_CHANNELS D'5'
    ENDIF

    IFDEF _A2D_10BIT_6CHANNEL_MODULE
        #define _ADCPOL_CHANNELS D'6'
    ENDIF

    IFDEF _A2D_10BIT_7CHANNEL_MODULE
        #define _ADCPOL_CHANNELS D'7'
    ENDIF

    IFDEF _A2D_10BIT_8CHANNEL_MODULE
        #define _ADCPOL_CHANNELS D'8'
    ENDIF

    IFDEF _A2D_10BIT_9CHANNEL_MODULE
        #define _ADCPOL_CHANNELS D'9'
    ENDIF

    IFDEF _A2D_10BIT_10CHANNEL_MODULE
        #define _ADCPOL_CHANNELS D'10'
    ENDIF

    IFDEF _A2D_10BIT_11CHANNEL_MODULE
        #define _ADCPOL_CHANNELS D'11'
    ENDIF

    IFDEF _A2D_10BIT_12CHANNEL_MODULE
        #define _ADCPOL_CHANNELS D'12'
    ENDIF

    IFDEF _A2D_10BIT_13CHANNEL_MODULE
        #define _ADCPOL_CHANNELS D'13'
    ENDIF

    IFDEF _A2D_10BIT_14CHANNEL_MODULE
        #define _ADCPOL_CHANNELS D'14'
    ENDIF

    IFDEF _A2D_10BIT_15CHANNEL_MODULE
        #define _ADCPOL_CHANNELS D'15'
    ENDIF

    IFDEF _A2D_10BIT_16CHANNEL_MODULE
        #define _ADCPOL_CHANNELS D'16'
    ENDIF

    IFDEF _A2D_10BIT_4REGISTER_MODULE
        #define _ADCPOL_PIC181          ;10 bit ADC with ADCON0,
    ENDIF                               ;ADCON1 registers. No ADCON2 register
        
    IFDEF _A2D_10BIT_5REGISTER_MODULE
        #define _ADCPOL_PIC182          ;10 bit ADC with
    ENDIF                               ;ADCON0,ADCON1 & ADCON2 register
;------------------------------------------------------------------------------
;The following lines defines the constants which are used as input arguments for
;the macro mADCPolInit.
;Constants for ADC port configuration names
    CONSTANT ADCPORTCONFIG0 = D'0'
    CONSTANT ADCPORTCONFIG1 = D'1'
    CONSTANT ADCPORTCONFIG2 = D'2'
    CONSTANT ADCPORTCONFIG3 = D'3'
    CONSTANT ADCPORTCONFIG4 = D'4'
    CONSTANT ADCPORTCONFIG5 = D'5'
    CONSTANT ADCPORTCONFIG6 = D'6'
    CONSTANT ADCPORTCONFIG7 = D'7'
    CONSTANT ADCPORTCONFIG8 = D'8'
    CONSTANT ADCPORTCONFIG9 = D'9'
    CONSTANT ADCPORTCONFIG10 = D'10'
    CONSTANT ADCPORTCONFIG11 = D'11'
    CONSTANT ADCPORTCONFIG12 = D'12'
    CONSTANT ADCPORTCONFIG13 = D'13'
    CONSTANT ADCPORTCONFIG14 = D'14'
;Constants for ADC reference voltage configuration names
    CONSTANT ADCREFERENCECONFIG0  = D'0'
    CONSTANT ADCREFERENCECONFIG1  = D'1'
    CONSTANT ADCREFERENCECONFIG2  = D'2'
    CONSTANT ADCREFERENCECONFIG3  = D'3'                
;****************************************************************************
; Macro:        _mADCPolADCON1set
;
; Overview:     Sets bits of ADCON1 reg as per user options
;
; Input:        Definitions from ADCPol.DEF, processor classification
;                ie: definitions _ADCPOL_PIC181, _ADCPOL_PIC182 etc. 
;               _ADCPOL_PIC181: 10 bit ADC with ADCON0 & ADCON1 registers. No ADCON2
;                        register
;               _ADCPOL_PIC182: 10 bit ADC with ADCON0, ADCON1 & ADCON2 registers
;
; Output:       ADCON1
;
; Side Effects: WREG changes
;****************************************************************************
_mADCPolADCON1set MACRO
    IFDEF _ADCPOL_PIC181 
        IFDEF _RIGHT
_ADCPOL_RESULTFORMAT=B'10000000'
        ELSE
_ADCPOL_RESULTFORMAT=B'00000000'
        ENDIF
        IFDEF _FOSC2
_ADS2=B'00000000'
_ADCPOL_CLOCK=B'00000000'
        ENDIF
        IFDEF _FOSC8
_ADS2=B'00000000'
_ADCPOL_CLOCK=B'01000000'
        ENDIF
        IFDEF _FOSC32
_ADS2=B'00000000'
_ADCPOL_CLOCK=B'10000000'
        ENDIF
        IFDEF _RCCLK
_ADS2=B'01000000'
_ADCPOL_CLOCK=B'11000000'
        ENDIF
        IFDEF _FOSC4
_ADS2=B'01000000'
_ADCPOL_CLOCK=B'00000000'
        ENDIF
        IFDEF _FOSC16
_ADS2=B'01000000'
_ADCPOL_CLOCK=B'01000000'
        ENDIF
        IFDEF _FOSC64
_ADS2=B'01000000'
_ADCPOL_CLOCK=B'10000000'
        ENDIF
        IF _port_config_name<D'6'
_ADCPOL_PORTCONFIG=_port_config_name
        ELSE
_ADCPOL_PORTCONFIG=_port_config_name+2
        ENDIF 

_ADCPOL_ADCON1VALUE=_ADCPOL_RESULTFORMAT|_ADS2|_ADCPOL_PORTCONFIG
        movlw   _ADCPOL_ADCON1VALUE
        movwf   ADCON1
    ENDIF
    IFDEF _ADCPOL_PIC182
_ADCPOL_PORTCONFIG=_port_config_name
_ADCPOL_REFERENCECONFIG=D'16'*_ref_config_name  ;ADC reference configuration bits occupy
                                                ;positions 4 & 5. Hence they are shifted
                                                ;by 4 positions.      
_ADCPOL_ADCON1VALUE=_ADCPOL_REFERENCECONFIG|_ADCPOL_PORTCONFIG
        movlw   _ADCPOL_ADCON1VALUE
        movwf   ADCON1
    ENDIF
    ENDM
;****************************************************************************
; Macro:        _mADCPolADCON2set
;
; Overview:     Sets ADCON2 bits as per user options
;               
;
; Input:        Definitions from ADCPol.DEF,processor classification
;               ie: definitions _ADCPOL_PIC181, _ADCPOL_PIC182 etc.
;               _ADCPOL_PIC181: 10 bit ADC with ADCON0 & ADCON1 registers. No ADCON2
;                        register
;               _ADCPOL_PIC182: 10 bit ADC with ADCON0, ADCON1 & ADCON2 registers 
;
; Output:       ADCON2
;
; Side Effects:  WREG changes
;****************************************************************************
_mADCPolADCON2set MACRO
    IFDEF _ADCPOL_PIC182 

        IFDEF _RIGHT
_ADCPOL_RESULTFORMAT=B'10000000'
        ELSE
_ADCPOL_RESULTFORMAT=B'00000000'
        ENDIF
        IFDEF _FOSC2
_ADCPOL_CLOCK=B'00000000'
        ENDIF
        IFDEF _FOSC8
_ADCPOL_CLOCK=B'00000001'
        ENDIF
        IFDEF _FOSC32
_ADCPOL_CLOCK=B'00000010'
        ENDIF
        IFDEF _RCCLK
_ADCPOL_CLOCK=B'00000011'
        ENDIF
        IFDEF _FOSC4
_ADCPOL_CLOCK=B'00000100'
        ENDIF
        IFDEF _FOSC16
_ADCPOL_CLOCK=B'00000101'
        ENDIF
        IFDEF _FOSC64
_ADCPOL_CLOCK=B'00000110'
        ENDIF
_ADCPOL_ADCON2VALUE=_ADCPOL_RESULTFORMAT|_ADCPOL_CLOCK
        movlw   _ADCPOL_ADCON2VALUE
        movwf   ADCON2
    ENDIF
    ENDM
;****************************************************************************
; Macro:        _mADCPolADCON0set
;
; Overview:     Sets ADCON0 bits as per user options
;               
;
; Input:        Definitions from ADCPol.DEF,processor classification
;               ie: definitions _ADCPOL_PIC181, _ADCPOL_PIC182 etc.
;               _ADCPOL_PIC181: 10 bit ADC with ADCON0 & ADCON1 registers. No ADCON2
;                        register
;               _ADCPOL_PIC182: 10 bit ADC with ADCON0, ADCON1 & ADCON2 registers 
;
; Output:       ADCON0
;
; Side Effects: WREG changes
;****************************************************************************
_mADCPolADCON0set MACRO
    IFDEF _ADCPOL_PIC181 
        IFDEF _FOSC2
_ADCPOL_CLOCK=B'00000000'
        ENDIF
        IFDEF _FOSC8
_ADCPOL_CLOCK=B'01000000'
        ENDIF
        IFDEF _FOSC32
_ADCPOL_CLOCK=B'10000000'
        ENDIF
        IFDEF _RCCLK
_ADCPOL_CLOCK=B'11000000'
        ENDIF
        IFDEF _FOSC4
_ADCPOL_CLOCK=B'00000000'
        ENDIF
        IFDEF _FOSC16
_ADCPOL_CLOCK=B'01000000'
        ENDIF
        IFDEF _FOSC64
_ADCPOL_CLOCK=B'10000000'
        ENDIF

_ADCPOL_CHANNEL=B'00000000'
          

_ADCPOL_ON=1
_ADCPOL_START=0
_ADCPOL_ADCON0VALUE=_ADCPOL_CLOCK|_ADCPOL_CHANNEL|_ADCPOL_START|_ADCPOL_ON
        movlw   _ADCPOL_ADCON0VALUE
        movwf   ADCON0
    ENDIF

    IFDEF _ADCPOL_PIC182
_ADCPOL_CHANNEL=B'00000000'

_ADCPOL_START=B'00000000'
_ADCPOL_ON=B'00000001'

_ADCPOL_ADCON0VALUE=_ADCPOL_CHANNEL|_ADCPOL_START|_ADCPOL_ON
        movlw   _ADCPOL_ADCON0VALUE
        movwf   ADCON0
    ENDIF
    ENDM
;****************************************************************************
; Macro:        mADCPolReadHigh
;
; Overview:     This reads the high byte of ADC result
;
; Input:        None
;
; Output:       WREG
;
; Side Effects: None
;******************************************************************************

mADCPolReadHigh MACRO

        movf    ADRESH,W
        ENDM

;****************************************************************************
; Macro:        mADCPolReadLow
;
; Overview:     This reads the low byte of ADC result
;
; Input:        None
;
; Output:       WREG
;
; Side Effects: None
;******************************************************************************


mADCPolReadLow MACRO
        movf    ADRESL,W
        ENDM


;****************************************************************************
; Macro:        mADCPolInit 
;
; Overview:     Configures ADC as per user options.
;               This sets channel 0 as default ADC channel.
;                If user wants to use a different channel, he can select
;                the required channel by invoking macro mADCPolChannelSelect.
;        
;
; Input:        _port_config_name: The port configuration name is used to define
;                analog & digital ports.
;                _ref_config_name: The ADC reference voltage configuration name
;                is used to define ADC reference voltage source & it is required only 
;               for _ADCPOL_PIC182 processors.
;               Definitions from ADCPol.DEF & p18xxx.INC
;               _ADCPOL_PIC181: 10 bit ADC with ADCON0 & ADCON1 registers. No ADCON2
;               register
;               _ADCPOL_PIC182: 10 bit ADC with ADCON0, ADCON1 & ADCON2 registers 
;
; Output:       ADCON0,ADCON1,ADCON2
;
; Side Effects:  WREG changes
;****************************************************************************
    IFDEF _ADCPOL_PIC181
mADCPolInit MACRO _port_config_name
        IF (_port_config_name >=0 && _port_config_name <=D'13')

            _mADCPolADCON2set ; sets ADCON2(if existing) reg bits as per user options & processor         
            _mADCPolADCON1set ; sets ADCON1 reg bits as per user options & processor 
            _mADCPolADCON0set ; sets ADCON0 reg bits as per user options & processor 
        ELSE
            MESSG "WARNING: Argument(Port configuration name) for macro mADCPolInit is not correct"
        ENDIF
        ENDM        
    ENDIF
    IFDEF _ADCPOL_PIC182
mADCPolInit MACRO _port_config_name,_ref_config_name
        IF (_port_config_name<0||_port_config_name>D'14')
            MESSG "WARNING: Argument(Port configuration name) for macro mADCPolInit is not correct"
        EXITM
        ENDIF
        IF (_ref_config_name<0||_ref_config_name>D'3')
            MESSG "WARNING: Argument(Ref configuration name) for macro mADCPolInit is not correct"
        EXITM
        ENDIF

        _mADCPolADCON2set ; sets ADCON2(if existing) reg bits as per user options & processor         
        _mADCPolADCON1set ; sets ADCON1 reg bits as per user options & processor 
        _mADCPolADCON0set ; sets ADCON0 reg bits as per user options & processor
        ENDM 
    ENDIF



;*****************************************************************************
; Macro:        mADCPolStart
;
; Overview:     Starts AD conversion by setting GO bit of ADCON0. 
;              
;
; Input:        None
;
; Output:       None
;                            
; Side Effects: None
;*****************************************************************************
mADCPolStart MACRO
        bsf     ADCON0,GO
        ENDM

;*****************************************************************************
; Macro:        mADCPolDisable
;
; Overview:     Switches off the ADC
;               
; Input:        None
;
; Output:       None
;                            
; Side Effects: None
;*****************************************************************************
mADCPolDisable MACRO
        bcf     ADCON0,0  
        ENDM 
;*****************************************************************************
; Macro:        mADCPolIsBusy
;
; Overview:     checks GO bit of ADCON0
;               
; Input:        None
;
; Output:       WREG contains 0 if ADC not busy, 1 if ADC is busy 
;                            
; Side Effects: None
;*****************************************************************************
mADCPolIsBusy   MACRO
        movlw   0
        btfsc   ADCON0,GO
        movlw   1
        ENDM
;*****************************************************************************
; Macro:        mADCPolChannelSelect
;
; Overview:     This macro selects the ADC channel.   
;               
; Input:        Channel number
;
; Output:       ADCON0    
;                            
; Side Effects: WREG changes
;*****************************************************************************
mADCPolChannelSelect   MACRO channel_number
    IF channel_number<_ADCPOL_CHANNELS
        movlw   channel_number
        call    _ADCPolChannelSelect
    ELSE
        MESSG "WARNING: The  processor does not have the selected ADC channel"
    ENDIF
    ENDM
;*****************************************************************************
#endif                                  ;For inc file check.

