import sys
import os
import os.path
import getopt
import time

sys.argv = sys.argv[1:]

allOpenMode = False
master = False
datafile = 'hexdata.in'
openedfile = 'opened.in'
locktime  = 15 * 60              # 15 minutes lock
curtime   = int(time.time())     # current time

opts, args = getopt.getopt(sys.argv, 'mad:o:l:c:h')
   
for opt, arg in opts:
    if opt == '-a':
        print >>sys.stderr, "All open."
        allOpenMode = True
    elif opt == '-m':
        master = True
    elif opt == '-d':
        datafile = arg
    elif opt == '-o':
        openedfile = arg
    elif opt == '-l':
        locktime = int(arg)
    elif opt == '-c':
        curtime = int(arg)
    elif opt == '-h':
        print '''
Usage: python science.py [-a] [-d datafile] [-o openedfile] [-l locktime] [-c curtime] [-h]

  -a             Show the entire grid for debugging.
  -d datafile    Use an alternate data file for the grid.  [default: hexdata.in]
  -o openedfile  Use an alternate opened file for the grid.  [default: opened.in]
  -l locktime    Set how long it takes before hexes are open.  [default: 15 min]
  -c curtime     Set the current time.  [default: duh]
  -h             Display this help and exit.
        '''
        sys.exit(0)
    else:
        print >>sys.stderr, "Command line flag unknown, bailing"
        sys.exit(1)


print open(os.path.join(os.path.dirname(__file__),
                        'header.html')).read()

cost_by_dist = [0, 1, 3, 5, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7]

def hex_dist(x,y):
    dist = 0
    while x != 0 or y != 0:
        dist += 1
        if x > 0 and y < 0:
            x -= 1
            y += 1
        elif x < 0 and y > 0:
            x += 1
            y -= 1
        elif x > 0:
            x -= 1
        elif y > 0:
            y -= 1
        elif x < 0:
            x += 1
        elif y < 0:
            y += 1
    return dist



class Hex:
    def __init__(self, x, y, color, cost, code, text):
        self.x = x
        self.y = y
        self.top = -106 * x - 53 * y
        self.left = 92 * y
	self.text = text
	self.color = color
	self.cost = cost
        if self.cost == 0:
            self.cost = cost_by_dist[hex_dist(x,y)]
        self.code = code
        self.dist = 1000000   # big
        self.who = ''

        if self.color == 'blue' or self.color == 'purple':
            self.textColor = '#fff'
        else:
            self.textColor = '#000'

f = open(datafile)
hexes = []
hexMap = {}
hexMapByCode = {}

def dfs(x, y, d):
    if (x,y) not in hexMap:
        return
    
    h = hexMap[(x,y)]
    if h.dist <= d:
        return

    h.dist = d
    dfs(x+1, y, d+1)
    dfs(x-1, y, d+1)
    dfs(x, y+1, d+1)
    dfs(x, y-1, d+1)
    dfs(x+1, y-1, d+1)
    dfs(x-1, y+1, d+1)

for line in f:
    parts = line.strip().split()
    if len(parts) < 6:
        continue

    x, y = int(parts[0]), int(parts[1])
    h = Hex(x, y,
            parts[2], int(parts[3]),
            parts[4],
            " ".join(parts[5:]))
    if parts[4] in hexMapByCode:
        sys.stderr.write("duplicate code: %s\n" % parts[4])
    hexMapByCode[parts[4]] = h
    hexMap[(x,y)] = h
    hexes.append(h)

g = open(openedfile)
for line in g:
    line = line.strip()
    if len(line) == 0: continue
    p = line.split()

    if p[0] in hexMapByCode:
        h = hexMapByCode[p[0]]
        a, b = h.x, h.y

        dist = 0
        delta = curtime - int(p[1])
        if delta < locktime:
            dist = 1
            h.who = " ".join(p[2:])

        dfs(a,b,dist)

# fix up all of the hexes
minTop = 0
minLeft = 0
for h in hexes:
    minTop  = min(minTop, h.top)
    minLeft = min(minLeft, h.left)

for h in hexes:
    h.top -= minTop
    h.left -= minLeft

for h in hexes:
    if h.dist == 0 or allOpenMode:
        # entirely open
        print '<img src="hex2.png" height="108" style="position: absolute; top: %dpx; left: %dpx; z-index: 5;" />' % (h.top, h.left)
#        print '<img src="hex2_%s.png" height="108" style="position: absolute; top: %dpx; left: %dpx; z-index: 5;" />' % (h.color, h.top, h.left)

        print '<div class="code" style="top: %dpx; left: %dpx; color: %s;">%s</div>' % (h.top + 5, h.left + 22, 'black', h.code)
        print '<div class="opened" style="top: %dpx; left: %dpx; color: %s;"><div>%s</div></div>' % (h.top + 15, h.left + 22, 'black', h.text)
        
        if allOpenMode:
            print '<div class="cost" style="top: %dpx; left: %dpx; color: %s;">%d</div>' % (h.top + 85, h.left + 22, 'black', h.cost)

    elif h.dist > 2:
        # closed, not close enough to see anything
        print '<img src="hex2.png" height="108" style="position: absolute; top: %dpx; left: %dpx; z-index: 5;" />' % (h.top, h.left)
        print '<div class="closed" style="top: %dpx; left: %dpx; color: %s;">%d</div>' % (h.top + 34, h.left + 22, 'black', h.cost)

    else:
        # at least close enough to see color
        print '<img src="hex2_%s.png" height="108" style="position: absolute; top: %dpx; left: %dpx; z-index: 5;" />' % (h.color, h.top, h.left)
        if master: print "<a href='javascript:do_open(\"%s\")'>" % (h.code,)

        if h.dist == 1 or master:
            if h.who != '':
                # still locked but show the discoverer
                print '<div class="code" style="top: %dpx; left: %dpx; color: %s;">%s</div>' % (h.top + 5, h.left + 22, h.textColor, h.code)
                print '<div class="opened" style="top: %dpx; left: %dpx; color: %s;"><div>%s</div></div>' % (h.top + 25, h.left + 22, h.textColor, h.text)
                print '<div class="cost" style="top: %dpx; left: %dpx; color: %s;">%d</div>' % (h.top + 20, h.left + 22, h.textColor, h.cost)
                print '<div class="code" style="top: %dpx; left: %dpx; color: %s;">%s</div>' % (h.top + 85, h.left + 22, h.textColor, h.who)
                pass
            else:
                # actually far enough away to not see
                print '<div class="code" style="top: %dpx; left: %dpx; color: %s;">%s</div>' % (h.top + 5, h.left + 22, h.textColor, h.code)
                print '<div class="opened" style="top: %dpx; left: %dpx; color: %s;"><div>%s</div></div>' % (h.top + 15, h.left + 22, h.textColor, h.text)
                print '<div class="cost" style="top: %dpx; left: %dpx; color: %s;">%d</div>' % (h.top + 85, h.left + 22, h.textColor, h.cost)
        else:
            print '<div class="closed" style="top: %dpx; left: %dpx; color: %s;">%d</div>' % (h.top + 34, h.left + 22, h.textColor, h.cost)
        if master: print "</a>"

print "</body></html>\n";
