package antichess;

/**
 * The GamePlayer interface allows for communication between 
 * the contoller and objects that generate moves such as the view
 * or the AI.
 * 
 * @author nlharr
 *
 */


public interface GamePlayer {
	

	
	
	
	/**
	 * Asks the player for a move, if the player has a move the move
	 * is returned, if the player doesn't, null is returned immediately
	 * Once this GamePlayer is able to return a valid move it calls notifyControllerHasMove()
	 * on the controller.  
	 */
	public Move getMove(GameController controller);
	
	/**
	 * 
	 * @return Player for this
	 */
	public Player getPlayerType();
	
}
