// -*- mode: java; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*-
// $Id$

package antichess;

/**
 * <p> A <tt>Move</tt> represents a a single move by one player in a
 * game on a <tt>Board</tt>. A Move contains at least the piece taking
 * action in the move; It is expected it will be subclassed to contain
 * more information about specific types of moves for different games.
 * </p>
 *
 * <p> <tt>Move</tt> is immutable, and it is expected that subclasses
 * will also be. </p>
 *
 * @specfield piece  // The piece taking some action
 **/
public abstract class Move
{
    final Piece piece;

    protected Move(Piece piece) {
        this.piece = piece;
    }

    /**
     * @return this.piece
     */
    public Piece getPiece() {
        return piece;
    }
    
    /**
     * @return the player that made this Move
     */
    public Player getPlayer() {
        return piece.getPlayer();
    }
}
