// -*- mode: java; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*-

package antichess;

/**
 * PieceType represents an abstract piece type -- a pawn, rook, etc. A
 * PieceType is capable of returning a MoveGenerator indicating the
 * types of movement a piece is capable of, and a textual description
 * of the piece type.
 * 
 * @specfield movement : MoveGenerator // Indicates the types of legal moves for this piece
 * @specfield name : String            // A String indicating the name of this piece type
 **/
public interface PieceType
{
    /**
     * @return this.movement
     **/
    public MoveGenerator getMovement();

    /**
     * @return this.name
     **/
    public String getName();
}
