package antichess;

public class TextUI {

	/**
	 * main is an interactive loop between a human and a computer. <p>  

     The TextUI should wait for user input.  Valid user input is in the
     form of the commands shown in the requires clause. Parameters to
     commands are enclosed in square brackets.  Outputs as a result of a
     command should be terminated with a newline. If multiple lines are
     output, the last line should also be terminated with a new line.  <p>

     When main is executed with no command-line arguments,
     supported commands are:
	 <dl>

     <dt><code><b>StartNewGame</b> [player] [time] [player] [time]</code></dt>
     <dd>Each player is denoted as "human" or "computer."  The times
       specified are the initial "time remaining" for the player, in
       milliseconds.  If a time argument is zero, then the playing
       time is unlimited.  The first player is white and the second player
       is black.  For example, <code>StartNewGame computer 60000 human
       180000</code> should start a new game with the computer playing
       as white and the human playing as black.  The computer will
       have 1 minute to make all of its moves, and the human will have
       3 minutes.  The system should output <code>New game
       started</code> on its own line.</dd>

     <dt><code><b>SaveGame</b> [filename]</code></dt>

     <dd>The system should save the game to the given filename and
       report <code>Game saved</code> on its own line.</dd>

     <dt><code><b>LoadGame</b> [filename]</code></dt>
     <dd>The system should load the game from the given filename. Once
       the files is loaded, print <code>Game loaded</code> on its own
       line. You should report <code>Corrupt file</code> if the file
       does not have a correct format.  We will not require you to
       determine if the board is legal.  If no game is currently in
       progress from a previously executed <b>StartNewGame</b> or
       <b>LoadGame</b> command, then assume a human-human game.</dd>

     <dt><code><b>GetNextMove</b></code></dt>
     <dd>If this command is called during a human player's turn, the
       command prints <code>Human turn</code> on its own line.  If
       this command is called during a machine player's turn, print on
       its own line the next move it believes to be the best.  The
       printed move should be in the "standard string format"
       described in the assignment.  The time taken to compute the
       move should be subtracted from the computer player's game
       clock.  If called repeatedly, this should return the same move
       over and over without further decrementing the computer's time
       remaining.</dd>

     <dt><code><b>MakeNextMove</b></code></dt>
     <dd>If it is a human player's turn, the system should print
       <code>Please specify human move</code> on its own line.  If it
       is the computer player's turn, and <code>GetNextMove</code> has
       not yet been called on this turn, then the system should print
       <code>First GetNextMove</code>.  Otherwise, the system performs
       the <code>move</code> that <code><b>GetNextMove</b></code>

       would return.  </dd>

     <dt><code><b>MakeMove</b> [move] [time]</code></dt>
     <dd>Perform the move specified by the <code>move</code> string,
       in the "standard string format" described in the assignment.
       The time parameter is specified in milliseconds.  <i>This
       command should only be used by a Human Player. If it is used
       during a computer player's turn, nothing will happen to the
       game state and no response should be printed.</i> If the move
       is not legal, the system should print, on its own line,
       <code>Illegal move</code> and not perform the move.  If the
       move is legal, the system should perform the move, decrement
       the player's time by the amount given, and print the move
       performed, in proper format, on its own line.  If the player's
       time is unlimited, then the time argument is ignored (but must
       still be present).</dd>

     <dt><code><b>PrintBoard</b></code></dt>
     <dd>System should print the current "state" of the game to the
       screen using the same format as if it were being saved to a
       file.  The output should end with (at least one) a newline.</dd>

     <dt><code><b>IsLegalMove</b> [move]</code></dt>
     <dd>System should print, on its own line, either "legal" or
       "illegal" to specify if the <code>move</code> is a legal next
       move.</dd>

     <dt><code><b>PrintAllMoves</b></code></dt>
     <dd>System should, in alphanumeric order, print all legal moves
       for the next player.  Each move should each appear on its own
       line.</dd>

     <dt><code><b>GetTime</b> [player]</code></dt>
     <dd>On its own line, the system should print the time remaining
       in milliseconds for the player specified. For example
       <code><b>GetTime</b> white</code>, should print
       <code>3000</code> to indicate 3 seconds left for the white
       player.  If the time for the player is unlimited, the system
       should print "unlimited".</dd>

     <dt><code><b>QuitGame</b></code></dt>
     <dd>Prints (on its own line) <code>Exiting game</code> and
       terminates the present game and
       application. <code><b>QuitGame</b></code> cannot be the first
       command.</dd>

     </dl>

     <p>For each command other than <code>GetNextMove</code> the
     specified behavior completes within 10 seconds.
     <code>GetNextMove</code> may take no more than ten seconds more
     than the player's time remaining to complete; if it exceeds the
     player's time remaining it must report a human victory in the
     format described below.  </p>

     <p>If the user input does not match one of these commands, output
     <code>Input error</code> alone on one line. Also, the first valid
     command entered must be either <code><b>StartNewGame</b></code>

     or <code><b>LoadGame</b></code>, or else <code>Input error</code>
     is printed.</p>

     <p>When a player has won the game, output on its own line:
     <code>[Player color] Player has won</code>. For example, if the
     black player has won, output: <code>Black Player has won</code>.
     At this point, you can assume that the Antichess program has just
     been started and therefore, you only need to support the subset of
     commands.</p>

     <p>The behavior of the TextUI is unspecified when main is run
     with one or more command-line arguments.</p>
	 * @param args
	 */
	public static void main(String[] args) {
		throw new RuntimeException("TextUI unimplemented");
	}

}
