// -*- mode: java; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*-

package antichess.ai;

import antichess.*;

/**
 * <p>The <code>GameAI</code> class implements an abstract minimax AI
 * over a <code>Board</code>.</p>
 *
 * <p>Subclasses should extend <code>GameAI</code> and implement the
 * <code>boardValue</code> method to provide a static evaluation
 * heuristic for board states.</p>
 **/
public abstract class GameAI<M extends Move, B extends Board<M> >
{
	/**
	 * <p>
	 * Return a move computed by the AI for the given board, with the
	 * given amount of time remaining, in milliseconds.
	 * </p>
	 * <p>
	 * A time of 0 for either time means that player is untimed.
	 * </p>
	 * @param timeLeft : The time left on the current player's clock
	 * @param opponentTimeLeft : The time remaining on the other player's clock
	 */
	public abstract M findMove(B board, long timeLeft, long opponentTimeLeft);
}
