// -*- mode: java; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*-

package antichess.test;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import antichess.*;

/**
 * AllTests is a jUnit test suite containing all the automated
 * antichess tests
 **/
public class AllTests extends TestSuite
{
	public AllTests() {
		this("Antichess all-inclusive test suite");
	}

	public static Test suite() {
		return new AllTests();
	}

	public AllTests(String s) {
		super(s);

		addTestSuite(PieceTests.class);
		addTestSuite(MoveGeneratorTests.class);
		addTestSuite(ChessMoveTests.class);
		addTestSuite(MoveHistoryTests.class);
		addTestSuite(ChessBoardTests.class);
		addTestSuite(AntichessBoardTests.class);
		addTestSuite(GameReaderTests.class);
		addTestSuite(GameWriterTests.class);
		addTestSuite(GameDescriptorTests.class);
		addTestSuite(MachinePlayerTests.class);
	}
}

