/*****************************************************************************
 *
 * Microchip DeviceNet Stack (Explicit Messaging Connection Object Header)
 *
 *****************************************************************************
 * FileName:        conn1.h
 * Dependencies:    
 * Processor:       PIC18F with CAN
 * Compiler:       	C18 02.20.00 or higher
 * Linker:          MPLINK 03.40.00 or higher
 * Company:         Microchip Technology Incorporated
 *
 * Software License Agreement
 *
 * The software supplied herewith by Microchip Technology Incorporated
 * (the "Company") is intended and supplied to you, the Company's
 * customer, for use solely and exclusively with products manufactured
 * by the Company. 
 *
 * The software is owned by the Company and/or its supplier, and is 
 * protected under applicable copyright laws. All rights are reserved. 
 * Any use in violation of the foregoing restrictions may subject the 
 * user to criminal sanctions under applicable laws, as well as to 
 * civil liability for the breach of the terms and conditions of this 
 * license.
 *
 * THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES, 
 * WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED 
 * TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
 * PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT, 
 * IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR 
 * CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
 *
 *
 * This file contains Explicit messaging support for the Connection Object 
 * described in Section 5-4 and Chapter 7 of Volume 1 of the DeviceNet 
 * specification.
 * 
 *
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Ross Fosler			04/28/03	...	
 * 
 *****************************************************************************/


#ifndef	__CONN1_H__
#define	__CONN1_H__

/*********************************************************************
 * Connection related variables
 ********************************************************************/
extern CONN_EXPL 		uConn1;

extern unsigned char	uConn1RxBuffer[CONN_EXPLICIT_RX_SIZE];
extern unsigned char	uConn1TxBuffer[CONN_EXPLICIT_TX_SIZE];



/*********************************************************************
 * Function:        unsigned char _Conn1Create(void)
 *
 * PreCondition:    
 *
 * Input:       	none	
 *                  
 * Output:      	handle to connection
 *
 * Side Effects:    
 *
 * Overview:        Returns a handle to the connection 
 *
 * Note:            None
 ********************************************************************/
unsigned char _Conn1Create(void);


/*********************************************************************
 * Function:        unsigned char _Conn1Close(void)
 *
 * PreCondition:    
 *
 * Input:       	none		
 *                  
 * Output:      	status of the close
 *
 * Side Effects:    
 *
 * Overview:        Closes the specified connection 
 *
 * Note:            None
 ********************************************************************/
unsigned char _Conn1Close(void);


/*********************************************************************
 * Function:        void _Conn1TimerEvent(void)
 *
 * PreCondition:    
 *
 * Input:       	none		
 *                  
 * Output:      	none
 *
 * Side Effects:    
 *
 * Overview:        Update timer and process any timer events.
 *
 * Note:            None
 ********************************************************************/
void _Conn1TimerEvent(void);


/*********************************************************************
 * Function:        void _Conn1RxEvent(void)
 *
 * PreCondition:    
 *
 * Input:       	none	
 *                  
 * Output:      	none
 *
 * Side Effects:    
 *
 * Overview:        Process data for this connection.
 *
 * Note:            This event occures when data has been received
 *					for this connection instance.
 ********************************************************************/
void _Conn1RxEvent(void);

/*********************************************************************
 * Function:        void _Conn1TxOpenEvent(void)
 *
 * PreCondition:    none
 *
 * Input:       	none	
 *                  
 * Output:      	none
 *
 * Side Effects:    none
 *
 * Overview:        Process
 *
 * Note:            This event occurs when the buffer is available 
 *					for this connection instance to transmit.
 ********************************************************************/
void _Conn1TxOpenEvent(void);


/*********************************************************************
 * Function:        void _Conn1TxEvent(void)
 *
 * PreCondition:    
 *
 * Input:       	none
 *                  
 * Output:      	none
 *
 * Side Effects:    
 *
 * Overview:        Process data for this connection.
 *
 * Note:            This event occurs when the buffer has successfully
 *					placed the requested data on the bus.
 ********************************************************************/
void _Conn1TxEvent(void);


/*********************************************************************
 * Function:        unsigned char _Conn1ExplicitEvent(void)
 *
 * PreCondition:    
 *
 * Input:       	none	
 *                  
 * Output:      	status
 *
 * Side Effects:    
 *
 * Overview:        Handle explicit messaging
 *
 * Note:            None
 ********************************************************************/
unsigned char _Conn1ExplicitEvent(void);


/*********************************************************************
 * Function:        unsigned char _Conn1GetAttrib()
 *
 * PreCondition:    
 *
 * Input:       	none
 *                  
 * Output:      	status
 *
 * Side Effects:    
 *
 * Overview:        Handle explicit messaging
 *
 * Note:            None
 ********************************************************************/
unsigned char _Conn1GetAttrib(void);


/*********************************************************************
 * Function:        unsigned char _Conn1SetAttrib(void)
 *
 * PreCondition:    
 *
 * Input:       	none
 *                  
 * Output:      	status
 *
 * Side Effects:    
 *
 * Overview:        Handle explicit messaging
 *
 * Note:            None
 ********************************************************************/
unsigned char _Conn1SetAttrib(void);



			   
#endif	/*__CONN1_H__*/
