// -*- mode: java; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*-

package antichess.test;

import java.util.ArrayList;
import java.util.List;

import junit.framework.TestCase;
import antichess.GameDescriptor;
import antichess.Player;


/**
 * Test the GameWriter class
 **/
public class GameDescriptorTests extends TestCase
{
    GameDescriptor[] descriptors;
	List<Player> players0;
	List<Player> players1;
	List<String> playerDescriptions0;
	List<String> playerDescriptions1;
	List<String> playerDescriptions2;
	List<String> playerDescriptions3;
	
	long[] times0;
	long[] times1;
	long[] times2;
	long[] times3;
	
	public GameDescriptorTests() {
		super();
		descriptors = new GameDescriptor[8];
		players0 = new ArrayList<Player>();
		players0.add(Player.WHITE);
		players0.add(Player.BLACK);
		players1 = new ArrayList<Player>();
		players1.add(Player.BLACK);
		players1.add(Player.WHITE);
		
		playerDescriptions0 = new ArrayList<String>();
		playerDescriptions0.add("Human");
		playerDescriptions0.add("AI");
		
		playerDescriptions1 = new ArrayList<String>();
		playerDescriptions1.add("AI");
		playerDescriptions1.add("Human");
		
		playerDescriptions2 = new ArrayList<String>();
		playerDescriptions2.add("AI");
		playerDescriptions2.add("AI");
		
		playerDescriptions3 = new ArrayList<String>();
		playerDescriptions3.add("Human");
		playerDescriptions3.add("Human");
		
		times0 = new long[2];
		times1 = new long[2];
		times2 = new long[2];
		times3 = new long[2];

		times0[0] = 0;
		times0[1] = 0;
		
		times1[0] = 5000;
		times1[1] = 5000;
		
		times2[0] = 100000;
		times2[1] = 20000000;
		
		times3[0] = Long.MAX_VALUE;
		times3[1] = 0;
	}

	//constructs a set of legal GameDescriptors
	private void initializeDescriptors(){
		descriptors[0] = new GameDescriptor("Chess", players0, 
				playerDescriptions0, times0, true);
	
		descriptors[1] = new GameDescriptor("Antichess", players1, 
				playerDescriptions1, times1, true);
		
		descriptors[2] = new GameDescriptor("Chess", players0, 
				playerDescriptions2, times2, true);
	
		descriptors[3] = new GameDescriptor("Antichess", players1, 
				playerDescriptions3, times3, true);
	
		descriptors[4] = new GameDescriptor("Antichess", players0, 
				playerDescriptions0, times0, false);
	
		descriptors[5] = new GameDescriptor("Chess", players1, 
				playerDescriptions1, times1, false);
		
		descriptors[6] = new GameDescriptor("Antichess", players0, 
				playerDescriptions2, times2, false);
	
		descriptors[7] = new GameDescriptor("Chess", players1, 
				playerDescriptions3, times3, false);
	
	
	}
	
	/**
	 * Tests the constructor with a range of legal values.
	 *
	 */
	
	public void testConstructor(){
		try{
			initializeDescriptors();
		}catch (Exception ex){
			fail(ex.getMessage());
		}
	}
	
	/**
	 * Tests getGameTypeName()
	 */
	public void testgetGameTypeName(){
		initializeDescriptors();
		assertEquals(  "Failed to retrieve proper name", "Chess", descriptors[0].getGameTypeName() );
		assertEquals(  "Failed to retrieve proper name", "Antichess", descriptors[1].getGameTypeName() );
	}
	
	/**
	 * Tests getPlayers()
	 */
	public void testGetPlayers(){
		initializeDescriptors();
		assertEquals(   players0, descriptors[0].getPlayers() );
		assertEquals(   players1, descriptors[1].getPlayers() );
	}
	
	/**
	 * Tests getPlayerDescriptions
	 */
	public void testGetPlayerDescriptions(){
		initializeDescriptors();
		assertEquals(   playerDescriptions0, descriptors[0].getPlayerDescriptions() );
		assertEquals(   playerDescriptions1, descriptors[1].getPlayerDescriptions() );
		assertEquals(   playerDescriptions2, descriptors[2].getPlayerDescriptions() );
		assertEquals(   playerDescriptions3, descriptors[3].getPlayerDescriptions() );
	}
	
	/**
	 * Tests getPlayerTimes()
	 */
	public void testGetPlayerTimes(){
		initializeDescriptors();
		assertEquals(   times0, descriptors[0].getPlayerTimes() );
		assertEquals(   times1, descriptors[1].getPlayerTimes() );
		assertEquals(   times2, descriptors[2].getPlayerTimes() );
		assertEquals(   times3, descriptors[3].getPlayerTimes() );
	}
	
	
	/**
	 * Tests getAllowSaveLoad
	 */
	public void testGetAllowSaveLoad(){
		initializeDescriptors();
		assertTrue(descriptors[0].getAllowSaveLoad());
		assertFalse(descriptors[4].getAllowSaveLoad());
		
	}
	
	/**
	 * Tests that illegal argument exceptions are thrown for invalid input
	 */
	public void testExceptionsThrown(){
		boolean missedException;
		
		missedException = true;
		try{
			new GameDescriptor("Cow", players0, 
					playerDescriptions0, times0, true);
		}catch (IllegalArgumentException ex){
			missedException = false;
		}if (missedException){
			fail("Exception not thrown for improper GameTypeName");
		}
		
		List<Player>badPlayers = new ArrayList<Player>();
		badPlayers.add(Player.NONE);
		badPlayers.add(Player.RED);
		
		missedException = true;
		try{
			new GameDescriptor("Chess", badPlayers, 
					playerDescriptions0, times0, true);
		}catch (IllegalArgumentException ex){
			missedException = false;
		}if (missedException){
			fail("Exception not thrown for improper Players");
		}
		
		List<String>badPlayerDescriptions = new ArrayList<String>();
		badPlayerDescriptions.add("Human");
		badPlayerDescriptions.add("Monkey");
		
		missedException = true;
		try{
			new GameDescriptor("Chess", players0, 
					badPlayerDescriptions, times0, true);
		}catch (IllegalArgumentException ex){
			missedException = false;
		}if (missedException){
			fail("Exception not thrown for improper playerDescriptions");
		}
		
		long[] badTimes = {-52, 500};
		
		missedException = true;
		try{
			new GameDescriptor("Chess", players0, 
					playerDescriptions0, badTimes, true);
		}catch (IllegalArgumentException ex){
			missedException = false;
		}if (missedException){
			fail("Exception not thrown for improper playerTimes");
		}
		
		playerDescriptions0.add("Human");
		
		missedException = true;
		try{
			new GameDescriptor("Chess", players0, 
					playerDescriptions0, times0, true);
		}catch (IllegalArgumentException ex){
			missedException = false;
		}if (missedException){
			fail("Exception not thrown for lists of differing sizes");
		}
		
		
		
	}
	
	
	
}
