package antichess.viewgui;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import antichess.*;

import javax.imageio.ImageIO;

/**
 * ImageMap is a class for loading and storing images.  
 * Images are loaded and referenced by their names
 * 
 * 
 * <b>Format of Files</b>
 * Images in the directory are expected to be jpegs with an end of .jpg
 * The specfield directory must not end in an / such that the actual pathname
 * for an image to be loaded is directory+imageName
 * 
 *
 * @specfield directory     //String - stores the parent directory
 * 							//         that images are searched for in.
 * @specfield map			//Map<String, Image>  map maps a string to an image
 *
 */


public class ImageMap {
	private String directory;
	private HashMap<String, BufferedImage> imageMap;
	
	
	/**
	 * @modifies directory
	 * @effects directory = directory
	 */
	
	public ImageMap(String directory){
		this.directory = directory;
		imageMap = new HashMap<String, BufferedImage>();
	}
	
	
	/**
	 * @return the image that imageName references
	 * @throws IllegalArgumentException if the imageName is not contained
	 * 			in the imageMap
	 */
	synchronized public Image getImage(String imageName) throws IllegalArgumentException{
		if (imageMap.containsKey(imageName)){
			return imageMap.get(imageName);
		}else{
			throw new IllegalArgumentException("ImageMap: getImage "+imageName+" is not contained in the map");
		}
		
	}
	
	
	/**
	 * @return true if the image loads, false if it doesn't
	 * @modifies map
	 * @effects adds the map imageName => image in directory with name imageName
	 */
	synchronized public boolean loadImage(String imageName){
		BufferedImage img = null;
		try {
			System.out.println("Loading: " +directory+"/"+imageName+".gif");
			img = ImageIO.read(ControllerMaster.class.getResource(directory+"/"+imageName+".gif"));
		
		} catch (IOException e) {
			return false;
		}
		imageMap.put(imageName, img);
		return true;
	}
	
	
	/**
	 * 
	 * @modifies map
	 * @effects foreach String imageName in imageList
	 * 				adds the map imageName => image in directory with name imageName
	 * @throws IllegalArgumentException if a string in the imageList does not reference an actual image			
	 */
	synchronized public void loadImageList(List<String> imageList) throws IllegalArgumentException{
		for (String img : imageList){
			if (!loadImage(img)){
				throw new IllegalArgumentException("ImageMap: loadImageList "+img+" contained in image list does not reference an actual image");
			}
		}
	}
}
