package antichess.viewgui;

import java.util.List;

import javax.swing.JTextArea;

import antichess.BoardObserver;
import antichess.ChessBoard;
import antichess.ChessMove;
import antichess.Player;

/**
 * MoveHistoryView displays the history for a ChessBoard.
 * MoveHistoryView is a scrollable JTextArea that automatically
 * updates automatically along with the ChessBoard.
 * 
 * @author nlharr
 *
 *
 * @specfield currentBoard 		//ChessBoard
 */



public class MoveHistoryView extends JTextArea implements BoardObserver{
	//Fields
	ChessBoard board;
	
	/**
	 * Creates a new MoveHistoryView
	 * @param board is the baord observed
	 * @param width is the width of the text window
	 * @param height is the height of the text window
	 */
	
	public MoveHistoryView(ChessBoard board, int width, int height){
		super(height, width);
		this.board = board;
		board.addObserver(this);
		if (board.getMoveHistory() == null)
			this.setText("");
		else
			this.setText(moveListToString(board.getMoveHistory().getHistory()));
		this.setEditable(false);
	}
	
	/**
	 * Converts a move to a string
	 */
	private String moveToString(ChessMove move){
		if (move == null)
			return "No move";
		return move.humanReadableString();
	}
	
	
	/**
	 * Converts the moveList into a string.
	 * @return a string representation of the moveList
	 */
	private String moveListToString(List<ChessMove> moveList){
		String tempString = "";
		String newline = System.getProperty("line.separator");
		
		//adds the strings for all the moves in the list
		for (int i=0; i<moveList.size(); i++){
			tempString = tempString.concat(Integer.toString(i+1)+": "+moveToString(moveList.get(i))+newline);
		}
		
		//adds a string if there is a win condition
		if (board.isGameOver()){
			if (board.getWinner().equals(Player.NONE)){
				tempString = tempString.concat("Game Over: Stalemate");
			}else
			{
				tempString = tempString.concat("Game Over: "+
						board.getWinner().toString().substring(0,1)+
						board.getWinner().toString().toLowerCase().substring(1)+

						" Wins");
			}
		}
		return tempString;
	}
	
	/**
	 * Refreshes the text value in the history
	 */
	public void postRefresh(){
		if (board.getMoveHistory() == null)
			this.setText("");
		else
			this.setText(moveListToString(board.getMoveHistory().getHistory()));
		this.setCaretPosition(this.getDocument().getLength());
	}
	
}
