package antichess.viewgui;

import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

import antichess.ControllerMaster;
import antichess.GameDescriptor;
import antichess.Player;

/**
 *  NewGameWindow handles the creation of new games.
 *  It displays a window in which the user can select parameters
 *  for the game and then it tells the master that is called with
 *  to load a game.
 *  
 * 
 * @author nlharr
 *
 * @specfield master				//ControllerMaster that the NewGameWindow notifies to make a new game
 * 
 *
 *
 */


public class NewGameWindow extends JFrame 
			implements ActionListener {
	//Fields
	private ControllerMaster master;
	
	//Abstraction Function
	//master = master
	
	//Representation Invariants
	//master != null
	
	
	
	//private constructor so no public one exists
	private NewGameWindow(String name, ControllerMaster master){
		super(name);
		this.master = master;
		
		if (master == null){
			throw new RuntimeException("master is null");
		}
	}
	
	/**
	 * Creates and displays a NewGameWindow with a master specified by
	 * master.
	 */
	public static void createNewGameWindow(ControllerMaster master){
		NewGameWindow window = new NewGameWindow("New Game", master);
		window.setContentPane(window.getContent());
		window.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		window.setVisible(true);
		window.setSize(220, 260);
		window.setResizable(false);
        window.setVisible(true);
	}
	

	//Some fields we need to get information from
	JButton createNewGameButton;
	JButton cancelButton;
	JComboBox gameType;
	JComboBox whiteTimeList;
	JComboBox whitePlayerList;
	JComboBox blackTimeList;
	JComboBox blackPlayerList;
	private Container getContent(){
		//initializes panels that contain the options for white player
		JPanel whitePlayerInfo = new JPanel();
		
		JLabel whiteLabel = new JLabel("<html><Strong><b>White</b></Strong></html>");
		String[] timeStrings = { "0", 
				"30", "60", "120", 
				"300",  "600", "900"};
		
		String[] gameTypeStrings = {"Antichess", "Chess"};
		gameType = new JComboBox(gameTypeStrings);
		gameType.setSelectedIndex(0);
		gameType.addActionListener(this);
        
		String[] playerStrings = { "Human", "AI"};
        whitePlayerList = new JComboBox(playerStrings);
        whitePlayerList.setSelectedIndex(0);
        whitePlayerList.addActionListener(this);
		
        
        whiteTimeList = new JComboBox(timeStrings);
        whiteTimeList.setSelectedIndex(0);
        whiteTimeList.addActionListener(this);
		
        //adds all the options for the White player
        whitePlayerInfo.add(whiteLabel);
        whitePlayerInfo.add(whitePlayerList);
        whitePlayerInfo.add(whiteTimeList);
        
        whitePlayerInfo.setBorder(BorderFactory.createEtchedBorder());
        
        
		//initializes panels that contain the options for black player
		JPanel blackPlayerInfo = new JPanel();
		
		JLabel blackLabel = new JLabel("<html><Strong><b>Black</b></Strong></html>");
		
        blackPlayerList = new JComboBox(playerStrings);
        blackPlayerList.setSelectedIndex(0);
        blackPlayerList.addActionListener(this);
		
        
        blackTimeList = new JComboBox(timeStrings);
        blackTimeList.setSelectedIndex(0);
        blackTimeList.addActionListener(this);
		
        //adds all the options for the black player
        blackPlayerInfo.add(blackLabel);
        blackPlayerInfo.add(blackPlayerList);
        blackPlayerInfo.add(blackTimeList);
        
        blackPlayerInfo.setBorder(BorderFactory.createEtchedBorder());
        blackPlayerInfo.setPreferredSize(whitePlayerInfo.getPreferredSize());
        
        
        //creates the buttons to either cancel or accept a new game
        createNewGameButton = new JButton("New Game");
        createNewGameButton.addActionListener(this);
        
        cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(this);
        
        //creates the button panel
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.weightx = .5;
        c.gridx = 0;
        c.gridy = 0;
        buttonPanel.add(cancelButton, c);
        c.gridwidth = 1;
        c.gridx = 1;
        buttonPanel.add(createNewGameButton, c);
        
        
        JPanel gameTypePanel = new JPanel(new GridBagLayout());
        c = new GridBagConstraints();
        
        c.weightx = .5;
        c.weighty = .5;
        c.gridwidth = GridBagConstraints.RELATIVE;
        c.gridx = 0;
        c.gridy = 0;
        gameTypePanel.add(new JLabel("  Game Type:    "));
        
        c.gridwidth = GridBagConstraints.REMAINDER;
        c.gridx = 1;
  
        gameTypePanel.add(gameType);        
        gameTypePanel.setBorder(BorderFactory.createEtchedBorder());
        
        JPanel newGamePanel = new JPanel(new GridBagLayout());
        c = new GridBagConstraints();

        
        
        c.weightx = .1;
        c.weighty = .5;
        c.gridy = 0;
        c.gridwidth = GridBagConstraints.REMAINDER;
        c.gridx = 0;
  
        newGamePanel.add(gameTypePanel, c);
        
        
        c.weightx = 1;
        c.gridwidth = 1;
        c.gridy = 1;
        c.gridx = 0;
        newGamePanel.add(new JLabel(""), c);
        c.gridx = 3;
  
        newGamePanel.add(new JLabel("Player"), c);
        
        c.gridx = 5;
        newGamePanel.add(new JLabel("Time"), c);
        c.gridwidth = GridBagConstraints.REMAINDER;
        c.gridx = 0;
        c.gridy = 2;
        newGamePanel.add(whitePlayerInfo, c);
        c.gridy = 3;
        newGamePanel.add(blackPlayerInfo, c);

        c.gridx = 0;
        c.gridy = 4;
        newGamePanel.add(buttonPanel, c);

        newGamePanel.setBorder(BorderFactory.createEtchedBorder());
       
		return newGamePanel;
	}
	
	//Generates an appropriate game descriptor from the fields
	private GameDescriptor generateNewGameDescriptor(){
		ArrayList<Player> playerList = new ArrayList<Player>();
		playerList.add(Player.WHITE);
		playerList.add(Player.BLACK);
		
		ArrayList<String> descriptions = new ArrayList<String>();
		descriptions.add((String)whitePlayerList.getSelectedItem());
		descriptions.add((String)blackPlayerList.getSelectedItem());
		
		
		long[] times = {1000*Long.valueOf((String) whiteTimeList.getSelectedItem()),
						1000*Long.valueOf((String) blackTimeList.getSelectedItem())};
		
		
		return new GameDescriptor((String)gameType.getSelectedItem(), playerList, descriptions,
				times, false);
	}
	
	//Tells the master to start a new game
	private void startNewGame(){
		master.startNewGame(this.generateNewGameDescriptor());
	}
	
	
	
	public void actionPerformed(ActionEvent event){
		if (event.getSource().equals(cancelButton)){
			this.dispose();
		}else if (event.getSource().equals(createNewGameButton))
		{
			this.startNewGame();
			this.dispose();
		}
	}
	
	
}
